/*
 * this module manages the server side of an SSH connection from the time
 * the encryption is turned on (SSH_CMSG_SESSION_KEY confirmed) to the
 * time the credentials of the remote end are established (authentication
 * phase).
 *
 * Authentication phase is handled as a big loop, reading authentication
 * messages and responding until a successful login or a timeout has occurred.
 */
#include "user_info.h"
int sshlgn_initialize ( 
	int *auth_types, 		/* Returns auth types allowed */
	char *errmsg );

int sshlgn_authenticate ( sshsess_session session, 
	struct user_account_info *uai,	/* Holds data read from SYSUAF */
	void **ext_auth_info, 		/* other, based on auth_type */
	char *errmsg );
