#include "completion_port.h"
/*
 * Define message codes (0-122)
 */
#define SSH_MSG_NONE 0
#define SSH_MSG_DISCONNECT 1
#define SSH_SMSG_PUBLIC_KEY 2
#define SSH_CMSG_SESSION_KEY 3
#define SSH_CMSG_USER 4
#define SSH_CMSG_AUTH_RHOSTS 5
#define SSH_CMSG_AUTH_RSA 6
#define SSH_SMSG_AUTH_RSA_CHALLENGE 7
#define SSH_CMSG_AUTH_RSA_RESPONSE 8
#define SSH_CMSG_AUTH_PASSWORD 9

#define SSH_CMSG_REQUEST_PTY 10
#define SSH_CMSG_WINDOW_SIZE 11
#define SSH_CMSG_EXEC_SHELL 12
#define SSH_CMSG_EXEC_CMD 13
#define SSH_SMSG_SUCCESS 14
#define SSH_SMSG_FAILURE 15
#define SSH_CMSG_STDIN_DATA 16
#define SSH_SMSG_STDOUT_DATA 17
#define SSH_SMSG_STDERR_DATA 18
#define SSH_CMSG_EOF 19

#define SSH_SMSG_EXITSTATUS 20
#define SSH_MSG_CHANNEL_OPEN_CONFIRMATION 21	/* "ii" */
#define SSH_MSG_CHANNEL_OPEN_FAILURE 22		/* "i" */
#define SSH_MSG_CHANNEL_DATA 23			/* "is" */
#define SSH_MSG_CHANNEL_CLOSE 24		/* "i" */
#define SSH_MSG_CHANNEL_CLOSE_CONFIRMATION 25	/* "i" */
#define SSH_CMSG_X11_REQUEST_FORWARDING 26	/* obsolete */
#define SSH_SMSG_X11_OPEN 27			/* "i" */
#define SSH_CMSG_PORT_FORWARD_REQUEST 28	/* "isi" */
#define SSH_MSG_PORT_OPEN 29			/* "isi" */

#define SSH_CMSG_AGENT_REQUEST_FORWARDING 30
#define SSH_SMSG_AGENT_OPEN 31			/* "i" */
#define SSH_MSG_IGNORE 32			/* "s" */
#define SSH_CMSG_EXIT_CONFIRMATION 33
#define SSH_CMSG_X11_FWD_WITH_AUTH_SPOOFING 34	/* "ss" */
#define SSH_CMSG_AUTH_RHOSTS_RSA 35		/* "simm" */
#define SSH_MSG_DEBUG 36			/* "s" */
#define SSH_CMSG_REQUEST_COMPRESSION 37		/* "i" */
#define SSH_CMSG_MAX_PACKET_SIZE 38		/* "i" */

#define SSH_PROTOFLAG_SCREEN_NUMBER 1		/* change 34 to "ssi" */
#define SSH_PROTOFLAG_HOST_IN_FWD_OPEN 2	/* */
/*
 * Function prototypes in sshmsg.c
 */
/*
 *  sshmsg_scan extracts the fields of a message to data fields according
 *  to a format string, format codes are:
 *        i	32-bit integer, stored into next arg in host order.
 *	  m	multi-precision integer, stored into next 2 args.
 *	 nb	'n' bytes (e.g. 8b).
 *	  s	Counted string, stored into next 2 args: count and pointer.
 */
/*
 * A locus is a processing point for mananging 'local' strings that dynamically
 * size themselves.
 */
typedef void *sshmsg_locus;             /* opaque type */
struct sshmsg_local_message {
    short type;				/* message type */
    short bufnum;			/* locus buffer number or 0 */
    int length;				/* Length of data portion */
    char *data;				/* data portion of message */
    sshmsg_locus locus;			/* back pointer to 'owning' locus */
};
typedef struct sshmsg_local_message sshmsg_local;
/* 
 * Callback routine for message trapping is called with the following
 * arguments:
 *      arg	void *, argument specified by caller.
 *      msg	sshmg_local, recieved message.
 * Return value:
 *      0	Continue, ignore message.
 *	1	Deliver message.
 *	2	Fatal error, kill thread.
 */
typedef int (*sshmsg_trap_handler)(void *, sshmsg_local *);
int sshmsg_set_message_trap( sshmsg_locus, 
	int range_start, int range_end,		/* message types */
	sshmsg_trap_handler, void *arg );
/*
 * Low level routines
 */
sshmsg_locus *sshmsg_create_locus ( sshpad pad, int initial_locals );
int sshmsg_init_locals ( sshmsg_locus locus, int count, ... );
int sshmsg_rundown_locals ( sshmsg_locus );		/* implied stall */
void sshmsg_destroy_locus ( sshmsg_locus locus );
/*
 * Mid-level: message construction and async I/O
 */
int sshmsg_scan_message ( sshmsg_local *, ... );
int sshmsg_format_message ( sshmsg_local *, int type, ... );
char *sshmsg_last_error_text(sshmsg_locus);
/*
 * High level routines, synchronous I/O
 */
cport_stream_handler cportsshmsg_driver;
