/*
 * Define routines for SSH Packet Assembler/Disassembler (PAD) driver for
 * completion port.
 *
 * The PAD layer handles converting SSH messages to send their encrypted
 * form and recieving decrypted messages.
 *
 * I/O of the encrypted packets takes place over a TCP/IP connection
 * opened via the tclient_tcp.h interface.
 *
 * Integer return values of functions are odd for success, even for failure.
 */
#include "completion_port.h"
typedef void *sshpad;		/* opaque data type */

#define SSHPAD_DEFAULT_PROTOCOL "SSH-1.1-OSU_SSHPAD\n"
#define SSHPAD_MODE_SERVER 1
#define SSHPAD_MODE_CLIENT 0
/*
 * Masks for flags returned by stall routine.
 */
#define SSHPAD_WRITE_DONE 1
#define SSHPAD_READ_DONE 2
#define SSHPAD_ERROR_DETECTED 4
#define SSHPAD_INTERRUPT 8
#define SSHPAD_DATA_OVERRUN 32
/*
 * Initialize new pad structure and do initial handshake (protocol exchange).
 */
sshpad sshpad_create (
	cport_port port,		/* handle for i/o dispatcher */
	void *tcp_context,		/* handle for tcp connection */
	int is_server,			/* true if is server */
	char *our_protocol,		/* SSH protocol string */
	char remote_protocol[128],	/* string received from remote */
	char errmsg[256] );

int sshpad_destroy ( sshpad pad );	/* teardown PAD structure */
int sshpad_set_encryption ( sshpad pad,
	int (*inbound)(void *, char *, int), void *in_state,
	int (*outbound)(void *, char *, int), void *out_state );
int sshpad_set_max_packet ( sshpad pad, int max_packet_size );
/*
 * Define additional opcodes.  Message type for received data is
 * in iosb[3];
 */
#define CPORT_SSHPAD_SEND_TYPE CPORT_FCODES+0
#define CPORT_SSHPAD_RETRY_READ CPORT_FCODES+1
cport_stream_handler cportsshpad_driver;
