/*
 * Includes for data types used in structures.  You must define sslinc to
 * point to SSLeay's include directory.
 */
#include "completion_port.h"
#include "cport_sshpad.h"
#include "sshrsa.h"			/* RSA keys */
#include "cport_sshmsg.h"
#include "sslinc:md5.h"
/*
 * Define authentication methods.
 */
#define SSH_AUTH_RHOSTS       1   /* .rhosts or /etc/hosts.equiv */
#define SSH_AUTH_RSA          2   /* pure RSA authentication */
#define SSH_AUTH_PASSWORD     3   /* password authentication */
#define SSH_AUTH_RHOSTS_RSA   4   /* .rhosts with RSA host authentication */
/*
 * Define cipher method codes.
 */
#define   SSH_CIPHER_NONE   0      /* no encryption */
#define   SSH_CIPHER_IDEA   1      /* IDEA in CFB mode */
#define   SSH_CIPHER_DES    2      /* DES in CBC mode */
#define   SSH_CIPHER_3DES   3      /* Triple-DES in CBC mode  */
#define   SSH_CIPHER_TSS    4      /* An experimental stream cipher */
#define   SSH_CIPHER_RC4    5      /* RC4 */
#define   SSH_CIPHER_BLOWFISH 6	  /* blowfish */
/*
 * session control block.
 */
typedef struct sshsess_server_st {
    /*
     * Following fields are used in construction of ssh_smsg_public_key message.
     */
    int skey_bits;			/* server key. */
    int skey_exp_bits;
    int hkey_bits;
    int hkey_exp_bits;
    char *skey_value;
    char *skey_exp_value;
    char *hkey_value;
    char *hkey_exp_value;
    int protocols;			/* reserved for protocol options */
    int ciphers;			/* bit-mask of allowed ciphers */
    int authentications;		/* bit-mask of allowed authentications*/
    /*
     * Following fields are used internally.  Pre_digest is MD5 of initial
     * portion of session_id's, which is alway skey_value//hkey_value.
     */
    sshrsa server_key;			/* server (private) key  */
    sshrsa host_key;			/* host (private) key */
    MD5_CTX pre_digest;
} *sshsess_server;		/* context for server */

#ifndef SSHCIPHER_STATE
union cipher_state { long l; };
#define SSHCIPHER_STATE union cipher_state	/* force longword aligment */
#endif

typedef struct sshsess_session_st
{
    sshpad pad;				/* Comm link with remote */
    int remote_port;			/* TCP/IP port number */
    unsigned char remote_host[16];	/* Remote IP address */
    char *hostname;			/* null if unknown */
    /*
     * Server context pointed to by server_ctx may be shared by multiple
     * sessions, pointer only points to server context if this is
     * the server side of the connection, NULL means session is client-side.
     */
    struct sshsess_server_st *server_ctx;
    /*
     * Locus is structure for managing message traffic.
     */
    sshmsg_locus locus;
    /*
     * completion port manages synchronizaing multiple stream of I/O
     */
    cport_port cport;
    cport_isb out_msg;			/* outbound message stream */
    cport_isb in_msg;			/* inbound message stream */
    /*
     * General encryption related fields.
     */
    sshrsa server_key, host_key;	/* If client, only holds public keys */
    int protocol_flags;			/* protcol extension flags */
    int cipher;				/* chosen cipher */
    char cookie[8];			/* rand data supplied by server */
    unsigned char session_id[MD5_DIGEST_LENGTH];	
					/* MD5(skey_mod+hkey_mod+cookie) */
    unsigned char session_key[32];
    /*
     * Authentication-related fields (client credentials).
     */
    int auth_type;			/* code for authorization type */
    char username[40];
    char *ext_username;			/* allocated iff username > 39 chars */
    /*
     * local execution environment (PTYs, pipes, etc), for use by application
     * layers.  Fields are initialized to null by ssh_new_session().
     */
    int exec_state;
    void *exec_env;
    /*
     * Cipher-specific contexts for encryption.
    */
    int (*inbound)(void *, char *, int);
    void *in_state;
    int (*outbound)(void *, char *, int);
    void *out_state;
    SSHCIPHER_STATE cstate;		/* variable length */

} *sshsess_session;

sshsess_server sshsess_server_context ( char *skey_file, char *hkey_file,
	int ciphers, int auth_types, char errmsg[256] );
sshsess_server sshsess_server_copy ( char *skey_file, sshsess_server orignal,
	char errmsg[256] );
void sshsess_destroy_server_context ( sshsess_server ctx );

sshsess_session sshsess_new_session ( sshsess_server ctx, 
	cport_port port, sshpad pad,
	char *cipher_prefs, char *auth_prefs, char errmsg[256] );

int sshsess_rundown ( sshsess_session ctx );

int sshsess_cipher_number ( char *name );
char *sshsess_cipher_name ( int number );
