/*
 * Define prototypes for auxillary functions for using the cportucx_driver
 * stream handler.
 */
#include "completion_port.h"
/*
 * To receive new connection on the listen channel returned by 
 * cportucx_create_tcp_listen, bind it to a stream and issue a 
 * cport_start_io operation with the function code CPORTUCX_ACCEPT and
 * the address of a cportucx_accept_result structure as the buffer argument.
 */
#define CPORTUCX_ACCEPT CPORT_FCODES+0
struct cportucx_accept_result {
    void *io_ctx;			/* I/O channel for new connection */
    int remote_port;			/* TCP/IP port number */
    unsigned char remote_address[32];	/* IP address (first 4 bytes */
};

cport_stream_handler cportucx_driver;

int cportucx_open_tcp_socket ( 
	char *target_host, 		/* TCP/IP host name to connect to */
	int target_port,		/* TCP/IP port number */
	int attr_count,	
 	char **attributes, 		/* socket options */
	void **io_ctx, 			/* Returns handle to I/O context */
	int (*reg_cb)(int,int,void *),	/* registers assigned port numbers */
	void *reg_arg,			/* additional argument for callback */
	char errmsg[256] );		/* Error diagnositc text */

int cportucx_create_tcp_listener (
	int port,			/* TCP/IP port number */
	int backlog,			/* listen queue depth */
	int att_count,
	char **attributes,		/* socket options */
	void **listen_ctx,		/* channel number of created socket */
	char errmsg[256] );		/* Error diagnositc text */
