/*
 * Define prototypes for auxillary functions for using the cportx11_driver
 * stream handler.
 */
#include "completion_port.h"
/*
 * To receive new connection on the listen channel returned by 
 * cportx11_create_x11_listen, bind it to a stream and issue a 
 * cport_start_io operation with the function code CPORTX11_ACCEPT and
 * the address of a cportx11_accept_result structure as the buffer argument.
 */
#define CPORTX11_ACCEPT CPORT_FCODES+0
struct cportx11_accept_result {
    void *io_ctx;			/* I/O channel for new connection */
    char remote_address[32];		/* hostname */
};

cport_stream_handler cportx11_driver;

int cportx11_create_x11_listener (
	char *username,			/* allowed username */
	int *server_number,		/* X11 server number allocated */
	void **listen_ctx,		/* channel number of created socket */
	char errmsg[256] );		/* Error diagnositc text */
