! MMS file for building ssh_server components.  Options selected by
! /macro=(...):
!
!   NOSHARE	If defined, do not build/link against sshcryptoshr image.
!		If defined, SSLCRYPTO  must be specified as well.
!
!   SSLCRYPTO	File specification or logical for SSLeay or OpenSSL library 
!		containing cryptographic routines.  Default is ssl_crypto_lib.
!
! The include file is responsible for defining the sslib and sslinc macros
!
.include ssl_location.mms
.ifdef DONT_TRY
cflags = /define=DONT_TRY/list
.endif

.ifdef ssllib

.first
  is_cmd_proc = (f$environment("DEPTH") .gt. 0)
  if is_cmd_proc then sv_vfy = f$verify(1)
  if is_cmd_proc then @ssl_location.com
  @ if f$trnlnm("ssllib") .eqs. "" then define ssllib $(ssllib)
  @ if f$trnlnm("sslinc") .eqs. "" then define sslinc $(sslinc)
  @ is_axp = (f$getsyi("CPU") .ge. "128")
  @ if is_axp .or. f$trnlnm("DECC$CC_DEFAULT") .eqs. "/DECC" then -
	define/nolog pthread_libs pthread_libs_axp
  @ if is_axp .and. f$search("sys$share:pthread$rtl.exe") .nes. "" then -
	define/nolog pthread_libs pthread_libs_v7
  @ if is_axp .and. f$search("sys$share:pthread$rtl.exe") .nes. "" then -
	kt_enable = "/THREADS_ENABLE=(UPCALLS,MULTIPLE)"
  @ show translation ssllib
  @ show translation sslinc
  @ if f$trnlnm("pthread_libs") .nes. "" then show translation pthread_libs
.last
  @ if is_cmd_proc then sv_vfy = f$verify(sv_vfy)
.else
.first
  @ if f$environment("DEPTH") .gt. 0 then sv_vfy = f$verify(1)
  @ write sys$output "Environment not configured, edit file ssl_location.mms"
  exit

.last
  @ if f$environment("DEPTH") .gt. 0 then sv_vfy = f$verify(sv_vfy)
.endif  
!
! Common objects for bother servers and clients.
!
sshobjs = sshpad.obj sshmsg.obj sshsess.obj sshrsa_rpc.obj helper.obj tutil.obj tmemory.obj

.ifdef sslcrypto
.else
sslcrypto = ssl_crypto_lib
.endif

.IFDEF NOSHARE
cryptlib = sshrsa_rpc.obj helper.obj ssl_mt.obj sshcipher.obj
cryptlink = sshrsa_rpc.obj,sshcipher.obj,helper.obj,$(sslcrypto)/lib,sys$disk:[]ssl_mt.obj
cryptlink1 = sshrsa_rpc.obj,helper.obj,sshcipher.obj,$(sslcrypto)/lib,sys$disk:[]ssl_mt.obj
cryptlink2 = sshrsa_rpc.obj,helper.obj,sshcipher.obj,tutil.obj,pthread_libs/opt,$(sslcrypto)/lib,sys$disk:[]ssl_mt.obj
.ELSE
cryptlib = sshcryptoshr.exe
cryptlink = sshcrypto.opt/opt
cryptlink1 = sshcrypto.opt/opt
cryptlink2 = sshcrypto.opt/opt
.ENDIF

all : ssh_server.exe initiator.exe rsa_engine.exe key_generator.exe -
	ssh_loginout.exe sethost_ssh.exe ft_accpornam.exe
  write sys$Output "Images built"
!
! ssh server daemon.
!
ssh_server.exe : ssh_server.opt sshcrypto.opt $(cryptlib) ssh_server.obj -
	monitor.obj cport_admin.obj cport_noprocess.obj cport_x11.obj -
	server_session.obj completion_port.obj cport_ucx.obj cport_pipe.obj -
	cport_sshpad.obj cport_sshmsg.obj cport_sshsess.obj parameters.obj -
	cport_sshlogin.obj tutil.obj tmemory.obj server_session.obj -
	user_info.obj cport_pty.obj cport_cmd.obj event_report.obj -
	port_forwarder.obj port_fwd_dispatch.obj os_info.obj helper.obj -
	initiator_client.obj pty_map.obj
    LINK 'kt_enable' ssh_server.opt/opt,$(cryptlink),pthread_libs/opt

rsa_engine.exe : rsa_engine.obj helper_com.obj sshcrypto.opt $(cryptlib) 
    link rsa_engine.obj,helper_com.obj,$(cryptlink2)

key_generator.exe : key_generator.obj sshcrypto.opt $(cryptlib) helper_com.obj
    link key_generator.obj,helper_com.obj,$(cryptlink2)

sshcryptoshr.exe : sshcryptoshr_link.com sshrsa_rpc.obj helper.obj ssl_mt.obj -
	sshcipher.obj tutil.obj
    @sshcryptoshr_link $(sslcrypto)

sethost_ssh.exe : sethost_ssh.opt $(cryptlib) sethost_ssh.obj -
	cport_terminal.obj completion_port.obj cport_ucx.obj cport_sshpad.obj -
	cport_sshmsg.obj cport_sshsess.obj os_info.obj tutil.obj tmemory.obj
    LINK sethost_ssh.opt/opt,$(cryptlink1),pthread_libs/opt

sshrsa_rpc.obj : sshrsa_rpc.c sshrsa.h tutil.h sshrsa_rpc.h helper.h -
	$(sslinc)des.h $(sslinc)pem.h $(sslinc)rsa.h $(sslinc)rand.h
  IF F$GETSYI("CPU") .GE. 128 .OR. F$TRNLNM("DECC$CC_DEFAULT") .EQS. "/DECC" -
       	THEN prefix_all = "/prefix=all"
  cc $(cflags) sshrsa_rpc/include=sslinc 'prefix_all'

sshcryptvec.obj : sshcryptvec.mar
  macro sshcryptvec.mar

ssl_mt.obj : ssl_mt.c $(sslinc)crypto.h
  cc $(cflags) ssl_mt.c/include=sslinc/define=(flat_inc,vms)

ssh_server.obj : ssh_server.c parameters.h completion_port.h cport_sshsess.h -
	cport_sshlogin.h cport_ucx.h event_report.h sshrsa.h tmemory.h -
	sshcipher.h helper.h user_info.h tutil.h monitor.h pty_map.h
  cc $(cflags) ssh_server.c

monitor.obj : monitor.c parameters.h completion_port.h cport_sshsess.h -
	cport_sshlogin.h cport_ucx.h event_report.h sshrsa.h tmemory.h -
	sshcipher.h helper.h user_info.h tutil.h monitor.h
  cc $(cflags) monitor.c


sshcipher.obj :  sshcipher.c sshcipher.h cport_sshsess.h tmemory.h tutil.h
  cc $(cflags) sshcipher.c

tutil.obj : tutil.c tutil.h ctype_np.h
  cc $(cflags) tutil.c

user_info.obj : user_info.c user_info.h tutil.h pthread_1c_np.h
  cc $(cflags) user_info.c

tmemory.obj : tmemory.c tmemory.h pthread_1c_np.h
  cc $(cflags) tmemory.c

event_report.obj : event_report.c event_report.h pthread_1c_np.h tutil.h -
	parameters.h
  cc $(cflags) event_report.c

os_info.obj : os_info.c pthread_1c_np.h
  cc $(cflags) os_info.c

pty_map.obj : pty_map.c tutil.h parameters.h pty_map.h event_report.h
  cc $(cflags) pty_map.c

ft_accpornam.exe : build_ft_accpornam.com
  @build_ft_accpornam.com

cport_pipe.obj : cport_pipe.c cport_pipe.h completion_port.h
  cc $(cflags) cport_pipe.c

cport_ucx.obj : cport_ucx.c cport_ucx.h completion_port.h tutil.h -
	pthread_1c_np.h
   multinet_opt = ""
  if f$search("sys$share:ucx$inetdef.h") .eqs. "" then multinet_opt = "/define=MULTINET"
  cc $(cflags) cport_ucx.c 'multinet_opt'

cport_x11.obj : cport_x11.c cport_x11.h completion_port.h tutil.h -
	pthread_1c_np.h
  cc $(cflags) cport_x11.c

cport_sshsess.obj : cport_sshsess.c cport_sshsess.h tutil.h tmemory.h -
	sshcipher.h $(sslinc)rand.h 
  cc $(cflags) cport_sshsess.c

cport_sshpad.obj : cport_sshpad.c cport_sshpad.h pthread_1c_np.h tutil.h -
	cport_ucx.h
  cc $(cflags) cport_sshpad.c

cport_sshmsg.obj : cport_sshmsg.c cport_sshmsg.h cport_sshpad.h tmemory.h
  cc $(cflags) cport_sshmsg.c

cport_sshlogin.obj : cport_sshlogin.c cport_sshlogin.h cport_sshsess.h -
	tutil.h parameters.h user_info.h
  cc $(cflags) cport_sshlogin.c

cport_pty.obj : cport_pty.c pthread_1c_np.h completion_port.h tutil.h -
	tmemory.h parameters.h user_info.h pty_map.h
  cc $(cflags) cport_pty.c

cport_cmd.obj : cport_cmd.c pthread_1c_np.h completion_port.h tutil.h -
	tmemory.h parameters.h user_info.h pty_map.h
  cc $(cflags) cport_cmd.c

cport_admin.obj : cport_admin.h cport_admin.c pthread_1c_np.h parameters.h -
	completion_port.h user_info.h tmemory.h tutil.h cport_sshsess.h helper.h
  cc $(cflags) cport_admin.c

cport_noprocess.obj : cport_noprocess.h cport_noprocess.c parameters.h -
	completion_port.h user_info.h tmemory.h tutil.h cport_sshsess.h
  cc $(cflags) cport_noprocess.c

completion_port.obj : completion_port.c completion_port.h pthread_1c_np.h -
	tutil.h tmemory.h
  cc $(cflags) completion_port.c

server_session.obj : server_session.c cport_sshsess.h cport_sshlogin.h -
	tutil.h tmemory.h event_report.h parameters.h port_forwarder.h -
	user_info.h cport_admin.h cport_noprocess.h
  cc $(cflags) server_session.c

cport_ucx.h : completion_port.h
  set file/extend=0 cport_ucx.h

cport_sshsess.h : completion_port.h cport_sshpad.h sshrsa.h cport_sshmsg.h -
	$(sslinc)md5.h $(sslinc)des.h $(sslinc)idea.h $(sslinc)rc4.h -
	$(sslinc)blowfish.h
  set file/ext=0 cport_sshsess.h

cport_sshpad.h : completion_port.h
  set file/extend=0 cport_sshpad.h

cport_sshmsg.h : completion_port.h
  set file/extend=0 cport_sshmsg.h

cport_terminal.obj : completion_port.h cport_terminal.h
  cc $(cflags) cport_terminal.c

rsa_engine.obj : rsa_engine.c sshrsa.h sshrsa_rpc.h helper_com.h
  cc $(cflags) rsa_engine.c

parameters.obj : parameters.c parameters.h
  cc $(cflags) parameters.c

port_forwarder.obj : port_forwarder.c port_forwarder.h parameters.h -
	pthread_1c_np.h tmemory.h event_report.h completion_port.h -
	cport_pipe.h cport_sshpad.h cport_sshmsg.h tutil.h
  cc $(cflags) port_forwarder.c

port_fwd_dispatch.obj : port_fwd_dispatch.c port_forwarder.h parameters.h -
	pthread_1c_np.h tmemory.h event_report.h completion_port.h -
	cport_pipe.h cport_sshpad.h cport_sshmsg.h cport_ucx.h
  cc $(cflags) port_fwd_dispatch.c

helper.obj : helper.c helper.h event_report.h pthread_1c_np.h
  cc $(cflags) helper.c

helper_com.obj : helper_com.c helper_com.h
  cc $(cflags) helper_com.c

initiator_client.obj : initiator_client.c initiator.h initiator_client.h -
	user_info.h
  cc $(cflags) initiator_client.c

initiator.exe : initiator.obj tutil.obj helper_com.obj
  link initiator.obj,tutil.obj,helper_com.obj

initiator.obj : initiator.c initiator.h initiator_client.h tutil.h helper_com.h
  cc $(cflags) initiator.c

ssh_loginout.exe : ssh_loginout.obj
  link/notrace ssh_loginout.obj

ssh_loginout.obj : ssh_loginout.c
  cc $(cflags) ssh_loginout.c
