/*  Handle posting of events to event formatting process for logging to
 *  file.
 *
 * The evr_event function uses a variable argument list, controlled by
 * the ctl parameter.  The control string follows a simplified 'printf'
 * format for argument substitutions:
 *
 *    %d	Insert integer formatted as decimal.
 *    %x	Insert intger formatted as hexadecimal.
 *    %t	Insert system time (VMS format), null uses current time.
 *    %s	Insert nul-terminted ascii string.
 *    %a	Insert internet address.
 *
 *  Author:  David Jones
 *  Date:    19-MAY-1998
 *  Revised: 12-JUL-1998		add %x
 *  Revseid: 7-AUG-1998			fix bug in %x processing.
 */
#include <stdio.h>
#include <stdarg.h>

#include "parameters.h"
#include "pthread_1c_np.h"
#include "tutil.h"
#include "event_report.h"

static pthread_key_t evr_key;
static int main_thread_tag;		/* special dummy address */

static void evr_rundown ( void *evr_tag_ptr )
{
    return;
}

int evr_initialize ( )
{
    /*
     * Create the pthreads object.
     */
    CREATE_KEY ( &evr_key, evr_rundown );
    /*
     * Spawn for formatter.
     */
    if ( *param.event_fmt ) {
    }
    evr_open_report ( &main_thread_tag );
    return 1;
}
/***************************************************************************/
/*
 * Open and close report functions set the thread-specific key value used
 * to prefix every report.
 */
int evr_open_report ( int *index )
{
    pthread_setspecific ( evr_key, index );
    return 1;
}
int evr_close_report ( )
{
    pthread_setspecific ( evr_key, (void *) 0 );
    return 1;
}
/*****************************************************************************/
/* Post event.
 */
int evr_event ( int event_type, char *ctl, ... )
{
    va_list ap;
    char c, *str, line[512];
    int *tag, prefix_len, i, j, k, value;
    /*
     * Construct prefix string.
     */
    GET_SPECIFIC ( evr_key, tag );
    if ( !tag ) {
	tu_strcpy ( line, "unknown thread" );
    } else if ( tag != &main_thread_tag ) {
	tu_strcpy ( line, "thread " );
	tu_strint ( *tag, &line[7] );
    } else {
	tu_strcpy ( line, "main thread" );
    }
    j = tu_strlen ( line );
    line[j++] = ':';
    line[j++] = ' ';
    /*
     * Build output string.
     */
    va_start(ap, ctl);
    for ( i = 0; ctl[i]; i++ ) {
	c = ctl[i];
	if ( c == '%' ) {
	    i++;
	    c = ctl[i];
	    if ( c == '%' ) {
		if ( j >= (sizeof(line)-1) ) break;
		line[j++] = '%';
	    } else if ( c == 'd' ) {		/* integer */
		if ( (j+15) >= (sizeof(line)-1) ) break;
		value = va_arg ( ap, int );
		tu_strint ( value, &line[j] );
		j = j + tu_strlen ( &line[j] );
	    } else if ( c == 'x' ) {		/* hex longword */
		int k, nibble;
		static char digit[16] = { '0', '1', '2', '3', '4', '5', '6',
		   '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
		if ( (j+8) >= (sizeof(line)-1) ) break;
		value = va_arg ( ap, int );
		for ( k = 7; k >= 0; --k ) {
		    nibble = value&15;
		    value = value>>4;
		    line[j+k] = digit[nibble];
		}
		j += 8;
		line[j] = '\0';
	    } else if ( c == 's' ) {
		str = va_arg ( ap, char * );
		if ( !str ) str = "";
		k = tu_strlen ( str );
		if ( (j+k) >= (sizeof(line)-1) ) break;
		tu_strcpy ( &line[j], str );
		j += k;
	    } else if ( c == 't' ) {
		long *tbuf;
		int timlen, status, SYS$ASCTIM();
		struct { int length; char *data; } timbuf;

		if ( (j+24) >= (sizeof(line)-1) ) break;
		tbuf = va_arg ( ap, long * );

		timbuf.length = 24; timbuf.data = &line[j];
		timlen = 0;
		status = SYS$ASCTIM ( &timlen, &timbuf, tbuf, 0 );
		j += timlen;
	    } else if ( c == 'a' ) {
		unsigned char *p;
		if ( (j+16) >= (sizeof(line)-1) ) break;
		p = va_arg ( ap, unsigned char *);
		tu_strint ( *p, &line[j] );
		p++; j += tu_strlen ( &line[j] ); line[j++] = '.';
		tu_strint ( *p, &line[j] );
		p++; j += tu_strlen ( &line[j] ); line[j++] = '.';
		tu_strint ( *p, &line[j] );
		p++; j += tu_strlen ( &line[j] ); line[j++] = '.';
		tu_strint ( *p, &line[j] );
		p++; j += tu_strlen ( &line[j] );
	    }
	} else {
	    if ( j >= (sizeof(line)-1) ) break;
	    line[j++] = c;
	}
    }
    va_end ( ap );
    line[j] = '\0';
    /*
     * output to log file.
     */
    pthread_lock_global_np();
    fprintf(stdout, "%s\n", line );
    pthread_unlock_global_np();

    return 1;
}
