/*
 * Prototypes for event reporting routines (evr).  Program initialization
 * must call evr_initialize with the command to spawn the event
 * formatter program as it's argument.
 *
 * The evr_event function uses a variable argument list, controlled by
 * the ctl parameter.  The control string follows a simplified 'printf'
 * format for argument substitutions:
 *
 *    %d	Insert integer formatted as decimal.
 *    %t	Insert system time (VMS format), null uses current time.
 *    %s	Insert nul-terminted ascii string.
 *    %a	Insert internet address.
 */
int evr_initialize ( );
int evr_event ( int event_type, char *ctl, ... );
int evr_open_report ( int *index );
int evr_close_report ( );
/*
 * Event code for events.
 */
#define EVR_NEW_CONNECTION 1		/* new connection */
#define EVR_NEW_SESSION 2		/* Key exchanged */
#define EVR_LOGIN 3			/* New successful login */
#define EVR_LOGFAIL 4			/* Login failure */
#define EVR_CONFIG 5			/* configuration/startup message */
#define EVR_EXCEPTION 6			/* fatal execption */
#define EVR_EXIT 7			/* session completed */
#define EVR_DEBUG 8
