/*
 * Prototypes for low level routines for managing creation and communication
 * with 'helper' sub-processes.
 */
struct helper_context {
    int channel;			/* mailbox channel */
    long pid;				/* Process ID of spawned process */
    long deadman[2];			/* LKSB for deadman lock */
    pthread_mutex_t lock;		/* Used to serialize access */
    pthread_mutex_t io;
    pthread_cond_t io_done;
};
typedef struct helper_context *helper_ctx;

int helper_create ( 
	char *mailbox_name,		/* Mailbox name for CREMBX */
	int mailbox_size,		/* max message size/ msg quota */
	char *command,			/* DCL command to spawn */
	helper_ctx ctx );
/*
 * Acquire exclusive access to helper channel.
 */
int helper_lock ( helper_ctx helper );
int helper_unlock ( helper_ctx helper );

int helper_write ( helper_ctx helper, void *buffer, int bufsize );
int helper_read ( helper_ctx helper, void *buffer, int bufsize, int *recvd );
int helper_restart();
