/*
 * Define constants and mailbox message formats used for communication
 * with initiator process.
 */
#define SSH_INITIATOR_MAILBOX_NAME "SSH_INITIATOR_MAILBOX"

struct initiator_request {
    long uic;				/* Process UIC */
    int ulen;				/* username length */
    int inp_len;			/* input device. */
    int out_len;			/* output define length, may be 0 */
    int is_shell;			/* true if shell desired, modes: */
					/* 1-normal, 2-do VMS authentication */
    char str[192];			/* username+input+output */
};

struct initiator_reply {
   int status;				/* request status */
   long pid;				/* process ID of created process */
   int pindex;				/* process index */
};
