/*
 * Define global structure to hold the parameters set by the SSH configuration
 * file.   The file defines 3 types of data:
 *    integer		int
 *    string		char *
 *    string list	struct list_element *
 */
struct parameter_list_elem {
    struct parameter_list_elem *next;
    char value[1];			/* variable allocation */
};
struct parameter_mlist_elem {		/* multi-level list */
    struct parameter_mlist_elem *next;
    struct parameter_list_elem *child;
    char value[1];			/* variable allocation */
};

struct {
    struct parameter_list_elem *ports;	/* TCP port number to listen on */
    int login_timeout;	/* Seconds within which new login must authenticate */
    int max_client;
    int decnet_cmd;	/* Enable DECNet-based command execution */
    char *hkey_file;	/* File specification of host key file */
    char *skey_file;	/* File spec. of server key file */
    char *event_fmt;	/* External program to process event report/loggint */
    char *event_log;	/* file specification of event log */
    struct parameter_list_elem *auth_types;	/* list of auth types allowed */
    struct parameter_list_elem *ciphers;	/* List ciphers to support; */
    char *rsa_engine;	/* External program to handle RSA computations */
    char *keygen;	/* External program to handle background key gen. */
    char *initiator;	/* External program to create user processes */
    char *user_keyfile; /* Name of keyfile for RSA auth type */
    char *cmd_task;	/* Decnet taskname for 'command' mode */
    char *login_table;	/* Logical name table name for login map */
    char *login_info_table;   /* Privileged information (newmail, etc) */
    struct parameter_list_elem *multi_user;
    struct parameter_mlist_elem *tt_char;
    struct parameter_list_elem *administrator;
    int x11_servers;	/* number of x11 servers to allow (0 disables) */
    int x11_server_number; /* First X server number to use */
    int x11_table_size;	/* Number of allowed channels per x11 server */
    struct parameter_mlist_elem *tt_type;
    int pty_mode;	/* 0-disable, 1-SSH auth, 2-SSH/VMS auth */
    char *pty_map_table;	/* logical name table for pty map */
    struct parameter_list_elem *required_id;
    int port_forward;	/* bit mask: <0>-port_open enable <1> port fwd req. */
    struct parameter_list_elem *x11_decnet_node;
    char *fwd_map_table;	/* logical name table for port forward map */
    struct parameter_list_elem *fwd_map_enable;
    int pty_accpornam;	/* 0-disable, 1-Enable */
    char *pty_accpornam_image;	/* directory for ft_accpornam.exe */
} param;
/*
 * Prototypes for related functions.
 */
int init_parameters ( char *parameter_file );

int convert_tt_parameters ( struct parameter_list_elem *tt_char,
	int *defchar, int *defchar2 );

int convert_tt_type_parameters ( char *key, char *value,
	struct parameter_mlist_elem *tt_char, unsigned char *type_code,
	int *defchar, int *defchar2 );
