/*
 * pf_create_forwarder() is called by client thread to create a port
 * forwarder thread, returning a pipe that it is to use to communicate
 * with it (after assigning streams).  We also allocate a buffer 
 * the forwarder thread can write to, the forwarder will never attempt
 * to write a buffer bigger than the returned bufsize.  The client
 * thread may write any size buffer to the forwarder (it will dynamically
 * adjust it's read buffers).
 */
int pf_create_forwarder ( 
	int protocol_flags,
	void *pipe_ctx, 	/* Context for assigning comm. pipe */
	char *username,		/* Local username for X11 access checks */
	char *accpornam,	/* remote client host and port */
	char **buffer, 		/* output buffer (allocate by this function ) */
	int *bufsize );		/* size of buffer allocate */
void pf_initialize();

#ifdef PTHREAD_ONCE_INIT	/* avoid false dependancy on pthreads */
/*
 * The following data structures are used internally by port_forwarder.c
 * and port_fwd_dispatch.c.
 *
 * A channel is 'open' for each active X server and each connection.
 * A table of size  param.x11_table_size+1 channel structures is allocated
 * for each port.  Channel 0 is the pipe to the client thread.
 *
 * Buffers:
 *   There are 2 data streams: packets flowsing from the client input
 *    pipe to the output streams of the various channels, and data flowing
 *    from the channels input streams to the client output pipe.
 *
 *    There is 1 data buffer associated with the client input pipe. When
 *    the buffer is recieved, is then used in the write to tcp channel and
 *    input pipe is not read again (reusing the same buffer) until the write 
 *    completes
 *
 *    Each TCP channel has a private buffer on which is receives data.  When
 *    data recieved, it is then queued to client outbound pipe and a new
 *    read on the tcp stream isn't started until is leaves the pipe output
 *    queue.
 *
 */
#define FWD_BUF_SIZE 4096
struct pf_tcp_channel {
    struct pf_tcp_channel *flink;
    struct pf_tcp_channel *blink;	/* Queue position */
    int index;			/* server side channel number */
    int type;			/* 0-free, 1-listener, 2-connection, 3 pipe */
    int remote_channel;		/* remote channel number */
    int port_num;		/* local port number */
    int forward_port;		/* port number for forward port requests */
    char *forward_host;		/* Host name for port forward requests */
    int out_size;		/* write size when queued to ctl->pipe_out */
    int init_packet_pos;	/* Buffer position in initial packet read. */
    int init_packet_size;	/* target length */
    void *ctx;			/* I/O context */
    int msg_type;		/* send type for message */
    cport_isb in, out;
    struct {
	int channel;		/* channel number. (allocated by client) */
	char data[FWD_BUF_SIZE];
    } packet;
};
typedef struct pf_tcp_channel *pf_chan;

struct pf_control_block {
    struct pf_control_block *next;
    int status, index;
    int protocol_flags;
    int ref_count;			/* number of times in context key */
    pthread_t thread_id;		/* forwarding thread ID */
    tm_destructor_handle dstr_hndl;
    void *pipe_ctx;
    cport_port port;
    cport_isb pipe_in, pipe_out;
    pf_chan tcp;			/* table, index is channel number */
    pf_chan out_queue_head;
    pf_chan out_queue_tail;
    char *username;
    char accpornam[64];
    int x11_server_number;		/* x11 server number */
    int high_chan;
    int in_idle;		/* If true, input buffer not in use */
    int in_pos;			/* context for write of in_buffer */
    int in_endpos;		/* one past last position to be written */
    int in_bufsize;		/* in_buffer's allocation */
    char *in_buffer;		/* Inbound message from client thread */
    char *spoof_packet;		/* Initial x11 packet for X11 connections */
    int spoof_packet_size;	/* Size of spoof packet */
    int mask_high;		/* highest non-zero mask[i] */
    int mask[256];		/* Indicates message types accepted. */
};
typedef struct pf_control_block *pf_ctlblk;
/*
 * Global data structure for sharing data between modules.
 */
struct {
    int ctl_index;			/* Thread index counter */
    pthread_mutex_t lock;		/* Locks pf database. */
    pthread_cond_t ready;
    pthread_key_t creator_key;		/* used to ensure rundown */
    pthread_attr_t ctl_attr;
    pf_ctlblk free_ctl;			/* lookaside list of free control blks*/
    int *x11_server_stack;		/* stack of available server #s */
    int x11_server_top;			/* stack pointer */
    int decnet_x11;			/* Flags if X11 using DECnet protocol */
} pf;
/*
 * Socket map routine is upcall from open_tcp_socket that globally associates
 * a driver-allocated port number with the authenticated username of the
 * socket's 'owner'.  Code: 1-add mapping, 0-delete mapping.
 */
struct pf_map_arg {
    pf_chan tcp;		/* target connection */
    char *username;		/* username of authenticated client */
    char *accpornam;		/* Remote connect data */
    int target_port;		/* port number that will be connected to */
};
int pf_map_socket ( int code, int port_num, void *ctl_vp );
/*
 * Prototypes for routines in port_fwd_dispatch, called by port_forwarder.c
 */
int pf_dispatch_pipe_in ( pf_ctlblk ctl );
int pf_dispatch_pipe_out ( pf_ctlblk ctl, pf_chan tcp);
int pf_dispatch_tcp_in ( pf_ctlblk ctl, pf_chan tcp);
int pf_dispatch_tcp_out( pf_ctlblk ctl, pf_chan tcp);
#endif
