/*
 * This module manages a global database for mapping terminal and mailbox
 * information to its SSH connection information.  The current
 * implementation is based on logical names, in param.pty_map_table.
 *
 * Author:	David Jones
 * Date:	22-OCT-1998
 * Revised:	24-MAY-1999	added pty_set_accopornam.
 */

#include <descrip.h>
#include <lnmdef.h>
#include <ssdef.h>
int LIB$FIND_IMAGE_SYMBOL();

#include <stdio.h>
#include "tutil.h"
#include "parameters.h"
#include "pty_map.h"			/* verify prototypes */
#include "event_report.h"

int SYS$WAKE(), SYS$CRELNM(), SYS$DELLNM(), SYS$CRELNT();
static $DESCRIPTOR(pty_map_table,"");
static $DESCRIPTOR(login_info_table,"");
static $DESCRIPTOR(system_directory,"LNM$SYSTEM_DIRECTORY");
static $DESCRIPTOR(accpornam_file, "FT_ACCPORNAM" );
static $DESCRIPTOR(accpornam_image, "" );
static $DESCRIPTOR(init_symnam, "FTA_INITIALIZE" );
static $DESCRIPTOR(set_symnam, "FTA_SET_ACCPORNAM" );
static char hex[16] = { '0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

/*****************************************************************************/
/* Dummy routine for set_accpornam function.
 */
static dummy_set_accpornam ( int chan, int length, char *name )
{
    return 1;
}
/*****************************************************************************/
/* Initialize module.  Must only be called once.
 */
int pty_map_init ( )
{
    int status, attr, protection, mode;
    /*
     * Dynamically load shareable image to handle setting accpornam string
     * on FTAnnn devices.  Image is loaded dynamically to isolate us from
     * OS version dependencies.
     */
    pty_set_accpornam = &dummy_set_accpornam;	/* setup fallback */
    if ( param.pty_accpornam ) {
	int (*init_routine)();
	/*
	 * Load init and set routine addresses.
	 */
	accpornam_image.dsc$a_pointer = param.pty_accpornam_image;
	accpornam_image.dsc$w_length = tu_strlen(param.pty_accpornam_image);
	status = LIB$FIND_IMAGE_SYMBOL ( &accpornam_file,
		&init_symnam, &init_routine, &accpornam_image, 0 );
	if ( (status&1) == 1 ) {
	    status = LIB$FIND_IMAGE_SYMBOL ( &accpornam_file,
		&set_symnam, &pty_set_accpornam, &accpornam_image, 0 );
	}
	/*
	 * Initialize the loaded module.
	 */
	if ( (status&1) == 1 ) status = init_routine();
	/*
	 * Reset parameter if load or init fails.
	 */
	evr_event ( EVR_CONFIG, 
	   "Load status for accpornam fixup image: %d%s", status,
		(status&1) ? " (success)" : " (failure, feature disabled)" );
	if ( (status&1) == 0 ) param.pty_accpornam = 0;
    }
    /*
     * Set table name to upper case and construct global string descriptor.
     */
    tu_strupcase ( param.pty_map_table, param.pty_map_table );
    pty_map_table.dsc$w_length = tu_strlen ( param.pty_map_table );
    pty_map_table.dsc$a_pointer = param.pty_map_table;
    if ( pty_map_table.dsc$w_length == 0 ) return 1;
    /*
     * Delete all logicals in table.
     */
    mode = 2;
    status = SYS$DELLNM ( &pty_map_table, 0, &mode );
    /*
     * Create new table.
     */
    attr = LNM$M_CREATE_IF;
    protection = 0x0e000;	/* set to sy:rwcd, gr:rwcd, ow:rwcd, wo:rwcd */
    status = SYS$CRELNT ( &attr, 0, 0, 0, &protection, &pty_map_table,
		&system_directory, &mode );

    return status;
}
/*****************************************************************************/

int pty_map_assign ( char *terminal, char *accpornam, 
	char *username, char *x11_info )
{
    struct dsc$descriptor_s logical_name;
    struct { short int length, code; char *buffer; int *retlen; } item[6];
    int i, status, nibble;

    if ( *param.pty_map_table ) {
	/*
	 * Create logical name to store remote connection information.
	 * The logical name is the process index.
	 */
	logical_name = pty_map_table;
	logical_name.dsc$a_pointer = terminal;
	logical_name.dsc$w_length = tu_strlen ( terminal );

	if ( *accpornam ) {
	    item[0].length = tu_strlen ( accpornam );
	    item[0].code = LNM$_STRING;
	    item[0].buffer = accpornam;
	    item[0].retlen = 0;
	    item[1].length = item[1].code = 0;
	    if ( username ) {
	        /* If username is zero length, don't add to logical name */
	        item[1].length = tu_strlen ( username );
	        item[1].code = (item[1].length>0) ? LNM$_STRING : 0;
	        item[1].buffer = username;
	        item[1].retlen = 0;
	        item[2].length = item[2].code = 0;
	    }
	    if ( (item[1].length > 0) && x11_info ) {
	        /* If x11_info is zero length, don't add to logical name */
	        item[2].length = tu_strlen ( x11_info );
	        item[2].code = (item[2].length>0) ? LNM$_STRING : 0;
	        item[2].buffer = x11_info;
	        item[2].retlen = 0;
	        item[3].length = item[3].code = 0;
	    }
	    status = SYS$CRELNM ( 0, &pty_map_table, &logical_name, 0, item );
	    if ( (status&1) == 0 ) {
		evr_event ( EVR_EXCEPTION, 
		    "Error creating pty_map_table entry, code=%d", status );
	    }
	}

    } else status = SS$_IVLOGTAB;

    return status;
}

int pty_map_deassign ( char *terminal )
{
    int status;
    struct dsc$descriptor_s logical_name;

    logical_name = pty_map_table;
    logical_name.dsc$a_pointer = terminal;
    logical_name.dsc$w_length = tu_strlen ( terminal );
    
    status = SYS$DELLNM ( &pty_map_table, &logical_name, 0 );
    return status;
}
