/*
 * This program uses a simple mailbox-based protocol to provide RSA encryption
 * computation to a client process.
 *
 * Author:	David Jones
 * Date:	19-JUN-1998
 * Revised:	23-MAY1999		use new helper_com library
 */
#include <stdio.h>
#include <stdlib.h>
#include <ssdef.h>
#include <string.h>
void SYS$EXIT();

#include "sshrsa.h"
#include "sshrsa_rpc.h"

#include "helper_com.h"		/* communication support */

#define PROCESS_NAME "RSA engine"

#ifdef DEBUG
static void dump_buffer ( char *heading, char *buffer, int bufsize )
{
    int i, j;
    printf ( "%s (%d bytes):", heading, bufsize );
    j = 15;
    for ( i = 0; i < bufsize; i++ ) {
	j++;
	if ( j > 15 ) {
	    printf("\n   %04x:", i ); j = 0; }
	printf(" %02x", 255&buffer[i] );
    }
    printf("\n");
}
#else
#define dump_buffer(a,b,c) 1
#endif
/***********************************************************************/

int main ( int argc, char **argv )
{
    int status, request_dlen, reply_dlen;
    long pid, code, lksb[2];
    struct mbx_message request, reply;
    /*
     * Establish communication with parent process.
     */
    status = helper_setup ( PROCESS_NAME, MBX_NAME, SYS$EXIT, 
		(void *) SS$_ABORT );
    if ( (status&1) == 0 ) {
	fprintf(stderr,"Error initializing helper communication support: %d\n",
		status );
	return status;
    }
    /*
     * Initialize random number genrator and setup RSA calls for local use.
     */
    sshrsa_init("");
    /*
     * Enter main loop: read message and process.
     */
    while ( status&1 ) {
	/*
	 * read request.
	 */
	int length;

	status = helper_recv_message ( &request, sizeof(request), &length );
	if ( (status&1) == 0 ) break;
	/*
	 * Setup reply
	 */
	reply_dlen = 0;
	reply.code = request.code;
	reply.key_id = (void *) 0;
	reply.len1 = 0;
	reply.len2 = 0;
        /*
	 * Peform requested operation.
	 */
	request_dlen = length - (sizeof(request)-sizeof(request.data));
	if ( request_dlen < 0 ) request_dlen = 0;
	status = sshrsa_remote_request 
		(&request, request_dlen, &reply, &reply_dlen);
	/*
	 * Send final reply, verify recipient.
	 */
	/* printf("reply length: %d code: %d, id: %x\n", reply_dlen, 
		reply.code, reply.key_id ); */
	if ( reply_dlen > 0 ) dump_buffer ( "reply data", reply.data,reply_dlen);

	status = helper_send_message ( &reply,
		(sizeof(reply)-sizeof(reply.data)+reply_dlen) );
    }
    return status;
}
