/*
 * This program emulates the actions performed by loginout which are skipped
 * if prc$m_nopassword is present:
 *
 *    0. Check if terminal has disconnect attribute and look for terminal
 *       to reconnect to if so.
 *    1. Translate sys$announce and display.
 *    2. Report last login times.
 *    3. Report number of last login failures.
 *    4. Clear login failure count and update last login.
 *    5. Retrieve newmail count and dislpay.
 *
 * The process's account flags are checked and will inhibit any of
 * the above display.
 *
 * This program must be installed with sysprv privilege in order to update
 * the login failure count and last login times.  If the existing UAF times
 * to not match the process values, no update will be performed.
 *
 * Author:	David Jones
 * Date:	29-JUL-1998
 * Revised:	15-SEP-1998	Set X11 display from SSH_LOGIN_INFO logical name.
 * Revised:	20-SEP-1998	Set X11 display for non-interactive mode.
 */
#include <descrip.h>		/* string descriptors */
#include <uaidef.h>		/* account information */
#include <jpidef.h>		/* process information */
#include <prvdef.h>		/* VMS privilege bits */
#include <lnmdef.h>		/* Logical names */
#include <maildef.h>		/* callable mail */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int SYS$SETPRV(), SYS$GETJPIW(), SYS$SETUAI(), SYS$ASSIGN(), SYS$TRNLNM();
int SYS$GETUAI(), SYS$FAO(), LIB$DAY_OF_WEEK(), LIB$DO_COMMAND();
int MAIL$USER_BEGIN(), MAIL$USER_END();

struct item_entry { 
    unsigned short int length, code; 
    void *buffer; 
    int *retlen; 
};
#define SET_ITEM(i,c,l,b,r) item[i].length=(l); item[i].code=(c); \
	item[i].buffer=(b); item[i].retlen=(r);

/***************************************************************************/
/*
 * Check terminal device TT's characteristics and if disconnectable look
 * for existing disconnected sessions and prompt for reconnect.  If reconnect
 * accepted, exit with connect command.
 */
static void check_for_reconnect()
{
    int status, tt;
    static $DESCRIPTOR(terminal,"TT:");
    tt = 0;
    status = SYS$ASSIGN ( &terminal, tt, 0, 0, 0 );
}
/***************************************************************************/
/* Translate logical SYS$WELCOME and display to standard output.
 */
static void show_welcome()
{
    struct item_entry item[4];
    int status, flags, length;
    char welcome_str[256];
    static $DESCRIPTOR(table,"LNM$FILE_DEV");
    static $DESCRIPTOR(lognam,"SYS$WELCOME");
    /*
     * Translate the logical name.
     */
    SET_ITEM(0,LNM$_STRING,sizeof(welcome_str)-1, welcome_str, &length )
    SET_ITEM(1,0,0,0,0)
    length = 0;
    flags = LNM$M_CASE_BLIND;

    status = SYS$TRNLNM ( &flags, &table, &lognam, 0, item );
    if ( (status&1) == 0 ) return;	/* no match */
    welcome_str[length] = '\0';		/* terminate C string */
    /*
     * Either display string directly
     */
    if ( welcome_str[0] == '@' ) {
	/*
	 * Display filename following at sign.
	 */
	FILE *wf;
	char line[8192];

	wf = fopen ( &welcome_str[1], "r" );
	if ( !wf ) {
	    printf("Error openning %s as input", &welcome_str[1] );
	    return;
	}
	while ( fgets ( line, sizeof(line), wf ) ) printf("%s",line);

	fclose ( wf );

    } else {
	/*
         * Convert escapes to '.'.
	 */
	int i;
	for ( i = 0; welcome_str[i]; i++ ) {
	    if ( welcome_str[i] == 27 ) welcome_str[i] = '.';
	}
	/*
	 * Show the string.
	 */
	printf ( "%s\n", welcome_str );
    }
}
/***************************************************************************/
/* Display information lines regarding last login and number of failed
 * login attempts.
 */
static void show_last_login ( long *login_i, long *login_n, int logfails )
{
    static char *weekday[8] = { "???", "Monday", "Tuesday", "Wednesday",
	"Thursday", "Friday", "Saturday", "Sunday" };
    int status, length, weekday_i, weekday_n;
    static char line[200];
    static $DESCRIPTOR(line_dx,line);
    static $DESCRIPTOR(fmtstr_i,"    Last interactive login on !AZ, !%D");
    static $DESCRIPTOR(fmtstr_n,"    Last non-interactive login on !AZ, !%D");
    static $DESCRIPTOR(fmtstr_lf,
	"!AD        !SL login failure!%S since last successful login" );
    /*
     * Format login times, skip if zero (no logins in that mode).
     */
    weekday_i = weekday_n = 0;
    if ( login_i[0] || login_i[1] ) {
        LIB$DAY_OF_WEEK ( login_i, &weekday_i );
	if ( weekday_i > 7 || weekday_i < 1 ) weekday_i = 0;
        length = 0;
        status = SYS$FAO ( &fmtstr_i, &length, &line_dx,  weekday[weekday_i], 
		login_i );

	if ( (status&1) ) {
	    line[length] = '\0';
	    printf("%s\n", line );
	}
    }
    if ( login_n[0] || login_n[1] ) {
        LIB$DAY_OF_WEEK ( login_n, &weekday_n );
	if ( weekday_n > 7 || weekday_n < 1 ) weekday_n = 0;
        length = 0;
        status = SYS$FAO ( &fmtstr_n, &length, &line_dx,  weekday[weekday_n],
		login_n );

	if ( (status&1) ) {
	    line[length] = '\0';
	    printf("%s\n", line );
	}
    }
    /*
     * Display login failures.
     */
    if ( logfails > 0 ) {
	length = 0;
        status = SYS$FAO ( &fmtstr_lf, &length, &line_dx, 3, "\007\007\007",
		logfails );
	if ( (status&1) ) {
	    line[length] = '\0';
	    printf("%s\n", line );
	}
    }

}
/***************************************************************************/
/* Retrieve newmail count from VMS mail profile and display.
 */
static void show_mail ( )
{
    int status;
    long context;
    struct item_entry null_item[1], item[3];
    short new_messages;

    context = 0;
    null_item[0].code = null_item[0].length = 0;
    SET_ITEM(0,MAIL$_USER_NEW_MESSAGES,sizeof(new_messages), &new_messages, 0)
    SET_ITEM(1,0,0,0,0)

    status = MAIL$USER_BEGIN ( &context, null_item, item );
    if ( (status&1) == 1 ) {
	status = MAIL$USER_END ( &context, null_item, null_item );
	if ( new_messages > 0 ) {
	    printf("\n%c            You have %d new Mail message%s.\n\n",
		7, new_messages, (new_messages == 1) ? "" : "s" );
	}
    } else {
	printf("\nError reading mail profile information: VMS code: %d\n\n",
		status );
    }
}
/***************************************************************************/
/* read SSH_LOGIN_INFO entry for this process and return translation as
 * array of string pointers.
 */
char **get_private_info ( int proc_index )
{
    struct item_entry item[12];
    int status, i, max_index, len0, len1, len2, len3, flags;
    static int ln_ndx[4] = { 0, 1, 2, 3 };
    static char lognam[40];
    static $DESCRIPTOR(lognam_dx,lognam);
    static $DESCRIPTOR(table, "SSH_LOGIN_INFO" );
    char **info;
    char equiv_0[256], equiv_1[256], equiv_2[256], equiv_3[256];
    /*
     * Construct logical name to search.
     */
    sprintf ( lognam, "%d", proc_index );
    lognam_dx.dsc$w_length = strlen ( lognam );
    /*
     * Translate first 2 strings of name and get max_index.
     */
    SET_ITEM(0,LNM$_STRING,sizeof(equiv_0)-1, equiv_0, &len0 )
    SET_ITEM(1,LNM$_INDEX, 4, (char *) &ln_ndx[1], 0 )
    SET_ITEM(2,LNM$_STRING,sizeof(equiv_1)-1, equiv_1, &len1 )
    SET_ITEM(3,LNM$_INDEX, 4, (char *) &ln_ndx[2], 0 )
    SET_ITEM(4,LNM$_STRING,sizeof(equiv_2)-1, equiv_2, &len2 )
    SET_ITEM(5,LNM$_INDEX, 4, (char *) &ln_ndx[3], 0 )
    SET_ITEM(6,LNM$_STRING,sizeof(equiv_3)-1, equiv_3, &len3 )
    SET_ITEM(7,LNM$_MAX_INDEX,sizeof(max_index), (char *) &max_index, 0 )
    SET_ITEM(8,0,0,0,0)
    max_index = 0;
    len0 = len1 = len2 = len3 = 0;
    flags = LNM$M_CASE_BLIND;
    status = SYS$TRNLNM ( &flags, &table, &lognam_dx, 0, item );
    if ( (status&1) == 1 ) {
        info = (char **) malloc ( sizeof(char *) * (max_index+2) );
        if ( !info ) return info;
        info[0] = (char *) 0;

	info[0] = malloc ( len0 + 1 ); 
	equiv_0[len0] = '\0'; strcpy ( info[0], equiv_0 );
	info[1] = malloc ( len1 + 1 );
	equiv_1[len1] = '\0'; strcpy ( info[1], equiv_1 );
	info[2] = malloc ( len2 + 1 );
	equiv_2[len2] = '\0'; strcpy ( info[2], equiv_2 );
	info[3] = malloc ( len3 + 1 );
	equiv_3[len3] = '\0'; strcpy ( info[3], equiv_3);
	/*
	 * Get addional strings.
	 */
        SET_ITEM(0,LNM$_INDEX, 4, (char *) &i, 0 )
	SET_ITEM(1,LNM$_STRING,sizeof(equiv_1)-1, equiv_1, &len1 )
	SET_ITEM(2, 0, 0, 0, 0 )
	for ( i = 4; i <= max_index; i++ ) {
    	    status = SYS$TRNLNM ( &flags, &table, &lognam_dx, 0, item );
	    if ( (status&1) == 0 ) break;
	    info[i] = malloc ( len1 + 1 );
	    equiv_1[len1] = '\0'; strcpy ( info[i], equiv_1 );
	}
	info[max_index+1] = (char *) 0;
    } else {
	info = (char **) 0;
    }
    return info;
}
/***************************************************************************/

int main ( int argc, char **argv )
{
    long proc_priv[2], cur_priv[2], login_i[2], login_n[2], logintim[2];
    long pid, iosb[2];
    int status;
    int creprc_flags, mode, login_failures, proc_index, uaf_flags;
    static char username[12];
    static $DESCRIPTOR(username_dx,username);
    struct item_entry item[12];
    char **private_info;
    /*
     * First do the pieces that require privilege.  Note that we should
     * not write to sys$output while we have privilege.
     * Get needed process information.
     */
    SET_ITEM(0,JPI$_CREPRC_FLAGS,sizeof(creprc_flags), &creprc_flags, 0)
    SET_ITEM(1,JPI$_LAST_LOGIN_I,sizeof(login_i), login_i, 0)
    SET_ITEM(2,JPI$_LAST_LOGIN_N,sizeof(login_n), login_n, 0)
    SET_ITEM(3,JPI$_LOGIN_FAILURES,sizeof(login_failures), &login_failures,0)
    SET_ITEM(4,JPI$_LOGINTIM,sizeof(logintim), logintim, 0)
    SET_ITEM(5,JPI$_PROC_INDEX,sizeof(proc_index),&proc_index,0)
    SET_ITEM(6,JPI$_PROCPRIV,sizeof(proc_priv), proc_priv, 0)
    SET_ITEM(7,JPI$_CURPRIV,sizeof(cur_priv), cur_priv, 0)
    SET_ITEM(8,JPI$_UAF_FLAGS,sizeof(uaf_flags), &uaf_flags, 0)
    SET_ITEM(9,JPI$_USERNAME,sizeof(username),username,0)
    SET_ITEM(10,JPI$_MODE,sizeof(mode),&mode,0)
    SET_ITEM(11,0,0,0,0)

    pid = 0;			/* this process */
    status = SYS$GETJPIW ( 0, &pid, 0, item, iosb, 0, 0 );
    if ( (status&1) == 1 ) status = iosb[0];

    if ( (status&1) == 0 ) return status;	/* unexpected error */
    /*
     * Fixup UAF record last login information.  Processes created by the
     * initiator always set the non-interactive last login time regardless
     * of mode, if we are interactive, clear the logfails field and
     * restore.
     *
     * Note that we only do update if process last login time matches that
     * recorded in the interactive field since otherwise a user could
     * hide subsequent logins by manually running this program.
     */
    if ( mode != JPI$K_INTERACTIVE ) {
	/* Leave UAF record as is if non-interactive. */
	int i;
	private_info = get_private_info ( proc_index );
	printf ( "Private info for non-interactive job: %x\n", private_info );
	if ( private_info ) for ( i = 0; private_info[i]; i++ ) {
	    printf("  info[%d] = %x '%s'\n", i, private_info[i],
		private_info[i] ? private_info[i] : "" );
	}
    } else if ( cur_priv[0] & (PRV$M_BYPASS | PRV$M_SYSPRV) &&
		(mode == JPI$K_INTERACTIVE) ) {
	unsigned int uaf_logfails;
	long uaf_login_i[2], uaf_login_n[2];
        /*
	 * Read current values from UAF.
	 */
	SET_ITEM(0,UAI$_LOGFAILS, 2, &uaf_logfails, 0 )
	SET_ITEM(1,UAI$_LASTLOGIN_I,sizeof(uaf_login_i), uaf_login_i, 0)
	SET_ITEM(2,UAI$_LASTLOGIN_N,sizeof(uaf_login_n), uaf_login_n, 0)
	SET_ITEM(3,0,0,0,0)

	status = SYS$GETUAI ( 0, 0, &username_dx, item, 0, 0, 0 );
        /*
         * Update fields if they are what is expected.
         */
	if ( (status&1) == 1 && (uaf_login_i[0] == login_i[0]) &&
		(uaf_login_i[1] == login_i[1]) ) {
	    /*
	     * Login times match.
	     */
	    SET_ITEM(1,UAI$_LASTLOGIN_I,sizeof(logintim), logintim, 0)
	    SET_ITEM(2,UAI$_LASTLOGIN_N,sizeof(login_n), login_n, 0 )
	   if ( uaf_logfails == login_failures ) uaf_logfails = 0;

	   status = SYS$SETUAI(0,0,&username_dx,item,0,0,0);
	}

	private_info = get_private_info ( proc_index );
    } else {
	printf("No privilege to update last login/logfail count!\n");
	private_info = (char **) 0;
    }
    /*
     * Disable any elevated privileges.
     */
    cur_priv[0] &= (~proc_priv[0]);	/* clear bits present in def. privs */
    cur_priv[1] &= (~proc_priv[1]);
    status = SYS$SETPRV ( 0,  cur_priv, 0, 0 );
    if ( (status&1) == 0 ) return status;
    /*
     * Do extra processing for interactive mode.
     */
    if ( mode == JPI$K_INTERACTIVE ) {
	/*
 	 * Check for disconnected terminal reconnect.
         */
        if ( 0 == (uaf_flags & UAI$M_DISRECONNECT) ) check_for_reconnect();
        /*
         * display sys$welcome.
         */
        if ( 0 == (uaf_flags & UAI$M_DISWELCOM) ) show_welcome();
        /*
         * Show last login data.
         */
        if ( 0 == (uaf_flags & UAI$M_DISREPORT) ) show_last_login (
	    login_i, login_n, login_failures );
	/*
	 * Show unread newmail messages.
	 */
	if ( 0 == (uaf_flags & UAI$M_DISMAIL) ) show_mail ( );
    }
    /*
     * See if x11 info string present and exit with SET DISPLAY command
     */
    if ( private_info ) if ( private_info[4] ) {
	static $DESCRIPTOR ( cmd_dx, "" );
	static char cmd[256], *transport, *server_num, *screen, *node;
	int i, j;
	transport = private_info[4];
	for ( i = 0; transport[i]; i++ ) if (transport[i] == ':' ) {
	    transport[i] = '\0';
	    server_num = &transport[i+1];
	    screen = "0";
	    for(j=0; server_num[j]; j++ ) if ( server_num[j] == ':' ) {
		server_num[j] = '\0';
		screen = &server_num[j+1];
		break;
	    }
	    node = "";
	    if ( strcmp ( transport, "TCPIP" ) == 0 ) 
		node = "/node=localhost";
	    sprintf ( cmd, 
		"set display/create/transport=%s/server=%s/screen=%s%s",
		transport, server_num, screen, node );
	    cmd_dx.dsc$a_pointer = cmd;
	    cmd_dx.dsc$w_length = strlen ( cmd );
	    /* printf("$ %s\n", cmd ); */
	    status = LIB$DO_COMMAND ( &cmd_dx );
	    break;
	}
    }
    return status;
}
