$!  Setup parameters and run ssh_server.exe.  Specify TEST to run server
$!  interactively for testing/verifying.  Specify "INITIAL_KEY" to run
$!  key generator.
$!
$! Determine mode we are in, based upon process name.
$  ssh_startup_proc = f$environment("PROCEDURE")
$!
$  home_dir = f$parse("1.1;1",ssh_startup_proc,,,"NO_CONCEAL") - "1.1;1"
$  proc_name = f$getjpi("0","PRCNAM")
$  p1_arg = f$element(1,"=",p1)
$  p_1 = f$element(0,"=",p1)
$  if proc_name .eqs. "SSH bootstrap" .or. P_1 .eqs. "TEST" then goto run_server
$  if p_1 .eqs. "INITIAL_KEY" then goto generate_first_keys
$!
$! If privileged, make logical name tables
$!
$  if f$privilege("SYSNAM,SYSPRV")
$  then
$     if f$trnlnm("SSH_LOGIN_MAP","LNM$SYSTEM_DIRECTORY") .EQS. "" THEN -
	create/name_table SSH_LOGIN_MAP/PARENT=LNM$SYSTEM_DIRECTORY
$     if f$trnlnm("SSH_LOGIN_INFO","LNM$SYSTEM_DIRECTORY") .EQS. "" THEN -
	create/name_table SSH_LOGIN_INFO/PARENT=LNM$SYSTEM_DIRECTORY/PROT=WORLD
$!
$  else
$     write sys$output "Not a privileged process, no systemwide setup done"
$  endif
$!
$!  Create detached process to run server.
$!
$  run/detached sys$system:loginout.exe -
	/input='home_dir'ssh_server_startup -
	/process_name="SSH bootstrap" -
	/output='home_dir'ssh_server.log -
	/ast_limit=100 -
	/buffer_limit=60000 -
	/privilege=(tmpmbx,netmbx,detach,sysprv,sysnam,security,phy_io,world)
$ exit $status
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Run the SSH server program.  Set the logical test_port to the port number
$! to use, defaulting to 22.   Symbol ssh_exec_cmd by default is sshexec.com
$! in the same directory as sys$sylogin.com.
$!
$ run_server:
$   decnet_node = f$getsyi("NODENAME")
$   if .not. f$getdvi("_NET:","EXISTS") then decnet_node = ""
$   if f$type(test_port) .nes. "INTEGER" then test_port = "22"
$   if p_1 .eqs. "TEST" 
$   then
$      if p2 .nes. "" then test_port = f$integer(p2)
$   else
$       proc_ndx = f$getjpi("0","PROC_INDEX")
$	set process/name="SSH server ''f$extract(0,4,f$string(proc_ndx))'"
$   endif
$!
$!   Run program in loop to automatically recover from errors, only
$!   restart however if program ran for more than 10 minutes.
$!
$ define ssh_home_dir 'home_dir'
$ if f$type(ssh_exec_cmd) .eqs. "" then ssh_exec_cmd = "@" + -
	f$parse("sshexec.com;","sys$sylogin") - ";"
$ define sshcryptoshr 'home_dir'sshcryptoshr.exe
$ param_file = "ssh_home_dir:ssh_parameters.dat"
$ if p1_arg .nes. "=" then param_file = p1_arg
$ server_restart:
$    on warning then goto error_restart
$    restart_after = f$cvtime("+00:10:00")
$    mcr 'home_dir'ssh_server.exe 'param_file'
$ exit $status
$!
$ error_restart:
$    exit_status = $status .and. %x0ffffff
$    ss$_shut = 8332
$    if f$cvtime(f$time()) .gts. restart_after .and. -
	exit_status .nes. ss$_shut then goto server_restart
$ exit $status
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Generate initial key files for user.  Server key is automatically 256
$! bits less than host key.
$!
$ generate_first_keys:
$!
$ h_file = f$search("''home_dir'hkey.pem")
$ if h_file .nes. ""
$ then
$    create sys$output
The host key file (hkey.pem) already exists, overwriting it may invalidate 
the 'known host' settings for SSH clients that used this key.

$    inquire ans "Do you wish to overwrite [N]"
$    if .not. ans then exit
$ endif
$!
$ Inquire hkey_size "Size of host key (1024)"
$ if hkey_size .eqs. "" then hkey_size = "1024"
$ size = f$integer(hkey_size)
$ if size .lt. 768 then size = 768
$!
$ define sshcryptoshr 'home_dir'sshcryptoshr.exe
$ keygen = "$''home_dir'key_generator.exe"
$ keygen -new 'size' 'home_dir'hkey.pem
$ size = size - 256
$ keygen -new 'size' 'home_dir'skey.pem
$ exit
