$! This command procedure creates the sshcryptoshr shareable image.
$! Embedded within the procedure are the linker options files and VAX macro
$! code for creating the shareable image.
$!
$! P1 specifies the logical file specifcation to assign to ssl_crypto_lib
$! logical.
$!
$ if f$getsyi("CPU") .ge. 128
$ then
$!   Alpha build.  Version 7 pthreads is in imagelib so we don't need to
$!   include options file.
$!
$    pthread_opt = ",sys$disk:[]pthread_libs_axp.opt/option"
$    if f$search("sys$share:pthread$rtl.exe") .nes. "" then pthread_opt = ""
$    arch_suffix = "-axp"
$    gosub set_crypto_lib
$!
$    link/map=sshcryptoshr.map/full/share=sys$disk:[]sshcryptoshr.exe -
	sys$input/option 'pthread_opt'
! This linker options file is used to build the sscryptoshr shareable image.
! The logical name ssl_crypto_lib must translate to the name of the libcrpto
! library.
!
! define Alpha VMS symbol vector for SSH shareable image.  Include
! completion port routines sshsess functions.
!
identification="OSU Crypto 1.4"
sshrsa_rpc.obj			! RSA key support (glue to ssleay).
helper.obj			! helper sub-process support.
tutil.obj                       ! general utility functions
ssl_mt.obj			! sets multi-threading.
sshcipher.obj
ssl_crypto_lib/lib		! library containing SSLeay/OpenSSL encryption code.

!
!   symbols defined int ssl_mt.obj and sshrsa_rpc.obj
!
SYMBOL_VECTOR=(-
    sslmt_initialize=PROCEDURE,-
    sshrsa_init=PROCEDURE,-
    sshrsa_create=PROCEDURE,-
    sshrsa_destroy=PROCEDURE,-
    sshrsa_read_keyfile=PROCEDURE,-
    sshrsa_write_keyfile=PROCEDURE,-
    sshrsa_set_private_key=PROCEDURE,-
    sshrsa_set_public_key=PROCEDURE,-
    sshrsa_encrypt_number=PROCEDURE,-
    sshrsa_decrypt_number=PROCEDURE,-
    sshrsa_extract_public_key=PROCEDURE,-
    sshrsa_generate_key=PROCEDURE,-
    sshrsa_remote_request=PROCEDURE,-
!
!  symbols in ssleay referenced by sshlogin and sshsess.
!
    RAND_bytes=PROCEDURE,-
    MD5_FINAL=PROCEDURE,-
    MD5_INIT=PROCEDURE,-
    MD5_UPDATE=PROCEDURE,-
!
!   symbols defined in sshcipher.obj
!
    sshciph_cipher_number=PROCEDURE,-
    sshciph_cipher_name=PROCEDURE,-
    sshciph_setup=PROCEDURE,-
    sshciph_state_size=PROCEDURE,-
!
!   Extensions for version 1.2
!
    sshrsa_lookup_public_key=PROCEDURE, -
!
!   Extensions for version 1.4 - export helper module
!
    helper_create=PROCEDURE, -
    helper_lock=PROCEDURE, -
    helper_unlock=PROCEDURE, -
    helper_read=PROCEDURE, -
    helper_write=PROCEDURE, -
    helper_restart=PROCEDURE -
)

GSMATCH=LEQUAL,1,4
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ else
$!
$!   VAX build, assemble transfer vector.
$!
$    arch_suffix = "-vax"
$    gosub set_crypto_lib
$!
$    macro/obj=sys$disk:[]sshcryptvec.obj sys$input
;
; Transfer vector for VAX version of SSHCRYPTOSHR shareable image
;
	.TITLE SSH_TRANSFER_VECTOR
	.IDENT /OSU Crypto 1.4/
;
; Define macro to assist in building transfer vector entries.  Each entry
; should take no more than 8 bytes.
;
	.MACRO TRANSFER_ENTRY routine
	.ALIGN QUAD
	.TRANSFER routine
	.MASK	routine
	JMP	routine+2
	.ENDM TRANSFER_ENTRY
;
; Place entries in own program section.
;
	.PSECT $$SSHVEC,QUAD,PIC,USR,CON,REL,LCL,SHR,EXE,RD,NOWRT
ssh_xfer:
	TRANSFER_ENTRY sslmt_initialize
	TRANSFER_ENTRY sshrsa_init
	TRANSFER_ENTRY sshrsa_create
	TRANSFER_ENTRY sshrsa_destroy
	TRANSFER_ENTRY sshrsa_read_keyfile
	TRANSFER_ENTRY sshrsa_write_keyfile
	TRANSFER_ENTRY sshrsa_set_private_key
	TRANSFER_ENTRY sshrsa_set_public_key
	TRANSFER_ENTRY sshrsa_encrypt_number
	TRANSFER_ENTRY sshrsa_decrypt_number
	TRANSFER_ENTRY sshrsa_extract_public_key
	TRANSFER_ENTRY sshrsa_generate_key
	TRANSFER_ENTRY sshrsa_remote_request
;
	TRANSFER_ENTRY RAND_bytes
	TRANSFER_ENTRY md5_final
	TRANSFER_ENTRY md5_init
	TRANSFER_ENTRY md5_update
;
	TRANSFER_ENTRY sshciph_cipher_number
	TRANSFER_ENTRY sshciph_cipher_name
	TRANSFER_ENTRY sshciph_setup
	TRANSFER_ENTRY sshciph_state_size
	TRANSFER_ENTRY sshrsa_lookup_public_key
;
	TRANSFER_ENTRY helper_create
	TRANSFER_ENTRY helper_lock
	TRANSFER_ENTRY helper_unlock
	TRANSFER_ENTRY helper_read
	TRANSFER_ENTRY helper_write
	TRANSFER_ENTRY helper_restart
;
; Allocate extra storage at end of vector to allow for expansion.
;
	.BLKB 1024-<.-ssh_xfer>		; 2 pages total.
	.END
$!
$    link/share=sys$disk:[]sshcryptoshr.exe sys$input/option,sys$disk:[]pthread_libs_axp.opt/option
! linker options file to make shareable image
!
identification="OSU Crypto 1.4"
sshcryptvec.obj                 ! transfer vector
sshrsa_rpc.obj                  ! RSA key support (glue to ssleay).
helper.obj                      ! helper sub-process support.
tutil.obj                       ! general utility functions
ssl_mt.obj                      ! sets multi-threading.
sshcipher.obj
ssl_crypto_lib/lib              ! library containing SSLeay encryption code.
!
! Ensure transfer vector is at beginning of image
!
CLUSTER=FIRST
COLLECT=FIRST,$$SSHVEC
GSMATCH=LEQUAL,1,4
!
! make psects nonshareable so image can be installed.
!
PSECT_ATTR=$CHAR_STRING_CONSTANTS,NOWRT
PSECT_ATTR=BLAH,NOSHR
$ endif
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!  Subroutine to define ssl_crypto_lib logical if not already defined.  Name
$!  will be set explcitly to P1 if P1 is not null or SSL_CRYPTO_LIB.
$!
$ set_crypto_lib:
$    as = arch_suffix 
$    lib_list = "ssleaylib''as',libcrypto''as',crypto''as',libcrypto"
$    ndx = 0
$    if P1 .nes. "" .and. f$edit(p1,"UPCASE") .nes. "SSL_CRYPTO_LIB" then -
	define ssl_crypto_lib 'P1'
$!
$ next_lib:
$    if f$trnlnm("SSL_CRYPTO_LIB") .nes. "" then goto verify_crypto_lib
$    lname = f$element(ndx,",",lib_list)
$    if lname .eqs. "," then goto verify_crypto_lib
$    if f$search("ssllib:''lname'.olb") .nes. "" then -
	define ssl_crypto_lib ssllib:'lname'.olb
$    ndx = ndx + 1
$    goto next_lib
$!
$ verify_crypto_lib:
$    lib_file = f$parse("SSL_CRYPTO_LIB",".OLB")
$    if f$search(lib_file) .eqs. ""
$    then
$	write sys$output -
	  "SSL crypto library not found, check definition of SSLLIB"
$	exit
$    endif
$    return
