/*
 * Prototypes for sshrsa module, which handles low-level RSA encryption
 * operations and key management.
 */
typedef void *sshrsa;

sshrsa sshrsa_create();
sshrsa sshrsa_generate_key(int bits, int e, void (*callback)(int, int) );
void sshrsa_destroy(sshrsa);
sshrsa sshrsa_read_keyfile ( char *keyfile_name, int *bits, char errmsg[256] );
int sshrsa_write_keyfile ( char *keyfile_name, sshrsa key, char errmsg[256] );
int sshrsa_set_private_key ( int ebits, char *exp, int mbits, 
	char *modulus, sshrsa rsa );
int sshrsa_set_public_key ( int ebits, char *exp, int mbits, 
	char *modulus, sshrsa rsa );

int sshrsa_init(char *);		/* initialize random number generator */
/*
 * Encrypt number bads the multi-byte number to use the size of the rsa key,
 * fills the leading bytes with a random, null-terminated string, starting
 * with '\0'+'\2', and RSA encrypts (public key) the result.
 *
 * Decrypt number performs the inverse of encrypt, checking the result,
 * number
 */
int sshrsa_encrypt_number ( int bits, char *number, sshrsa key,
	char *buffer, int bufsize, int *outsize );

int sshrsa_decrypt_number (int bufsize, char *buffer, sshrsa key, char *number,
	int numsize, int *outsize );

int sshrsa_extract_public_key ( sshrsa rsa, int *e_bits, char **e_data,
	int *m_bits, char **m_data );
/*
 * Match user file, looks up public key in specfied user key file and
 * sets key to match.  Format of lines in  authfile:
 *    bits exponent modulus description
 *
 * If uic is non-zero, authfile owner must match.
 * On success, errmsg holds first 255 bytes of matching description.
 */
int sshrsa_lookup_public_key ( char *authfile, long uic, int bits,
	char *modulus, sshrsa rsa, char errmsg[256] );
