/*
 * Test completion port functions.
 */
#include <stdio.h>
#include <stdlib.h>
#include <iodef.h>

#include "completion_port.h"

int main ( int argc, char *argv )
{
    int status;
    cport_port port;
    cport_isb tt, isb;
    char errmsg[256];

    port = cport_create_port ( 0 );
    if ( !port ) { fprintf(stderr,"Port create failed, return null\n");
	return 0;
    }
    printf ( "Port created, address %x\n", port );

    tt = cport_assign_channel ( port, "TT:", 0 );
    if ( !tt ) {
	status = cport_last_assign_status( port, errmsg );
	printf("Error assigning channel: %d '%s'\n", status, errmsg );
	return status;
    }

    status = cport_start_io ( tt, CPORT_WRITE, "Hello World\r\n", 13 );
    printf("Status of qio2: %d, tt=%x\n", status, tt );

    while ( (status&1) == 1 ) {
	isb = cport_next_completion ( port );
	if ( !isb ) break;
	printf("\nisb returned: %x, iosb: %d %d %x %x, timer: %d\n", isb,
		isb->default_iosb[0], isb->default_iosb[1],
		isb->default_iosb[2], isb->default_iosb[3], isb->timer );
	status = cport_set_timeout ( isb, 10, 0 );
	status = cport_qio2 ( isb, IO$_READVBLK, errmsg, (void *) 256 );


    }
    return 1;
}
