#include <stdio.h>
#include <stdlib.h>
#include "completion_port.h"
int execpty_open(void **, int *, int, char *, char *, char *, long, char *);
cport_stream_handler cportpty_driver;

int main ( int argc, char **argv )
{
    void *pty_ctx;
    cport_isb in_pty, out_pty, isb;
    int status, geometry[4]={ 24, 80, 0, 0}, xcount;
    cport_port port;
    char errmsg[256], input[256];

    if ( argc < 3 ) { return 20; };

    status = execpty_open ( &pty_ctx, geometry, 0, "", argv[1],
	argv[2], 0x070001, errmsg );
    printf("Status of pty open: %d '%s'\n", status, errmsg );
    if ( (status&1) == 0 ) return status;

    port = cport_create_port ( 0 );
    in_pty = cport_assign_stream ( port, &cportpty_driver, pty_ctx, 0 );
    if ( !in_pty ) {
	status = cport_last_assign_status ( port, errmsg );
	printf("Error assigning stream: %d, '%s'\n", status, errmsg );
    }
    out_pty = cport_assign_stream ( port, &cportpty_driver, pty_ctx, 0 );
    if ( !out_pty ) {
	status = cport_last_assign_status ( port, errmsg );
	printf("Error assigning stream: %d, '%s'\n", status, errmsg );
    }
    status = cport_start_io ( out_pty, CPORT_READ, input, 200 );
    printf ( "Status of start_io read: %d\n", status );
    status = cport_start_io ( in_pty, CPORT_WRITE, "show system\r", 12 );
    printf ( "Status of start_io write: %d\n", status );

    while ( status&1 ) {
	isb = cport_next_completion ( port );
	if ( isb == in_pty ) {
	    printf("Write completed\n" );
	} else if ( isb == out_pty ) {
	    unsigned short int *iosb;
	    iosb = (unsigned short int *) isb->iosb;
	    printf("read completed: %d %d\n", iosb[0], iosb[1] );
	    input[iosb[1]] = '\0';
	    printf("'%s'\n", input );
	    status = cport_start_io ( out_pty, CPORT_READ, input, 200 );
	} else {
	    printf("unmatched isb address: %x\n", isb );
	    break;
	}
    }
    return status;
}
