/*
 * Test completion port functions.
 */
#include <stdio.h>
#include <stdlib.h>
#include <iodef.h>

#include "completion_port.h"
#include "cport_ucx.h"

void dump_isb ( cport_isb isb ) {
    printf("isb %x: qhead={%x,%x}\n", isb, isb->q.flink, isb->q.blink );
    printf("   user=%x, %d,  saved buf len=%d, addr=%x\n", isb->user_ptr,
	isb->user_val, isb->length, isb->buffer );
    printf("   iosb: %x,  callback=%x, port=%x, driver=%x\n",
	isb->iosb, isb->completion_callback, isb->port, isb->driver.ftable );
    printf("   timer: %d, timeou; %x def iosb: %d %d %d %d chan: %d\n",
	isb->timer, isb->timeout, isb->default_iosb[0], isb->default_iosb[1],
	isb->default_iosb[2], isb->default_iosb[3], isb->drv );
}

int main ( int argc, char **argv )
{
    int status;
    void *cnx, *listen_cnx;

    cport_port port;
    cport_isb tt, listener, visitor, isb;
    struct cportucx_accept_result remote_info;
    char errmsg[256];

    if ( argc < 3 ) {
	printf("usage: test host port\n" );
	return 1;
    }

    port = cport_create_port ( 0 );
    if ( !port ) { fprintf(stderr,"Port create failed, return null\n");
	return 0;
    }
    printf ( "Port created, address %x\n", port );

    errmsg[0] = '\0';
    status = cportucx_open_tcp_socket ( argv[1], atoi(argv[2]), 0, (char **) 0,
	&cnx, errmsg );
    printf("status of open: %d '%s' cnx=%x\n", status, errmsg, cnx );
    if ( status&1 == 0 ) {
	fprintf(stderr,"Socket open failed: %d '%s'\n", status, errmsg );
	return status;
    }
    listener = (cport_isb) 0;
    if ( argc > 3 ) {
	errmsg[0] = '\0';
	listen_cnx = 0;
	status = cportucx_create_tcp_listener ( atoi(argv[3]), 4, 0,
		(char **) 0, &listen_cnx, errmsg );
	printf("status of listener: %d %x '%s'\n", status, listen_cnx, errmsg );

	if ( status & 1 ) {
	    listener = cport_assign_stream ( port, &cportucx_driver, 
		listen_cnx, 0 );
	    printf("address of listener isb: %x\n", listener );
	}

	status = cport_start_io ( listener, CPORTUCX_ACCEPT,
		(char *) &remote_info, sizeof(remote_info) );
	printf("Status of accept start: %d\n", status );
    }

    tt = cport_assign_stream ( port, &cportucx_driver, cnx, 0 );
    if ( !tt ) {
	status = cport_last_assign_status( port, errmsg );
	printf("Error assigning channel: %d '%s'\n", status, errmsg );
	return status;
    }
    dump_isb ( tt );

    status = cport_start_io ( tt, CPORT_WRITE, 
	"GET / HTTP/1.0\r\n\r\n", 18 );
    printf("Status of qio2: %d, tt=%x\n", status, tt );
    dump_isb ( tt );
    status = cport_set_timeout ( tt, 10, 0 );
    visitor = (cport_isb) 0;

    while ( (status&1) == 1 ) {
	isb = cport_next_completion ( port );
	if ( !isb ) break;
	printf("Next completed %x, status: %d %d\n", isb, isb->default_iosb[0],
		isb->default_iosb[1] );
	if ( isb == listener ) {
	    printf("listener completion status: %d\n", isb->default_iosb[0] );
	    if ( (isb->default_iosb[0]&1) == 0 ) break;
	    printf("Remote port: %d, address: %d.%d.%d.%d\n", 
		remote_info.remote_port, remote_info.remote_address[0],
		remote_info.remote_address[1],remote_info.remote_address[2],
		remote_info.remote_address[3] );
	    visitor = cport_assign_stream ( port, &cportucx_driver,
		remote_info.io_ctx, 0 );
	    printf("Visitor assigned block: %x\n", visitor );
	    status = cport_start_io ( visitor, CPORT_WRITE,
		"Arrived safely\r\n", 16 );

	    status = cport_start_io ( listener, CPORTUCX_ACCEPT,
		(char *) &remote_info, sizeof(remote_info) );
	    printf("Status of accept start: %d\n", status );
	} else if ( isb == visitor ) {
	    printf ( "visitor completion status: %d\n", isb->default_iosb[0] );
	    cport_deassign ( visitor );
	} else {
	    if ( (isb->default_iosb[0]&1) == 0 && !listener ) break;
	    if ( (isb->default_iosb[0]&1) == 0 ) continue;
	    errmsg[isb->default_iosb[1]] = '\0';
	    printf("%s", errmsg );
	    status = cport_start_io ( isb, CPORT_READ, errmsg, 200 );
	}
    }
    printf("\n");
    return 1;
}
