/*
 * Test completion port functions.
 */
#include <stdio.h>
#include <stdlib.h>
#include <iodef.h>

#include "completion_port.h"
#include "cport_x11.h"
#include "parameters.h"

void dump_isb ( cport_isb isb ) {
    printf("isb %x: qhead={%x,%x}\n", isb, isb->q.flink, isb->q.blink );
    printf("   user=%x, %d,  saved buf len=%d, addr=%x\n", isb->user_ptr,
	isb->user_val, isb->length, isb->buffer );
    printf("   iosb: %x,  callback=%x, port=%x, driver=%x\n",
	isb->iosb, isb->completion_callback, isb->port, isb->driver );
    printf("   timer: %d, timeou; %x def iosb: %d %d %d %d chan: %d\n",
	isb->timer, isb->timeout, isb->default_iosb[0], isb->default_iosb[1],
	isb->default_iosb[2], isb->default_iosb[3], isb->drv );
}

int main ( int argc, char **argv )
{
    int status, i, count, server_number;
    void *cnx, *listen_cnx;

    cport_port port;
    cport_isb tt, listener[64], visitor, isb;
    struct cportx11_accept_result remote_info[64];
    char errmsg[256];

    if ( argc < 1 ) {
	printf("usage: test host port\n" );
	return 1;
    }
    if ( argc > 1 ) {
	status = init_parameters ( argv[1] );
	printf("parameter load status: %d\n", status );
    }

    port = cport_create_port ( 0 );
    if ( !port ) { fprintf(stderr,"Port create failed, return null\n");
	return 0;
    }
    printf ( "Port created, address %x\n", port );

    errmsg[0] = '\0';
    param.x11_servers=4;
    param.x11_server_number = 1;
    listener[0] = (cport_isb) 0;
    if ( argc > 0 ) {
	errmsg[0] = '\0';
	listen_cnx = 0;
	status = cportx11_create_x11_listener ( "JONESD", 
		&server_number, &listen_cnx, errmsg );
	printf("status of listener: %d %d %x '%s'\n", status, 
		server_number, listen_cnx, errmsg );

	if ( status & 1 ) {
	    listener[0] = cport_assign_stream ( port, &cportx11_driver, 
		listen_cnx, 0 );
	    printf("address of listener isb: %x\n", listener[0] );
	}

	if ( (status&1) == 1 ) {
	    status = cport_start_io ( listener[0], CPORTX11_ACCEPT,
		(char *) &remote_info[0], sizeof(remote_info[0]) );
	    printf("Status of accept start: %d\n", status );
	}
    }
    for ( count=1, i = 2; i < argc; i++ ) {
	errmsg[0] = '\0';
	listen_cnx = 0;
	status = cportx11_create_x11_listener ( argv[i], 
		&server_number, &listen_cnx, errmsg );
	printf("status of listener[%d]: %d server: %d %x '%s'\n", i-1, status, 
		server_number, listen_cnx, errmsg );

	if ( status & 1 ) {
	    listener[i-1] = cport_assign_stream ( port, &cportx11_driver, 
		listen_cnx, 0 );
	    printf("address of listener[%d] isb: %x\n", i-1,listener[i-1] );
	    count++;
	}
	if ( (status&1) == 1 ) {
	    status = cport_start_io ( listener[i-1], CPORTX11_ACCEPT,
		(char *) &remote_info[i-1], sizeof(remote_info[0]) );
	    printf("Status of accept start: %d\n", status );
	}
    }

    visitor = (cport_isb) 0;

    while ( (status&1) == 1 ) {
	isb = cport_next_completion ( port );
	if ( !isb ) break;
	printf("Next completed %x, status: %d %d\n", isb, isb->default_iosb[0],
		isb->default_iosb[1] );
	for ( i = 0; i < count; i++ ) if ( isb == listener[i] ) break;
	if ( i < count ) {
	    printf("listener[%d] completion status: %d\n", i,
			isb->default_iosb[0] );
	    if ( (isb->default_iosb[0]&1) == 0 ) break;
	    printf("Remote address: %s\n", remote_info[i].remote_address );

	    visitor = cport_assign_stream ( port, &cportx11_driver,
		remote_info[i].io_ctx, 0 );
	    printf("Visitor assigned block: %x\n", visitor );
	    status = cport_start_io ( visitor, CPORT_WRITE,
		"Arrived safely\r\n", 16 );

	    status = cport_start_io ( isb, CPORTX11_ACCEPT,
		(char *) &remote_info[i], sizeof(remote_info) );
	    printf("Status of accept start: %d\n", status );
	} else if ( isb == visitor ) {
	    printf ( "visitor completion status: %d\n", isb->default_iosb[0] );
	    cport_deassign ( visitor );
	} else {
	    if ( (isb->default_iosb[0]&1) == 0 && !listener ) break;
	    if ( (isb->default_iosb[0]&1) == 0 ) continue;
	    errmsg[isb->default_iosb[1]] = '\0';
	    printf("%s", errmsg );
	    status = cport_start_io ( isb, CPORT_READ, errmsg, 200 );
	}
    }
    printf("\n");
    return 1;
}
