/*
 * Test example driver.
 */
#include <stdio.h>
#include <syidef.h>

#include "completion_port.h"
#include "cport_example.h"
int main()
{
    int status, count, nodename_len;
    void *context;
    cport_port port;
    cport_isb isb, isb2;
    char buffer[100];
    struct { short length, code; void *buffer; int *retlen; } item[5];

    status = cport_example_open ( &context );
    printf("Status of example open: %d, context: %x\n", status, context );
    if ( (status&1) == 0 ) return status;
    port = cport_create_port ( 0 );
    if ( !port ) printf("Failed to create port\n");

    isb = cport_assign_stream ( port, &cportexample_driver, context, 0 );

    status = cport_do_io ( isb, CPORT_READ, buffer, 100, &count );
    printf("status of read: %d, count: %d\n", status, count );

    status = cport_do_io ( isb, CPORT_WRITE, buffer, 10, &count );
    printf("status of write: %d, count: %d\n", status, count );

    item[0].length = 15; item[0].code = SYI$_NODENAME;
    item[0].buffer = buffer; item[0].retlen = &nodename_len;
    item[1].length = item[1].code = 0;
    nodename_len = 0;

    status = cport_start_io ( isb, CPORT_EXAMPLE_GETSYI, item, -1 );
    printf("Status of getsyi start: %d\n", status );
    while ( (status&1) == 1 ) {
	isb2 = cport_next_completion ( port );
	if ( isb == isb2 ) {
	    if ( isb->default_iosb[0]&1 ) {
		buffer[nodename_len] = '\0';
		printf("Cluster member: %s\n", buffer );
	    } else {
		status = isb->default_iosb[0];
		break;
	    }
	}
	status = cport_start_io ( isb, CPORT_EXAMPLE_GETSYI, item, -1 );
    }
    printf("Final getsyi status: %d\n", status );

    status = cport_deassign ( isb );
    return status;
}
