/*
 * test pipe driver.
 */
#include <stdio.h>
#include "pthread_1c_np.h"
#ifndef PTHREAD_USE_D4
	    typedef void * (*startroutine_t)(void *);
#endif
#include "completion_port.h"
#include "cport_pipe.h"

void *child_main ( void *pipe_ctx )
{
    cport_isb in, out;
    cport_port port;
    int status, xfer;
    char buffer[200];

    port = cport_create_port ( 0 );

    out = cport_assign_stream ( port, &cportpipe_driver, pipe_ctx, 0 );
    in = cport_assign_stream ( port, &cportpipe_driver, pipe_ctx, 0 );

    status = cport_do_io ( in, CPORT_READ, buffer, sizeof(buffer), &xfer );
    printf ( "child read status: %d %d\n", status, xfer );
    if ( (status&1) ) {
	status = cport_do_io ( out, CPORT_WRITE, "response", 8, &xfer );
	printf("child write status: %d\n", status );
    }
    status = cport_do_io ( in, CPORT_READ, buffer, sizeof(buffer), &xfer );
    printf("child second read: %d %d\n", status, xfer );
    return (void *) 0;
}

int main ( int argc, char **argv )
{
    cport_port port;
    cport_isb in, out;
    void *pipe_ctx;
    pthread_t child;
    pthread_attr_t client_attr;
    int status, xfer;
    char buffer[200];

    port = cport_create_port ( 0 );

    status = cport_pipe_open ( port, &pipe_ctx );
    if ( (status&1) == 0 ) return status;

    out = cport_assign_stream ( port, &cportpipe_driver, pipe_ctx, 0 );
    in = cport_assign_stream ( port, &cportpipe_driver, pipe_ctx, 1 );
    /*
     * create thread.
     */
    INITIALIZE_THREAD_ATTR ( &client_attr );
#ifdef PTHREAD_USE_D4
    status = pthread_create ( &child, client_attr,
		(pthread_startroutine_t) child_main, pipe_ctx );
#else
    status = pthread_create ( &child, &client_attr, 
		(startroutine_t) child_main, pipe_ctx );
#endif
    if ( status != 0 ) {
	fprintf(stderr,"Client thread create failure\n");
	/* Failure to create a thread is a fatal error. */
	return 0;
    }

    status = cport_do_io ( out, CPORT_WRITE, "call", 4, &xfer );
    printf("Status of master write: %d %d %d\n", status,
	out->default_iosb[0], out->default_iosb[1] );

    status = cport_do_io ( in, CPORT_READ, buffer, sizeof(buffer), &xfer );
    printf("Status of master read: %d %d\n", status, xfer );
    if ( (status&1) == 1 ) {
	buffer[xfer] = '\0';
	printf( "  buffer: '%s'\n", buffer );
    }
    return status;
}
