/*
 * Validate sshrsa module.
 *
 * Building:
 *    $ cc testrsa
 *    $ link testrsa,sshcrypto.opt/opt
 *
 * Usage:
 *    $ define sshcryptoshr sys$disk:[]sshcryptoshr.exe
 *    $ mcr sys$disk:[]testrsa pem-file
 */

#include <stdio.h>
#include <stdlib.h>
#include "sshrsa.h"

int main ( int argc, char **argv ) {
    int status, i, size, bits, out;
    void verify_key();
    sshrsa key;
    char errmsg[256];
    char *clear, *encoded, *clear2;

    if ( argc < 2 ) {
	fprintf(stderr,"Usage: testrsa pem-file");
	return 1;
    }

    status = sshrsa_init("");		/* use local */
    printf("Status of sshrsa_init: %d\n", status );
    if ( status&1 == 0 ) return status;

    key = sshrsa_read_keyfile ( argv[1], &bits, errmsg );
    if ( !key ) {
	printf("Error reading keyfile '%s': '%s'\n", argv[1], errmsg );
	return 1;
    }
    /* verify_key ( key ); */

    printf("Key read from PEM file, size = %d bits\n", bits );
    size = bits/8;
    clear = malloc ( size );
    encoded = malloc ( size );
    clear2 = malloc ( size );
    for ( i = 0; i < size; i++ ) { clear[i] = (i&127); clear2[i] = 0; }
    clear[0] = clear[1] = clear[2] = clear[3] = 0;

    status = sshrsa_encrypt_number ( bits, clear, key, encoded, size, &out );
    printf("Status of encrypt: %d, bytes out=%d\n", status, out );
    status = sshrsa_decrypt_number ( size, encoded, key, clear2, size,
	&out );
    printf("Status of decrypt: %d %d\n", status, out );
    /*
     * Skip header portion added by encrypt routine.
     */
    clear[1] = 2;
    clear2[2] = 0;
    for ( i = 0; i < size; i++ ) {
	if ( clear[i] != clear2[i] ) {
	    printf("Verification failure, clear[%d] does not match (%d)\n",
		i, clear2[i] );
	    break;
	}
    }
    return 1;
}
