#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sslinc:bn.h"
/*
 * Interpret character string as a very very large decimal number and
 * return as character array that encodes the raw bits.
 */
int decode_number ( char *number, int numsize, int *bits, char **data )
{
    BIGNUM *a, *b, *c, *billion;
    int digit, i, j, pos, size;
    unsigned long value;
    /*
     * Initialize Bignum variables.
     */
    a = BN_new();			/* initially zero */
    b = BN_new();
    c = BN_new();
    billion = BN_new();
    BN_set_word ( billion, 1000000000 );
    /*
     * Get length of string and break into 9 char chunks.
     */
    size = 0;
    for ( i = 0; i < numsize; i += size ) {
	/*
	 * Convert next 'size' characters to an integer.
	 */
	if ( size == 0 ) {
	    size = numsize%9;
	    if ( size == 0 ) size = 9;
	} else size = 9;
	value = 0;
	for ( j = 0; j < size; j++ ) {
	    value = (value*10) + (number[i+j]-'0');
	}
	/*
	 * Shift and add.
	 */
	BN_mul ( b, a, billion );		/* b = a * 10^9 */
	BN_set_word ( c, value );
	BN_add ( a, b, c );			/* a = b + c */
    }
    /*
     * Convert to raw array.
     */
    BN_free ( billion );
    BN_free ( c );
    BN_free ( b );
    size = BN_num_bytes ( a );
    *data = malloc ( size );
    if ( *data ) i = BN_bn2bin ( a, (unsigned char *) *data );
    else i = 0;
    BN_free ( a );
    *bits = i*8;
    return 1;
}

#ifndef DEBUG
static void dump_buffer ( char *heading, unsigned char *buffer, int bufsize )
{
    int i, j;
    printf ( "%s (%d bytes):", heading, bufsize );
    j = 15;
    for ( i = 0; i < bufsize; i++ ) {
	j++;
	if ( j > 15 ) {
	    printf("\n   %04x:", i ); j = 0; }
	printf(" %02x", 255&buffer[i] );
    }
    printf("\n");
}
int main ( int argc, char **argv )
{
    int length, i, status, bits, LIB$INIT_TIMER(), LIB$SHOW_TIMER();
    char *keyfile, *bitsize, *exponent, *modulus, *desc, line[8192];
    char *binnum;
    FILE *kf;
    if ( argc < 2 ) keyfile = "authorized_keys.dat";
    else keyfile = argv[1];

    kf = fopen ( keyfile, "r" );
    if ( !kf ) { printf("Error opening %s\n", keyfile ); return 0; }

    while ( fgets ( line, sizeof(line), kf ) ) {
	for ( i = 0; i < sizeof(line) && line[i]; i++ ) {
	    if ( line[i] == '\n' ) break;
	}
	line[i] = '\0';

	bitsize = strtok ( line, " \t" );
	printf("Bitsize (%d) '%s'\n", strlen(bitsize), bitsize );
	exponent = strtok ( (char *) 0, " \t" );
	printf("exponent (%d) '%s'\n", strlen(exponent), exponent );
	modulus = strtok ( (char *) 0, " \t" );
	printf("modulus (%d) '%s'\n", strlen(modulus),modulus);
	desc = strtok ( (char *) 0, " \t" );
	printf("desc (%d) '%s'\n", strlen(desc), desc );

	LIB$INIT_TIMER();
	for ( i = 0; i < 10000; i++ ) {
	status = decode_number ( modulus, strlen(modulus), &bits, &binnum );
	free ( binnum );
	} LIB$SHOW_TIMER();
	status = decode_number ( modulus, strlen(modulus), &bits, &binnum );
	printf("Status of decode: %d, bits: %d\n", status, bits );
	dump_buffer ( "modulus", (unsigned char *) binnum, (bits+7)/8 );
    }
}
#endif
