
 /*TCONTROL6   19-NOV-1999, David Mathog, Biology Division, Caltech?   This program is designed to control/read the pins on a serial ?   port on an OpenVMS system for use with a UPS or other similar 7   device.  (Not for communcations in the normal sense!)   
   build with:   B   $ cc/standard=ansi89/prefix=all/warn=(disable=DOLLARID) tcontrol   $ link tcontrol   +   The terminal should be set up first with:   +   $ set term/perm/nomodem/nobroadcast tta0:    */   #include <stdlib.h>  #include <stdio.h> #include <string.h>  #include <ctype.h> #include <dcdef.h> #include <descrip.h> #include <iodef.h> #include <ssdef.h> #include <starlet.h> #include <ttdef.h> #include <tt2def.h>  #include <lib$routines.h>   
 /* globals */    typedef struct {   short cond_value;    short count;   int info;    } io_status_blk;    = int set_channel(unsigned short dev_chan, unsigned int toset){  io_status_blk the_iosb;  struct {   short int     empty;   unsigned char bits_on;   unsigned char bits_off;    unsigned long vacant; 
 } set_blk;  Y     /* toset is a bit mask, bits set in it go to read it and do the appropriate things */ -     set_blk.bits_on  = (unsigned char) toset; :     set_blk.bits_off = (unsigned char) 0xFFFFFFFF ^ toset;   !     if( 1 & sys$qiow(0, dev_chan, ,       IO$_SETMODE|IO$M_SET_MODEM|IO$M_MAINT,1       &the_iosb, 0, 0, &set_blk, 0, 0, 0, 0, 0)){        return (1);      }      return (0);  }   4 unsigned int sense_channel(unsigned short dev_chan){ io_status_blk the_iosb;  struct {   unsigned char devtype;   unsigned char empty;   unsigned char bits;    unsigned char empty_also;    unsigned long vacant; 
 } sense_info;  unsigned int temp;       if( !(sys$qiow(0, dev_chan, (             IO$_SENSEMODE|IO$M_RD_MODEM,?             &the_iosb, 0, 0, &sense_info, 0, 0, 0, 0, 0) & 1)){ J        (void) printf("Fatal error, could not read modem bits, exiting\n");        exit(EXIT_FAILURE);     } 
     else {        temp = 0;%        temp = sense_info.bits;                return(temp);     }  }       . unsigned short get_dev_channel(char *devname){ unsigned short channel = 0; D struct dsc$descriptor_s thedesc = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};  +    thedesc.dsc$w_length  = strlen(devname); #    thedesc.dsc$a_pointer = devname; B    if( (sys$assign(&thedesc, &channel, 0, 0) & 1))return(channel);
    return(0);  }   Z /* scan (case insensitive) "string" for the pattern "find" and if it matches (all the same/    through the terminator) OR bits with val. */   Q void set_if_present(char *string,unsigned int *val,char *find,unsigned int bits){ 
 char *pnt; char *tpnt;  char *fpnt; -   if(*string == '\0' || *find == '\0')return; *   for (pnt = string; *pnt != '\0' ;pnt++){c     if( (*pnt != ' ') && (*pnt != ',') && (*pnt != '	')){ /* no point searching with a delimiter */ P       for(tpnt=pnt, fpnt=find; toupper(*tpnt) == toupper(*fpnt); tpnt++,fpnt++){:         if(*fpnt == '\0'){ /* found "foo^" in "goo,foo" */            *val |= bits;            return;	         }        } A       if(*fpnt == '\0'){ /* like "foo^" hitting in "foo,goo",  */          *val |= bits;          return;        }      }    } 	   return;  }   O /* ok not to check lengths here because we know there are only a few characters D    which can be added and list is long enough to take all of them */  * void add_to_list(char *list,char *string){   if(*list == '\0'){     (void) strcpy(list,string);    }    else {     (void) strcat(list,",");     (void) strcat(list,string);    }  }   - void set_dcl_symbol(char *name, char *value){ + struct  dsc$descriptor_s  symbol_name_desc; , struct  dsc$descriptor_s  symbol_value_desc;  /   symbol_name_desc.dsc$w_length = strlen(name); )   symbol_name_desc.dsc$a_pointer =  name; 0   symbol_name_desc.dsc$b_class =  DSC$K_CLASS_S;0   symbol_name_desc.dsc$b_dtype =  DSC$K_DTYPE_T;2   symbol_value_desc.dsc$w_length = strlen(value); +   symbol_value_desc.dsc$a_pointer =  value; 1   symbol_value_desc.dsc$b_class =  DSC$K_CLASS_S; 1   symbol_value_desc.dsc$b_dtype =  DSC$K_DTYPE_T; >   (void) LIB$SET_SYMBOL(&symbol_name_desc,&symbol_value_desc); }    /* main routine */  " void main(int argc, char *argv[]){ unsigned int sensed; unsigned int flipsensed; unsigned short dev_chan; unsigned int toset;  unsigned int looking;  unsigned int waithigh; unsigned int waitlow;  unsigned int maxwait;  unsigned int countwait;  static float wait_time = 1.0;  static char symbol_value[2000];           if(argc < 2){H       (void) printf("Fatal error, a serial device must be specified\n");!       (void) printf("syntax:\n"); C       (void) printf("$ tcontrol device bitset waithigh waitlow\n"); M       (void) printf("   device:   tta0: or other serial device (not LAT)\n"); [       (void) printf("   bitset:   bits to set high from {DTR,RTS,SecTX}, others go low\n"); a       (void) printf("   waithigh: wait until these bits go high, from {CTS,DSR,CARRIER,RING}\n"); `       (void) printf("   waitlow:  wait until these bits go low, from {CTS,DSR,CARRIER,RING}\n");O       (void) printf("      if more than one in a list separate with spaces\n"); L       (void) printf("   maxwait:  seconds to wait. 0 is forever [default]");       (void) printf("\n");^       (void) printf("   tcontrol_high is set on exit, contains the names of the high bits\n");9       (void) printf("     or TIMED_OUT or NOT_TESTED\n");        exit(EXIT_FAILURE);     }'    dev_chan = get_dev_channel(argv[1]);   
    toset = 0;     if(argc >= 3){ 6      set_if_present(argv[2],&toset,"DTR",TT$M_DS_DTR);6      set_if_present(argv[2],&toset,"RTS",TT$M_DS_RTS);:      set_if_present(argv[2],&toset,"SecTX",TT$M_DS_SECTX);    }      waithigh = 0;    if(argc >= 4){ 9      set_if_present(argv[3],&waithigh,"CTS",TT$M_DS_CTS); 9      set_if_present(argv[3],&waithigh,"DSR",TT$M_DS_DSR); A      set_if_present(argv[3],&waithigh,"CARRIER",TT$M_DS_CARRIER); ;      set_if_present(argv[3],&waithigh,"RING",TT$M_DS_RING);     }      waitlow = 0;     if(argc >= 5){ 8      set_if_present(argv[4],&waitlow,"CTS",TT$M_DS_CTS);8      set_if_present(argv[4],&waitlow,"DSR",TT$M_DS_DSR);@      set_if_present(argv[4],&waitlow,"CARRIER",TT$M_DS_CARRIER);:      set_if_present(argv[4],&waitlow,"RING",TT$M_DS_RING);    }      maxwait = 0;     if(argc >= 6){ .      if(sscanf(argv[5],"%d",&maxwait) == EOF){Q        (void) printf("Fatal Error: maxwait seconds value is invalid, exiting\n");         exit (EXIT_FAILURE);       }    }    if(maxwait < 0)maxwait=0;     &    if(! set_channel(dev_chan, toset)){E       (void) printf("Fatal Error: could not set channel, exiting\n");        exit (EXIT_FAILURE);    }      if(!(waithigh | waitlow)){ 4       set_dcl_symbol("TCONTROL_HIGH", "NOT TESTED");B       exit (EXIT_SUCCESS); /* leave if not waiting for anything */    }      countwait=maxwait; 
    while (1){ '       sensed = sense_channel(dev_chan); '       flipsensed = 0xFFFFFFFF ^ sensed; 4       if(sensed & waithigh || flipsensed & waitlow){          symbol_value[0]='\0';I          if (sensed & TT$M_DS_CTS)(void) add_to_list(symbol_value,"CTS"); I          if (sensed & TT$M_DS_DSR)(void) add_to_list(symbol_value,"DSR"); Q          if (sensed & TT$M_DS_CARRIER)(void) add_to_list(symbol_value,"CARRIER"); K          if (sensed & TT$M_DS_RING)(void) add_to_list(symbol_value,"RING"); 7          set_dcl_symbol("TCONTROL_HIGH", symbol_value);           exit (EXIT_SUCCESS);        }        else {$         (void) lib$wait(&wait_time);         if(maxwait != 0){             countwait--;             if(countwait <= 0){:              set_dcl_symbol("TCONTROL_HIGH", "TIMED_OUT");!              exit (EXIT_SUCCESS);             }	         }        }     }    exit (EXIT_SUCCESS);  } 