C	PIPE_COLUMNADD.FOR
C	29-JUN-1998 David Mathog, Division of Biology, Caltech
C
C	This RIDICULOUS little program sort of adds up columns
C	of numbers or times (from the accounting facility, for instance).
C
C	This variant reads from sys$input, writes to sys$output
c
c	It just reads along processing each line until it hits
c	a blank line.
c	"Processing" means that it adds all integers and just
c	saves and overwrites all other symbols.
c	At the blank line, it performs carries based on the rules:
c	  carry at multiples of 10 one column less
c	  UNLESS
c	    Left most # in :##. or :##:, in which case carry at 60
c	       to the other side of the :
c	    bracketed by <space>##:, in which case carry at 24 to 
c	       the other side of the space
c
C
	implicit none
	character*256 inline,outline,infile,outfile
	integer*4 inlen,istat,onechar,carry,maxlen,i,case
	integer*4 sumline(256),tagline(256)
c
c
	open(unit=10,file='SYS$INPUT'
	1 ,form='FORMATTED',carriagecontrol='LIST',status='OLD',
	1  READONLY)
c
	open(unit=11,file='SYS$OUTPUT'
	1 ,form='FORMATTED',carriagecontrol='LIST',status='NEW'
	2 ,recl = 256)
c
	istat=0
	do while(istat.ge.0)
	    read(10,1000,iostat=istat)inlen,inline(1:inlen)
1000	    format(q,a)
	    if(inlen.ne.0 .and. istat. ge. 0)then !not a blank line
c
c	This section does accumulation on NONblank lines
c
	       if(inlen.gt.256)then
	          write(6,*)'Truncating line longer than 256 characters'
	          write(6,*)'Line begins:>>>',inline(1:60),'<<<'
	          inlen = 256
	       end if
	       outline(1:inlen)=inline(1:inlen)
	       if(inlen.gt.maxlen)maxlen=inlen
	       do i=1,inlen
	         onechar=ichar(inline(i:i))-48	!convert ascii 0-9 to val 0-9
	         if(onechar.eq.-39)STOP 'Fatal error - no TABS allowed'
	         if(onechar.ge.0 .and. onechar.le.9)then
	            sumline(i)=sumline(i)+onechar
	            tagline(i)=1
	         end if
               end do
	    else		!a blank line or end of file
C
C	This section does the formatting for the output and when
c	done clears the accumulators
C
	       carry=0
	       do i=maxlen,2,-1
	          if(tagline(i).ne.0)then	!contains numbers
	             sumline(i)=sumline(i)+carry !from last column
	             carry=0
	             if(inline(i-1:i-1).eq. ':')then
	                if(inline(i+2:i+2).eq. ':' .or. 
	1	           inline(i+2:i+2).eq. '.')then !modulo 60
	                    case=2
	                else				!modulo 10
	                  case=1
	                end if
	             else if(inline(i-1:i-1).eq. ' ')then
	                if(inline(i+2:i+2).eq. ':')then !modulo 24
	                  case=3
	                else				!modulo 10
	                  case=1
	                end if
	             else			!modulo 10
	                 case=1
	             end if
	             if(case.eq.1)then		!modulo 10
	                  carry=sumline(i)/10
	                  outline(i:i)=char(48+jmod(sumline(i),10))
	                  if(carry.gt.0. and. inline(i-1:i-1) .ne. '.')
	1                 tagline(i-1)=1
	             else if(case.eq.2)then	!modulo 60
	                carry=sumline(i)/6
	                outline(i:i)=char(48+jmod(sumline(i),6))
	             else if(case.eq.3)then	!modulo 24
	                    sumline(i)=sumline(i)*10
	1                       +ichar(outline(i+1:i+1))-48
	                    carry=sumline(i)/24
	                    sumline(i)=sumline(i) - carry*24
	                    outline(i:i)=char(48+sumline(i)/10)
	                    outline(i+1:i+1)=char(48+jmod(sumline(i),10))
	             else
	                 STOP 'programming error, case not 1<->3'
	             end if
	          end if
	       end do
	       if(tagline(1).eq.1)then
	          sumline(1) =sumline(1) + carry
	          carry=sumline(1)/10
	          if(carry.gt.0)then	!overflowed the line
	            outline(1:1)='*'
	          else
 	            outline(1:1)=char(48+sumline(1))
	          end if
	       end if
	       write(11,1100)outline(1:maxlen)
1100	format(a)
	       do i=1,maxlen		!clear all of the fields
	         tagline(i)=0
	         sumline(i)=0
	         outline(i:i)=' '
               end do
	       carry=0
	       maxlen=0
	    end if
	end do
	close(unit=10)
	close(unit=11)
	stop
	end

