#   descrip.mms - OpenVMS makefile for WUsage v3.2
#
#   Written by: Rick Dyson  (rick-dyson@uiowa.edu)
#   Last Modified: 28-AUG-1996 RLD with contributions by
#                              Martin Zinser (zinser@eur.sas.com)
#                   4-SEP-1997 RLD tested for OpenVMS v7.1 and DEC C v5.6
#
#   Note: Even if you have MMS (or MMK), you should build WUsage via the
#   command procedure Make_VMS.com.  It will use MMS (or MMK) if you have
#   it and get all the setups as well.
#
#   Targets accepted:
#
#       wusage.exe  - build wusage 
#       clean       - delete all extra versions and OBJ files
#       clobber     - "clean" plus delete all EXE and OPT files
#       install     - build wusage and move the EXE to OSU WWW_System:
#
#   The default assumption I use is to build WUsage with the DEC C compiler
#   (either Alpha or VAX).  In that case, simply type 
#
#           MMS
#
#   For other compilers:
#
#       If you want to use VAX C, use this command:
#
#           MMS /Macro=VAXC=1
#
#       If you want to use GNU C, use this command:
#
#           MMS /Macro=GNUC=1

.ifdef VAXC                 # VAX C
CC = CC
OPTFILE = wusage_vaxc.opt
OPTION = /Option
.else
.ifdef GNUC                 # GNU C
CC = gcc
OPTFILE = wusage_gnuc.opt
OPTION = /Option
.else                       # DEC C
CC = CC /DECC
OPTFILE = 
OPTION = 
.endif
.endif

.last
	@- Set Message /Facility /Severity /Identification /Text 

linkflags = /NoDebug /NoTrace /NoMap /Executable = WUsage.exe
objs = wusage.obj configure.obj graph.obj gd.obj chart.obj

wusage.exe : 	$(objs) $(OPTFILE)
        $(link) $(linkflags) $+ $(OPTION)

.ifdef VAXC
wusage.obj :	wusage.c
	- $(CC) $(CFLAGS) $*
.endif

wusage_vaxc.opt :
	@ Open /Write TMP $(OPTFILE)
	@ Write TMP "! WUsage (v3.2-VMS) Linker Options for OpenVMS VAX C"
	@ Write TMP "!"
	@ Write TMP "Sys$Library:VAXCRTL.EXE /Share"
	@ Write Sys$Output "OpenVMS VAX C ..."
	@ Close TMP

wusage_gnuc.opt :
	@ Open /Write TMP $(OPTFILE)
	@ Write TMP "! WUsage (v3.2-VMS) Linker Options for OpenVMS GNU C"
	@ Write TMP "!"
	@ Write TMP "Sys$Library:VAXCRTL.EXE /Share"
	@ Write TMP "GNU_CC:[000000]GCCLib.olb /Library"
	@ Write Sys$Output "OpenVMS GNU C ..."
	@ Close TMP

install :	wusage.exe
	Rename *.exe www_system

clean :
	@- Set Message /NoFacility /NoSeverity /NoIdentification /NoText 
	@- Set Protection = (Owner:RWED) *.*;-1
	- Purge /NoConfirm /NoLog
	- Delete /NoConfirm /NoLog *.obj;*

clobber :	clean
	@- Set Protection = (Owner:RWED) *.exe;*,*.opt;*
	- Delete /NoLog /NoConfirm *.exe;*,*.opt;*
