$!  Make_VMS.com
$!
$!  Build the WUsage program for an OpenVMS system from the C sources.
$!
$!  Command line parameters accepted:
$!
$!      DECC [LINK] - Compile and link [or just link] with the DEC C compiler
$!      VAXC [LINK] - Compile and link [or just link] with the VAX C compiler
$!      GNUC [LINK] - Compile and link [or just link] with the GNU C compiler
$!      CLEAN       - Clean off OBJ files and purge old copies of other files
$!      CLOBBER     - Delete all non-source files
$!      INSTALL     - Move the compiled EXE file to the OSU's System directory
$!
$!  This will determine if you are on a VAX or an Alpha automagically.
$!
$!  For a VAX with VAX C only, it will automagically determine this and
$!  you need not do anything unless you want to override this for GNU C.
$!
$!  To use the GNU C compiler, execute the following command:
$!
$!      @ MAKE_VMS GNUC
$!
$!  To override the automagic determination of DEC C vs. VAX C and force
$!  the use of the VAX C compiler, use:
$!
$!      @ MAKE_VMS VAXC
$!
$!  Written By: Rick Dyson (rick-dyson@uiowa.edu)
$!  Last Modified: 29-AUG-1996 RLD w/ contributions by Martin Zinser (zinser@eur.sas.com)
$!
$
$ On Error     Then GoTo ERROR
$ On Control_Y Then GoTo ERROR
$
$ If "''P1'" .eqs. "CLEAN"   Then GoTo CLEAN
$ If "''P1'" .eqs. "CLOBBER" Then GoTo CLOBBER
$ If "''P1'" .eqs. "INSTALL" Then GoTo INSTALL
$
$ Make = ""
$ CC = "CC /DECC"
$ C_Flavor = ""
$ LFlags = "/NoDebug /NoTrace /NoMap /Executable = WUSAGE.EXE"
$
$! Check for MMK/MMS
$ If F$Search ("Sys$System:MMS.EXE") .nes. "" Then Make = "MMS"
$ If F$Type (MMK) .eqs. "STRING" Then Make = "MMK"
$
$ Open /Write TMP wusage.opt
$
$ If ("''P1'" .eqs. "DECC" .or. "''P2'" .eqs. "DECC")
$   Then
$       CC = "CC /DECC"
$       GoTo DECC
$ EndIf
$
$ If ("''P1'" .eqs. "VAXC" .or. "''P2'" .eqs. "VAXC")
$   Then
$       CC = "CC"
$       C_Flavor = "VAXC"
$       GoTo VAXC
$ EndIf
$
$ If ("''P1'" .eqs. "GNUC" .or. "''P2'" .eqs. "GNUC")
$   Then
$       CC = "GCC"
$       C_Flavor = "GNUC"
$       GoTo GNUC
$ EndIf
$
$ GoTo DECC
$
$DECC:
$
$   If F$GetSyi ("HW_MODEL") .gt. 1023 
$       Then
$           COpts = "/NoDebug /Optimize /NoList /Prefix=All"
$           Write TMP "! WUsage (v3.2-VMS) Linker Options for Alpha OpenVMS DEC C"
$           Write TMP "!"
$           Write TMP "! a dummy place holder file..."
$           Write Sys$Output "Alpha OpenVMS & DEC C ..."
$       Else        ! Using a VAX
$           If F$Search ("Sys$System:DECC$Compiler.exe") .nes. ""
$               Then
$                   COpts = "/Prefix = All /NoDebug /Optimize /NoList"
$                   Write TMP "! WUsage (v3.2-VMS) Linker Options for VAX OpenVMS DEC C"
$                   Write TMP "!"
$                   Write TMP "! a dummy place holder file..."
$                   Write Sys$Output "VAX OpenVMS & DEC C..."
$               Else
$                   COpts = "/NoDebug /Optimize /NoList"   
$                   Write TMP "! WUsage (v3.2-VMS) Linker Options for VAX OpenVMS VAX C"
$                   Write TMP "!"
$                   Write TMP "Sys$Library:VAXCRTL.EXE /Share"   
$                   Write Sys$Output "VAX OpenVMS & VAX C..."
$           Endif
$   EndIf
$   Close TMP
$   If ("''P1'" .eqs. "LINK" .or. "''P2'" .eqs. "LINK") Then GoTo LINK
$   GoTo COMPILE
$
$VAXC:
$
$   If F$Trnlnm ("SYS") .eqs. "" Then Define /NoLog Sys Sys$Library
$   COpts = "/NoDebug /Optimize /NoList"
$   
$   Write TMP "! WUsage (v3.2-VMS) Linker Options for VAX OpenVMS VAX C"
$   Write TMP "!"
$   Write TMP "Sys$Library:VAXCRTL.EXE /Share"
$   Close TMP
$   
$   Write Sys$Output "VAX OpenVMS & forced VAX C..."
$   If ("''P1'" .eqs. "LINK" .or. "''P2'" .eqs. "LINK") Then GoTo LINK
$   GoTo COMPILE
$
$GNUC:
$
$   Write TMP "! WUsage (v3.2-VMS) Linker Options for VAX OpenVMS GNU C"
$   Write TMP "!"
$   Write TMP "Sys$Library:VAXCRTL.EXE /Share"
$   Write TMP "GNU_CC:[000000]GCCLib.olb /Library"
$   Close TMP
$
$   Write Sys$Output "OpenVMS VAX & GNU C..."
$   If ("''P1'" .eqs. "LINK" .or. "''P2'" .eqs. "LINK") Then GoTo LINK
$   GoTo COMPILE
$
$COMPILE:
$
$   Write Sys$Output "Compiling..."
$   If (Make .nes. "") .and. .not. ("''P1'" .eqs. "DCL" .or. "''P2'" .eqs. "DCL")
$       Then
$           If (C_Flavor .eqs. "")
$               Then
$                   'Make'
$!$                   'Make' /Macro = (cc="''CC'", cflags="''COPts'")
$               Else
$                   'Make' /Macro = "''C_Flavor'=1"
$           EndIf
$           GoTo END
$       Else
$           Write Sys$Output "            wusage.c"
$           'CC' 'COpts' wusage.c
$           Write Sys$Output "            configure.c"
$           'CC' 'COpts' configure.c
$           Write Sys$Output "            graph.c"
$           'CC' 'COpts' graph.c
$           Write Sys$Output "            gd.c"
$           'CC' 'COpts' gd.c
$           Write Sys$Output "            chart.c"
$           'CC' 'COpts' chart.c
$
$           GoTo LINK
$
$   EndIf
$
$LINK:
$
$     Write Sys$Output "Linking WUsage..."
$     Link 'LFlags' wusage,configure,graph,gd,chart,wusage.opt/opt
$
$END:
$
$   Write Sys$Output "Successful build of WUsage v3.2 for OpenVMS..."
$   Exit
$
$ERROR:
$
$   Set NoOn
$   Set Message /NoFacility /NoSeverity /NoIdentification /NoText 
$   Close Tmp
$   Set Message /Facility /Severity /Identification /Text 
$   Exit
$
$INSTALL:
$
$   Set NoOn
$   Rename WUsage.exe WWW_System:
$   If .not. $Status
$       Then
$           Write Sys$Output ""
$           Write Sys$Output "Did you build the EXE yet?"
$           Write Sys$Output "Or maybe you don't have write permission to the WWW_System directory?""
$   EndIf
$   Exit
$
$CLEAN:
$
$   Set NoOn
$   Set Message /NoFacility /NoSeverity /NoIdentification /NoText 
$   Set Protection = (Owner:RWED) *.*;-1
$   Write Sys$Output "Purging..."
$   Purge /NoConfirm /NoLog
$   Write Sys$Output "Deleting OBJs..."
$   Delete /NoConfirm /NoLog *.obj;*
$   Set Message /Facility /Severity /Identification /Text 
$
$   Exit
$
$CLOBBER:
$
$   Set NoOn
$   Set Message /NoFacility /NoSeverity /NoIdentification /NoText 
$   Set Protection = (Owner:RWED) *.*;-1,*.exe;*,*.opt;*
$   Write Sys$Output "Purging..."
$   Purge /NoConfirm /NoLog
$   Write Sys$Output "Deleting OBJs, EXEs, & OPTs..."
$   Delete /NoConfirm /NoLog *.obj;*,*.exe;*,*.opt;*
$   Set Message /Facility /Severity /Identification /Text 
$
$   Exit
