// **************************************************************************
// **           COME BACK 64 - A FREEWARE COMMODORE 64 EMULATOR            **
// **          WWW.COMEBACK.C64.ORG             JHF@FAIRLIGHT.TO           **
// **************************************************************************
// **                 THIS IS VERSION ALPHA 1 FOR UNIX                     ** 
// **************************************************************************
// ** MAIN PROGRAMMERS      : JOHAN FITIE AND BRAD MARTIN                  **
// ** ROUTINE CONTRIBUTORS  : STEVEN H. DON - SOME SOUND FIXES             **
// **                         MASSIMILIANO AGOSTINELLI - CARTRIDGE LOADER  **
// ** SUPPORT               : PONTUS BERG (BACCHUS/FAIRLIGHT)              **
// **                         MARKO MAKELA (AUTHOR OF VARIOUS C64 DOCS)    **
// **                         PER HAKAN SUNDELL (AUTHOR OF CCS64)          **
// **                         MICHAEL SCHWENDT (AUTHOR OF SIDPLAY)         **
// **                         WOLFGANG LORENZ (AUTHOR OF PC64)             **
// **                         JOE FORSTER (STA, AUTHOR OF STAR COMMANDER)  **
// **                         PAUL TOTH (AUTHOR OF CBM64)                  **
// **                         DAAN VAN YPEREN (DYPER)                      ** 
// **                                                                      **
// ** WIN32 PORT            : MARTIN DUFOUR (VIP/DCB)                      **
// **                         WORK CONTINUED BY THE WIN32 PORT TEAM WITH   **
// **                         BETA 2                                       **
// **                                                                      **
// ** WINDOWS CE PORT       : DOMENICO DATO (DATO@DI.UNIPI.IT)             **
// **                                                                      **
// ** UNIX/X-WINDOWS PORT   : DOMENICO DATO (DATO@DI.UNIPI.IT)             **
// **                         (THANKS TO MARAT FAYZULLIN FOR HIS EMULIB)   **
// **                                                                      **
// **************************************************************************
// **  THE SOURCE AND BINARY OF COME BACK 64 ARE FREELY DISTRIBUTABLE, AS  **
// ** LONG AS THEY ARE KEPT INTACT AND ARE NOT CHANGED. THE LATEST VERSION **
// **         IS AVAILABLE FROM HTTP://WWW.CLASSICGAMING.COM/CB64          **
// **************************************************************************
// ** IF YOU MAKE A LINK TO THE COME BACK 64 PAGE ON YOUR WEB-SITE, OR IF  **
// ** YOU WANT TO MIRROR CB 64, YOU HEREBY HAVE MY PERMISSION, AS LONG AS  **
// **          YOU INFORM ME ABOUT THE URL WHERE THE LINKS IS ON.          **
// **************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cb64.h"
#include "c64func.h"
#include "c64proc.h"
#include "tables.h"

void putcbmchar( int letter,int xp,int yp,int fore,int back)
{
  int x,y;

	int place = xp*8+320*yp*8;
	
	for (y=0;y<8;y++)
	{
		int o=CharPointer[letter*8+y]; 
		
		int pos=128;
		
		for (x=0;x<8;x++)
		{
			
			int col=back;
			
			if (o>=pos)
			{
				o=o-pos;
				col=fore;
			}
			
			Virtualscreen[x+320*y+place]=col;
			
			pos=pos/2;
		}
	}
}

void putcbmstr(char * string,int xp, int yp, int fore, int back)
{
	int x;
	
	while ( (x = *string++ ) != '\0' )
	{
		putcbmchar( x & 63, xp++, yp, fore, back );
	}
}

void showpercent( int percent, int skipper )
{
	char str[64];

	sprintf( str, "S:%02d - %s%04d%%", 
		skipper, 
		RAMPointer[678]==0?"NTSC ":" PAL ", 
		percent 
	);
	
	putcbmstr( str, 23, 24, 1, 0 );
}

void showpos (WORD curr_loc, BYTE a_reg, BYTE x_reg, BYTE y_reg, BYTE flags, BYTE stack_ptr)
{
	BYTE x; 
	BYTE hex[17],pos,d; 

	char * opcodestring;

	char str[64];
	
	BYTE afound=0,bfound=0;
	
	for (x=0;x<10;x++) {hex[x]='0'+x;} for (x=0;x<6;x++) {hex[10+x]=1+x;}

	sprintf( str, "$%04X: ", curr_loc );
	putcbmstr( str, 0, 0, 1, 0 );

	putcbmchar ('$',7,0,1,0);
	
	x=Peek(curr_loc); putcbmchar (hex[x/16],8,0,1,0);putcbmchar (hex[x%16],9,0,1,0);
	
	for (x=10;x<18;x++) {putcbmchar(32,x,0,7,0);} pos=x;
	
	putcbmchar (':',pos++,0,7,0);putcbmchar (32,pos++,0,7,0);
	
	opcodestring = opcodes[Peek(curr_loc)];
	
	for (x=0;x<strlen(opcodestring);x++)
	{
		
		d=opcodestring[x];
		
		if (d>63&&d<91) 
			d-=64;
		
		if (d!='a'&&d!='b') 
			putcbmchar (d,pos,0,1,0);
		else
		{
			if (d=='a') { d=Peek(curr_loc+1); putcbmchar (hex[d/16],pos,0,1,0); pos++;putcbmchar (hex[d%16],pos,0,1,0);
			
			putcbmchar ('$',11,0,1,0);putcbmchar (hex[d/16],12,0,1,0);putcbmchar (hex[d%16],13,0,1,0);afound=1;}
			
			if (d=='b') { d=Peek(curr_loc+2); putcbmchar (hex[d/16],pos,0,1,0); pos++;putcbmchar (hex[d%16],pos,0,1,0);
			
			putcbmchar ('$',15,0,1,0);putcbmchar (hex[d/16],16,0,1,0);putcbmchar (hex[d%16],17,0,1,0);bfound=1;}
		}
		
		pos++;
	}
	
	for (x=pos;x<32;x++) {putcbmchar(32,x,0,1,0);}

	putcbmstr( "NV-BDIZC", 32, 0, 7, 0 );
	
	putcbmchar ((flags&128)/128+'0',32,1,1,0);
	putcbmchar ((flags&64)/64+'0',33,1,1,0);
	putcbmchar ((flags&32)/32+'0',34,1,1,0);
	putcbmchar ((flags&16)/16+'0',35,1,1,0);
	putcbmchar ((flags&8)/8+'0',36,1,1,0);
	putcbmchar ((flags&4)/4+'0',37,1,1,0);
	putcbmchar ((flags&2)/2+'0',38,1,1,0);
	putcbmchar ((flags&1)/1+'0',39,1,1,0);

	sprintf( str, "STACKP: $%04X A:$%02X X:$%02X Y:$%02X ", stack_ptr, a_reg, x_reg, y_reg );
	putcbmstr( str, 0, 1, 7, 0 );

	if (afound==0) 
		putcbmstr( "$..", 11, 0, 1, 0 );
	
	if (bfound==0) 
		putcbmstr( "$..", 15, 0, 1, 0 );
}

void showraster( int raster )
{
	putcbmchar ((raster % 10)+'0',39,24,1,0);
	raster/=10;
	putcbmchar ((raster % 10)+'0',38,24,1,0);
	raster/=10;
	putcbmchar (raster +'0',37,24,1,0);
}

void loadprg( char * filename )
{
  WORD loadat;


	FILE * infile = fopen( filename, "rb" );

	
	if ( infile != NULL )
	{
		if ( filename[strlen(filename)-1] == '0' )
			fseek( infile, 0x1a, SEEK_SET );
		
		loadat = fgetc( infile );
		loadat += ( (WORD) fgetc(infile) ) << 8;
		
		do 
		{
			RAMPointer[ loadat++ ] = fgetc( infile );
		} while ( !feof(infile) );
		
		RAMPointer[0x2e]=RAMPointer[0x30]=RAMPointer[0x32]=(BYTE)((loadat-1)>>8);
		RAMPointer[0x2d]=loadat++-1; 
		RAMPointer[0x2f]=loadat++-1; 
		RAMPointer[0x31]=loadat++-1;
		RAMPointer[0x277]='R';
		RAMPointer[0x278]='U';
		RAMPointer[0x279]='N';
		RAMPointer[0x27a]=13;
		RAMPointer[0xc6]=4;
		
		fclose( infile );
	}
}

void loadcrt( char * filename )
{
        WORD cont;
	BYTE l_CartHeader[64];
	BYTE l_CartChip[16];
	char * buffer = NULL;
	FILE * infile;

        infile = fopen( filename, "rb" );
 

	if ( infile != NULL )
	{
		fread( l_CartHeader, 64, 1, infile );

		cart.hardtype=l_CartHeader[21];

		if (cart.hardtype!=4 && cart.hardtype!=0)
		{
			fclose( infile );
			return;
		}

		fread( l_CartChip, 16, 1, infile );

		cart.address=(l_CartChip[0x0C]<<8)+l_CartChip[0x0D];
		cart.length=(l_CartChip[0x0E]<<8)+l_CartChip[0x0F];
		cart.bank=l_CartChip[0x0B];

                buffer = malloc (sizeof(char)*cart.length);

		fread( buffer, cart.length, 1, infile );

		for (cont=0;cont<cart.length;cont++)
			RAMPointer[cart.address+cont]=buffer[cont];
	}

        free(buffer);

	fclose( infile );
}

void TRACE( char * str )
{
	FILE * l_pFile = fopen( "trace.txt", "a" );

	fprintf( l_pFile,  str );

	fclose( l_pFile );
}
