// **************************************************************************
// **           COME BACK 64 - A FREEWARE COMMODORE 64 EMULATOR            **
// **          WWW.COMEBACK.C64.ORG             JHF@FAIRLIGHT.TO           **
// **************************************************************************
// **                 THIS IS VERSION ALPHA 1 FOR UNIX                     ** 
// **************************************************************************
// ** MAIN PROGRAMMERS      : JOHAN FITIE AND BRAD MARTIN                  **
// ** ROUTINE CONTRIBUTORS  : STEVEN H. DON - SOME SOUND FIXES             **
// **                         MASSIMILIANO AGOSTINELLI - CARTRIDGE LOADER  **
// ** SUPPORT               : PONTUS BERG (BACCHUS/FAIRLIGHT)              **
// **                         MARKO MAKELA (AUTHOR OF VARIOUS C64 DOCS)    **
// **                         PER HAKAN SUNDELL (AUTHOR OF CCS64)          **
// **                         MICHAEL SCHWENDT (AUTHOR OF SIDPLAY)         **
// **                         WOLFGANG LORENZ (AUTHOR OF PC64)             **
// **                         JOE FORSTER (STA, AUTHOR OF STAR COMMANDER)  **
// **                         PAUL TOTH (AUTHOR OF CBM64)                  **
// **                         DAAN VAN YPEREN (DYPER)                      ** 
// **                                                                      **
// ** WIN32 PORT            : MARTIN DUFOUR (VIP/DCB)                      **
// **                         WORK CONTINUED BY THE WIN32 PORT TEAM WITH   **
// **                         BETA 2                                       **
// **                                                                      **
// ** WINDOWS CE PORT       : DOMENICO DATO (DATO@DI.UNIPI.IT)             **
// **                                                                      **
// ** UNIX/X-WINDOWS PORT   : DOMENICO DATO (DATO@DI.UNIPI.IT)             **
// **                         (THANKS TO MARAT FAYZULLIN FOR HIS EMULIB)   **
// **                                                                      **
// **************************************************************************
// **  THE SOURCE AND BINARY OF COME BACK 64 ARE FREELY DISTRIBUTABLE, AS  **
// ** LONG AS THEY ARE KEPT INTACT AND ARE NOT CHANGED. THE LATEST VERSION **
// **         IS AVAILABLE FROM HTTP://WWW.CLASSICGAMING.COM/CB64          **
// **************************************************************************
// ** IF YOU MAKE A LINK TO THE COME BACK 64 PAGE ON YOUR WEB-SITE, OR IF  **
// ** YOU WANT TO MIRROR CB 64, YOU HEREBY HAVE MY PERMISSION, AS LONG AS  **
// **          YOU INFORM ME ABOUT THE URL WHERE THE LINKS IS ON.          **
// **************************************************************************

typedef unsigned char byte;
typedef unsigned short word;

typedef unsigned long ULONG;
typedef ULONG *PULONG;
typedef unsigned short USHORT;
typedef USHORT *PUSHORT;
typedef unsigned char UCHAR;
typedef UCHAR *PUCHAR;
typedef char *PSZ;


typedef unsigned long       DWORD;
typedef int                 BOOL;
typedef unsigned char       BYTE;
typedef unsigned short      WORD;
typedef float               FLOAT;
typedef FLOAT               *PFLOAT;
typedef BOOL            *PBOOL;
typedef BOOL             *LPBOOL;
typedef BYTE            *PBYTE;
typedef BYTE             *LPBYTE;
typedef int             *PINT;
typedef int              *LPINT;
typedef WORD            *PWORD;
typedef WORD             *LPWORD;
typedef long             *LPLONG;
typedef DWORD           *PDWORD;
typedef DWORD            *LPDWORD;
typedef void             *LPVOID;
typedef const void       *LPCVOID;

typedef int                 INT;
typedef unsigned int        UINT;
typedef unsigned int        *PUINT;

#define VERMAJ 0
#define VERMIN 0
#define VERMINTWO 1

#define DEFAULTEMULATEDJOYSTICK 1
#define DEFAULTGAMMA 1.0
#define DEFAULTSKIPRATE 1
#define DEFAULTGRAYSCALEON 0
#define DEFAULTILLEGALOPCODE 0

#define ATNOR 1
#define CLKOR 2
#define INITOR 4
#define DATAOR 8
#define ATNAND 254
#define CLKAND 253
#define INITAND 251
#define DATAAND 247

typedef union
{
        struct { BYTE l,h; } B;
        WORD W;
} CB64_pair;

typedef struct 
{
        BYTE C64CART[16];
        DWORD headerlen;
        WORD version;
        WORD hardtype;
        BYTE exromline;
        BYTE gameline;
        BYTE dummy[6];
        BYTE name[20];
        BYTE chip[4];
        DWORD packlen;
        WORD chiptype;
        WORD bank;
        WORD address;
        WORD length;
} CARTRIDGE;

extern BOOL g_fPAL;

extern BYTE *BasicPointer;
extern BYTE *KernalPointer;
extern BYTE *RAMPointer;
extern BYTE *CharPointer;
extern BYTE *ColorPointer;
extern BYTE *Virtualscreen; 

extern int done,reset,percent,skipper;
extern int cycles,cyc_orig,cyc_last;
extern char illopc;
extern char NMI,IRQ;

extern BYTE SIDRegs[0x1D];

extern int Cartflg;
extern CARTRIDGE cart;

// ---------------------------------------------------------------------------
// Functions

extern void CB64_ClearMem();
extern BYTE Peek(WORD address);
extern WORD Deek(WORD address);
extern void Poke(WORD address, BYTE value);

