/*
 *  Author     : Arne Vajhj
 *
 *  Programmed : march 1999
 *
 *  Modified   :
 *
 *  Purpose    : very simple implementation of foreign mail protocol
 *               to allow for sending SMTP email with own RFC 822 headers
 *
 *  Usage      : build with @BUILD, edit SETUP.COM, @SETUP,
 *               send email to NBL%"user@host.domain"
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <descrip.h>
#include <ssdef.h>
#include <rms.h>
#include <starlet.h>
#include <socket.h>
#include <netdb.h>
#include <in.h>
#include <unixio.h>

#pragma __nostandard
globalvalue mail$c_prot_major = 2;
globalvalue mail$c_prot_minor = 1;
#pragma __standard

/* #define DEBUG */
/* #define TCPDEBUG */

char hostname[65];
int tcp_socket;
void tcp_open(char *host,int port);
void tcp_write(char *fmt,...);
void tcp_read(char *buf,int buflen,int *retlen);
void tcp_close();

char *strip(char *s);

long int mail$protocol(long int *cntx,long int func)
{
   char *node,*from,*addr,*to,*cc,*subj,*stat;
   struct dsc$descriptor_s *nodedesc,*fromdesc,*addrdesc,
                           *todesc,*ccdesc,*subjdesc,*statdesc;
   char resp[1025];
   int resplen;
   char dstr[65];
   time_t t;
   char rec[1025];
   struct RAB *rabptr;
   long int retcode = SS$_NORMAL;
   va_list argptr;
   va_start(argptr,func);
   switch (func) {
     case 0:
        /* ignore all the extra information provided */
#ifdef DEBUG
        printf("start\n");
#endif
        /* TCP stuff */
        gethostname(hostname,sizeof(hostname));
        tcp_open(getenv("NBL_MAILHOST"),25);
        tcp_read(resp,sizeof(resp)-1,&resplen);
        resp[resplen] = '\0';
#ifdef TCPDEBUG
        printf("TCP resp: %s",resp);
#endif
        tcp_write("HELO %s\r\n",hostname);
        tcp_read(resp,sizeof(resp)-1,&resplen);
        resp[resplen] = '\0';
#ifdef TCPDEBUG
        printf("TCP resp: %s",resp);
#endif
        break;
     case 1:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get from */
        fromdesc = va_arg(argptr,struct dsc$descriptor_s *);
        from = malloc(fromdesc->dsc$w_length);
        memcpy(from,fromdesc->dsc$a_pointer,fromdesc->dsc$w_length);
        from[fromdesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("from=%s\n",from);
#endif
        /* TCP stuff */
        tcp_write("MAIL FROM: <%s@%s>\r\n",from,hostname);
        tcp_read(resp,sizeof(resp)-1,&resplen);
        resp[resplen] = '\0';
#ifdef TCPDEBUG
        printf("TCP resp: %s",resp);
#endif
        break;
     case 2:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get check address */
        addrdesc = va_arg(argptr,struct dsc$descriptor_s *);
        addr = malloc(addrdesc->dsc$w_length);
        memcpy(addr,addrdesc->dsc$a_pointer,addrdesc->dsc$w_length);
        addr[addrdesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("check address=%s\n",addr);
#endif
        /* change retcode if the address is not valid  */
        /* and remember there is an empty address last */
        /* TCP stuff */
        if(strlen(addr)>0) {  
           tcp_write("RCPT TO: <%s>\r\n",addr);
           tcp_read(resp,sizeof(resp)-1,&resplen);
           resp[resplen] = '\0';
#ifdef TCPDEBUG
           printf("TCP resp: %s",resp);
#endif
        } else {
           tcp_write("DATA\r\n");
           tcp_read(resp,sizeof(resp)-1,&resplen);
           resp[resplen] = '\0';
#ifdef TCPDEBUG
           printf("TCP resp: %s",resp);
#endif
        }
        break;
     case 3:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get to */
        todesc = va_arg(argptr,struct dsc$descriptor_s *);
        to = malloc(todesc->dsc$w_length);
        memcpy(to,todesc->dsc$a_pointer,todesc->dsc$w_length);
        to[todesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("to=%s\n",to);
#endif
        /* TCP stuff */
        tcp_write("To: %s\r\n",strip(to));
        break;
     case 4:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get subject */
        subjdesc = va_arg(argptr,struct dsc$descriptor_s *);
        subj = malloc(subjdesc->dsc$w_length);
        memcpy(subj,subjdesc->dsc$a_pointer,subjdesc->dsc$w_length);
        subj[subjdesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("subj=%s\n",subj);
#endif
        /* TCP stuff */
        tcp_write("Subject: %s\r\n",subj);
        break;
     case 5:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get RAB */
        rabptr = va_arg(argptr,struct RAB *);
#ifdef DEBUG
        printf("RAB\n",node);
#endif
        /* TCP stuff */
        t = time(NULL);
        strftime(dstr,sizeof(dstr),"%a, %d %b %Y %H:%M:%S GMT",localtime(&t));
        tcp_write("Date: %s\r\n",dstr);
        if(!getenv("NBL_ACTIVE")) tcp_write("\r\n");
        rabptr->rab$l_ubf = rec;
        rabptr->rab$w_usz = sizeof(rec)-1;
        while((sys$get(rabptr,0,0)&1)==1) {
           rec[rabptr->rab$w_rsz] = '\0';
#ifdef DEBUG
           printf("REC: %s\n",rec);
#endif
           tcp_write("%s\r\n",rec);
        }
        break;
     case 6:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get check status */
        statdesc = va_arg(argptr,struct dsc$descriptor_s *);
        stat = malloc(statdesc->dsc$w_length);
        memcpy(stat,statdesc->dsc$a_pointer,statdesc->dsc$w_length);
        stat[statdesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("check status=%s\n",stat);
#endif
        /* we always assume status is OK */
        break;
     case 7:
        /* done */
#ifdef DEBUG
        printf("done\n");
#endif
        /* TCP stuff */
        tcp_write(".\r\n");
        tcp_write("QUIT\r\n");
        tcp_read(resp,sizeof(resp)-1,&resplen);
        resp[resplen] = '\0';
#ifdef TCPDEBUG
        printf("TCP resp: %s",resp);
#endif
        tcp_close();
        break;
     case 17:
        /* get node */
        nodedesc = va_arg(argptr,struct dsc$descriptor_s *);
        node = malloc(nodedesc->dsc$w_length);
        memcpy(node,nodedesc->dsc$a_pointer,nodedesc->dsc$w_length);
        node[nodedesc->dsc$w_length] = '\0';
        /* get cc */
        ccdesc = va_arg(argptr,struct dsc$descriptor_s *);
        cc = malloc(ccdesc->dsc$w_length);
        memcpy(cc,ccdesc->dsc$a_pointer,ccdesc->dsc$w_length);
        cc[ccdesc->dsc$w_length] = '\0';
#ifdef DEBUG
        printf("cc=%s\n",cc);
#endif
        /* TCP stuff */
        tcp_write("Cc: %s\r\n",strip(cc));
        break;
     case 19:
        /* ignore attributes entirely */
        break;
     default:
        printf("unimplemented function %d\n",func);
        break;
   }
   va_end(argptr);
   return retcode;
}

void tcp_open(char *host,int port)
{
   struct sockaddr_in local,remote;
   struct hostent *hostinfo;
   tcp_socket = socket(AF_INET,SOCK_STREAM,0);
   local.sin_family = AF_INET;
   local.sin_port = 0;
   local.sin_addr.s_addr = 0;
   bind(tcp_socket,(struct sockaddr *)&local,sizeof(local));
   hostinfo = (struct hostent *)gethostbyname(host);
   remote.sin_family = hostinfo->h_addrtype;
   remote.sin_port = htons(port);
   remote.sin_addr.s_addr = *((long int*)hostinfo->h_addr);
   connect(tcp_socket,(struct sockaddr *)&remote,sizeof(remote));
   return;
}

void tcp_write(char *fmt,...)
{
   char line[1025];
   va_list argptr;
   va_start(argptr,fmt);
   vsprintf(line,fmt,argptr);
   send(tcp_socket,line,strlen(line),0);
   va_end(argptr);
   return;
}

void tcp_read(char *buf,int buflen,int *retlen)
{
   (*retlen) = recv(tcp_socket,buf,buflen,0);
   return;
}

void tcp_close()
{
   close(tcp_socket);
   return;
}

char *strip(char *s)
{
   int i;
   char *p,*p2;
   char *s2 = malloc(strlen(s)+1);
   p = s;
   p2 = s2;
   while(*p) {
      if(memcmp(p,"NBL%",4)==0) {
         p = p + 4;
      } else if(*p=='"') {
         p++;
      } else {
         *p2 = *p;
         p++;
         p2++;
      }
   }
   *p2 = '\0';
   return s2;
}

