G  Syntax12.Scn.Fnt  s  ParcElems Alloc    	
#.9      ;          Syntax12b.Scn.Fnt          	    	       9        0    8  FoldElems New C   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt              workspace layout  ?   Courier10.Scn.Fnt     8     Syntax12i.Scn.Fnt  "        	        E    g    '    g            0            Y            8  C   Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  (        *    dummy register usage - !!do not delete!!  _   8   x   8       8          >       Z        a    5               w%  
MODULE Coroutines;
(* AOS_64/Oberon-2 OpenVMS AlphaAxp version.

    Copyright (1997) Guenter Dotzel, ModulaWare, F-04340 Meolans-Revel
	email: 100023.2527@compuserve.com
    http://ourworld.compuserve.com/homepages/modulaware/

    PP/Aug-97 AOS_64/Oberon-2 OpenVMS AlphaAxp version.

 * This module must be compiled with /NOStackcheck otherwise Trap leads to recursive traps
 *
 * todo:	FindAmbRoots does not run properly under OpenVMS 6.2 (due to an error in 6.2)
 *			Coroutines with stacks in VMS.P2 space do not work (restriction of OpenVMS 7.1!)
 * 
 * Test with:
 *	TestCoro.Test~		TestCoro.Do~	SortBasics.Open~	CoTest.Do~
 *)

IMPORT SYSTEM, Kernel, Dbg := DebugOutput, EX:=VMS$Exceptions, lib := LIB$, Sys, Modules;

CONST
	OBERONHEAP = 0;
	VMSP1 = 1;
	VMSP2 = 2;
	COROSTACK = VMSP1;			(* determines where the coroutine stacks are allocated *)

TYPE
	WORKSPACESTACKPTR = POINTER TO ARRAY OF SYSTEM.BYTE;
	PROC* = PROCEDURE;
	PROCESS* = POINTER TO WorkspaceDesc;
	WorkspaceDesc = RECORD
		stack			:WORKSPACESTACKPTR;	(* only needed when COROSTACK = OBERONHEAP *)
		p                	:PROC;
		RV-,										(* is only exported for test & debug reason *)
		FP,
		SP,
		next		     :LONGINT
	END;

CONST
	QUADWORD = 8;
	VMSRESERVED* = 16000; (* 3072 Byte = AST + local space for value parameter copy
													+ reserve for oberontraphandler when stackoverflow *)
	DISPLAYSPACE = 15 * 8;
	DUMMIES = 5 * 8;
	RV = 12;
	RL = 15;
	FP = 29;
	SP = 30;
	ALIGN = 16;							(* alignment of the stack *)

VAR
	rvadr		:LONGINT;			(* address of the DDSpaceaddr of the current coroutine *)
	proc			:PROC;
	current,
	mainstack	:PROCESS;
	oldTrap		:EX.ExceptionHandler;

PROCEDURE Trap(VAR sigArgs: EX.SigArgs; mechArgs: EX.MechArgs):SYSTEM.SIGNED_32;
BEGIN
	current := mainstack; SYSTEM.PUT(rvadr, current.RV);
	(* the transfer to the mainstack becomes true when resuming the oberon.loop;
	 * !! but the traphandling mechanism still uses the actual workspace !!
	 *) 
	IF oldTrap # NIL THEN SYSTEM.GETREG(17, mechArgs); RETURN oldTrap(sigArgs, mechArgs) END;
	RETURN EX.SS$_RESIGNAL
END Trap;

PROCEDURE Count*():LONGINT;		(* debug *)
VAR	i		:LONGINT;
		act	:PROCESS;
BEGIN
	act := mainstack; i := 0;
	WHILE act # NIL DO INC(i); act := SYSTEM.VAL(PROCESS, act.next) END;
	RETURN i
END Count;

(*
 * cmp. Unix; code is duplicated for testing stacks in P2 Address space
 * not needed for WSPSTACK = OBERONHEAP
 *)
 
PROCEDURE Malloc (size: LONGINT): LONGINT;
VAR	result, lomem	:SYSTEM.SIGNED_32;
		total, mem		:SYSTEM.SIGNED_64;
BEGIN
	total := size + QUADWORD;
	IF COROSTACK = VMSP1 THEN
		result := lib.LIB$GET_VM(SYSTEM.SHORT(total), lomem); mem := lomem
	ELSE result := lib.LIB$GET_VM_64(total, SYSTEM.VAL(SYSTEM.SIGNED_64, mem))
	END;
	
	IF ~ ODD(result) THEN lib.LIB$SIGNAL(result); RETURN 0 END;
	SYSTEM.PUT (mem, total);
	RETURN mem + QUADWORD;
END Malloc;

PROCEDURE Free (VAR mem: LONGINT);
VAR	size		:SYSTEM.SIGNED_64;
		result	:SYSTEM.SIGNED_32;
BEGIN
	DEC(mem, QUADWORD); SYSTEM.GET(mem, size);
	IF COROSTACK = VMSP1 THEN
		result := lib.LIB$FREE_VM(SYSTEM.SHORT(size), SYSTEM.VAL(SYSTEM.SIGNED_32, mem))
	ELSE result := lib.LIB$FREE_VM_64(size, SYSTEM.VAL(SYSTEM.SIGNED_64, mem))
	END;
	
	IF ~ODD(result) THEN lib.LIB$SIGNAL(result) END;
	mem := 0;
END Free;

PROCEDURE Current*():PROCESS;
BEGIN RETURN current
END Current;

PROCEDURE NEWPROCESS*(p:PROC; stacklen:LONGINT; VAR new:PROCESS);
(* 
	The allocated workspace for the new process looks like this:
	+------------+ <- RV + 24   ;upper end
	| stacklimit |              ;points to NEWPROCESS.adr + VMSRESERVED
	|            |               (!! does not consider alignment !!)
	+------------+ <- RV + 16
	|    dummy   |              ;this field is used by
	|            |               Modula2.Transfer (size = 2 * 8)
	+------------+ <- new.RV / RV when running on this workspace	
	|  DISPLAY   |              ;size = 15 * 8
	|   SPACE    |
	+------------+
	|   DUMMIES  |              ;size = 5 * 8, is needed by Modula2.Coroutines
	+------------+ <- SP before calling the PROCEDURE p
	|   STACK    |              ;size = user defined
	+------------+
	|  reserved  |              ;size = VMSRESERVED
	+------------+ <----- aligned to 16 byte boundary
	|  alignment |
	+------------+ <- NEWPROCESS.adr
	|struct.size | new.adr - 8  ;additionally allocated by Malloc to
	|            |               store the structure size
	+------------+
 *)
VAR adr :LONGINT;
BEGIN
	NEW (new);
	stacklen := stacklen + VMSRESERVED + ALIGN;

	IF COROSTACK # OBERONHEAP THEN adr := Malloc(stacklen + DUMMIES + DISPLAYSPACE + 24)
	ELSE
		SYSTEM.NEW (new.stack, stacklen + DUMMIES + DISPLAYSPACE + 24);
		adr := SYSTEM.VAL (LONGINT, new.stack)
	END;

	ASSERT (adr # 0);
	new.RV := ((adr + stacklen) DIV ALIGN) * ALIGN + DUMMIES + DISPLAYSPACE;
	SYSTEM.PUT (new.RV + 16, adr + VMSRESERVED);
	new.p := p; new.FP := 0;
	new.SP := new.RV - (DUMMIES + DISPLAYSPACE);
	ASSERT ((new.SP MOD ALIGN) = 0);		(* assure that SP is aligned smoothly *)
	
	IF COROSTACK # OBERONHEAP THEN
		new.next := mainstack.next;
		mainstack.next := SYSTEM.VAL(LONGINT, new)
	END
END NEWPROCESS;

PROCEDURE TRANSFER* (to:PROCESS);
BEGIN
	ASSERT ((to # NIL) & (to # current));
(* Dbg.HSH (0, to.FP, " <- FP   (TRANSFER)   SP -> ", to.SP); *)
	
	SYSTEM.GETREG(FP, current.FP); SYSTEM.GETREG(SP, current.SP);
	current := to;
	SYSTEM.PUT (rvadr, to.RV);	(* only needed if the using modules are compiled with the foreign option *)
	IF to.FP # 0 THEN SYSTEM.PUTREG (FP, to.FP)
	ELSE
		IF COROSTACK # OBERONHEAP THEN to.FP := 1  (* dummy value # 0; needed in FindAmbRoots *)
		ELSE to.next := mainstack.next; mainstack.next := SYSTEM.VAL(LONGINT, to)
		END;

		proc := to.p;							(* copy into global variable, needed when FP = SP *)			
		SYSTEM.PUTREG (RV, to.RV);
		SYSTEM.PUTREG (SP, to.SP);
		proc;
		HALT(100);							(* coroutines never return *)
		
(****
 * the use of preserved registers forces the compiler to generate code for saving them on procedure entry
 ****)
		SYSTEM.PUTREG(2, 0); SYSTEM.PUTREG(3, 0); SYSTEM.PUTREG(4, 0); SYSTEM.PUTREG(5, 0);
		SYSTEM.PUTREG(6, 0); SYSTEM.PUTREG(7, 0); SYSTEM.PUTREG(8, 0); SYSTEM.PUTREG(9, 0);
		SYSTEM.PUTREG(10, 0); SYSTEM.PUTREG(11, 0); SYSTEM.PUTREG(12, 0); SYSTEM.PUTREG(13, 0);
		SYSTEM.PUTREG(14, 0); SYSTEM.PUTREG(15, 0);
			
		SYSTEM.PUTREG(2, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(3, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(4, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(5, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(6, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(7, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(8, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
		SYSTEM.PUTREG(9, SYSTEM.VAL(SYSTEM.T_FLOATING, 0));
	END;
END TRANSFER;

PROCEDURE *Cleanup;
VAR	act,
		prev	:PROCESS;
		adr	:LONGINT; 
BEGIN
	prev := mainstack;
	WHILE prev.next # 0 DO
		act := SYSTEM.VAL (PROCESS, prev.next);
		IF ~SYSTEM.BIT (SYSTEM.VAL(LONGINT, act)-8, Kernel.MarkBit) THEN		(* unmarked *)
			IF COROSTACK # OBERONHEAP THEN
				SYSTEM.GET (act.RV + 16, adr);
				DEC (adr, VMSRESERVED);
(*			Dbg.HSH (0, adr, " <-- Adr   Block --> ", SYSTEM.VAL(LONGINT, act));  *)
				Free (adr);
			END;
			prev.next := act.next
		ELSE
			prev := act
		END
	END;
END Cleanup;

PROCEDURE FindAmbRoots;		(* !?! does not run properly under VMS 6.2 !?! *)
VAR	act				:PROCESS;
		endOfStack,
		sp, fp, p		:LONGINT;
		ok				:BOOLEAN;
		ctx				:EX.InvoContext;
		handle			:EX.InvoHandle;
BEGIN
	act := mainstack;
	REPEAT
		IF act = current THEN EX.LIB$GET_CURRENT_INVO_CONTEXT(ctx)
		ELSE ctx.iReg[FP] := act.FP; ctx.iReg[SP] := act.SP; (* 
			(* although slower this additional code seems to be cleaner but does not work :-( *)
			handle := EX.LIB$GET_INVO_HANDLE(ctx);
			ok := EX.LIB$GET_INVO_CONTEXT(handle, ctx);
			ASSERT(ok); *)		
		END;
		
		endOfStack := act.RV - (DUMMIES + DISPLAYSPACE);
(*	Dbg.HSH(0, endOfStack, " <-- EndOfStack  (GC)  SP --> ", ctx.iReg[SP]); *)
		LOOP
			p := EX.LIB$GET_PREV_INVO_CONTEXT(ctx);
 			ok := (p = 1) & (ctx.procDesc # Modules.bodysProcDesc) & (ctx.iReg[SP] < endOfStack);
(*		Dbg.HSH (0, ctx.iReg[SP], " <= sp        ok => ", ORD(ok)); *)

			IF ~ok THEN EXIT END;
			IF ~(EX.LIBICB$V_EXCEPTION_FRAME IN ctx.flags) THEN
				fp := ctx.iReg[FP]; sp := ctx.iReg[SP];
				WHILE sp < fp DO
					SYSTEM.GET(sp, p); Kernel.Candidate(p); INC(sp, SIZE(LONGINT))
				END
			END
		END;
		IF COROSTACK = OBERONHEAP THEN act := SYSTEM.VAL(PROCESS, act.next)
		ELSE REPEAT act := SYSTEM.VAL(PROCESS, act.next) UNTIL (act = NIL) OR (act.FP # 0)
		END;
	UNTIL act = NIL;
END FindAmbRoots;

PROCEDURE Reset*;
BEGIN
	ASSERT(current = mainstack);
(* Kernel.GCenabled:=TRUE *)
END Reset;

PROCEDURE DeInst*;
VAR cv :LONGINT;
BEGIN
	Kernel.GC (TRUE);
	ASSERT ((current = mainstack) & (Count() = 1)); (* to be absolutly sure, that there remains no coroutine *)
	Sys.ReinstallExceptionHandler (oldTrap);
	Kernel.FindAmbRoots.Remove (FindAmbRoots);
	Kernel.FindAmbRoots.Add (Modules.FindAmbRoots);
	Kernel.RemoveSweep (Cleanup)
END DeInst;

PROCEDURE Init;
VAR cv :LONGINT;
BEGIN
	ASSERT ((COROSTACK # VMSP2) OR (SIZE(LONGINT) = SIZE(SYSTEM.SIGNED_64)));
	SYSTEM.GETREG(RL, rvadr); SYSTEM.GET(rvadr + 16, rvadr);
	NEW(mainstack); SYSTEM.GET(rvadr, mainstack.RV);
	mainstack.next := SYSTEM.VAL(LONGINT, NIL); current := mainstack;
	
	SYSTEM.GET(mainstack.RV+16, cv); ASSERT(cv = 0);
	Kernel.InstallSweep (Cleanup);
	Kernel.FindAmbRoots.Remove (Modules.FindAmbRoots);
	Kernel.FindAmbRoots.Add (FindAmbRoots);
	oldTrap := Sys.InstallExceptionHandler(Trap);
END Init;

BEGIN Init
END Coroutines.