/* $Id: GFUtil.java,v 1.2 1999/03/20 13:36:09 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */

package cryptix.ecc;

import java.math.BigInteger;
import java.io.*;

/**
 * Irreducible polynomials for GF(2<SUP>m</SUP>) functionality
 *
 * @author  Paulo S. L. M. Barreto <pbarreto@cryptix.org>
 */
class GFUtil {

    private static boolean use1363 = true;

    private static final short[][] irred1363 = {
        /*   0*/ null,
        /*   1*/ null,
        /*   2*/ {1},
        /*   3*/ {1},
        /*   4*/ {1},
        /*   5*/ {2},
        /*   6*/ {1},
        /*   7*/ {1},
        /*   8*/ {1, 3, 4},
        /*   9*/ {1},
        /*  10*/ {3},
        /*  11*/ {2},
        /*  12*/ {3},
        /*  13*/ {1, 3, 4},
        /*  14*/ {5},
        /*  15*/ {1},
        /*  16*/ {1, 3, 5},
        /*  17*/ {3},
        /*  18*/ {3},
        /*  19*/ {1, 2, 5},
        /*  20*/ {3},
        /*  21*/ {2},
        /*  22*/ {1},
        /*  23*/ {5},
        /*  24*/ {1, 3, 4},
        /*  25*/ {3},
        /*  26*/ {1, 3, 4},
        /*  27*/ {1, 2, 5},
        /*  28*/ {1},
        /*  29*/ {2},
        /*  30*/ {1},
        /*  31*/ {3},
        /*  32*/ {2, 3, 7},
        /*  33*/ {10},
        /*  34*/ {7},
        /*  35*/ {2},
        /*  36*/ {9},
        /*  37*/ {1, 4, 6},
        /*  38*/ {1, 5, 6},
        /*  39*/ {4},
        /*  40*/ {3, 4, 5},
        /*  41*/ {3},
        /*  42*/ {7},
        /*  43*/ {3, 4, 6},
        /*  44*/ {5},
        /*  45*/ {1, 3, 4},
        /*  46*/ {1},
        /*  47*/ {5},
        /*  48*/ {2, 3, 5},
        /*  49*/ {9},
        /*  50*/ {2, 3, 4},
        /*  51*/ {1, 3, 6},
        /*  52*/ {3},
        /*  53*/ {1, 2, 6},
        /*  54*/ {9},
        /*  55*/ {7},
        /*  56*/ {2, 4, 7},
        /*  57*/ {4},
        /*  58*/ {19},
        /*  59*/ {2, 4, 7},
        /*  60*/ {1},
        /*  61*/ {1, 2, 5},
        /*  62*/ {29},
        /*  63*/ {1},
        /*  64*/ {1, 3, 4},
        /*  65*/ {18},
        /*  66*/ {3},
        /*  67*/ {1, 2, 5},
        /*  68*/ {9},
        /*  69*/ {2, 5, 6},
        /*  70*/ {1, 3, 5},
        /*  71*/ {6},
        /*  72*/ {3, 9, 10},
        /*  73*/ {25},
        /*  74*/ {35},
        /*  75*/ {1, 3, 6},
        /*  76*/ {21},
        /*  77*/ {2, 5, 6},
        /*  78*/ {3, 5, 6},
        /*  79*/ {9},
        /*  80*/ {2, 4, 9},
        /*  81*/ {4},
        /*  82*/ {1, 3, 8},
        /*  83*/ {2, 4, 7},
        /*  84*/ {5},
        /*  85*/ {1, 2, 8},
        /*  86*/ {21},
        /*  87*/ {13},
        /*  88*/ {2, 6, 7},
        /*  89*/ {38},
        /*  90*/ {27},
        /*  91*/ {1, 5, 8},
        /*  92*/ {21},
        /*  93*/ {2},
        /*  94*/ {21},
        /*  95*/ {11},
        /*  96*/ {6, 9, 10},
        /*  97*/ {6},
        /*  98*/ {11},
        /*  99*/ {1, 3, 6},
        /* 100*/ {15},
        /* 101*/ {1, 6, 7},
        /* 102*/ {29},
        /* 103*/ {9},
        /* 104*/ {1, 3, 4},
        /* 105*/ {4},
        /* 106*/ {15},
        /* 107*/ {4, 7, 9},
        /* 108*/ {17},
        /* 109*/ {2, 4, 5},
        /* 110*/ {33},
        /* 111*/ {10},
        /* 112*/ {3, 4, 5},
        /* 113*/ {9},
        /* 114*/ {2, 3, 5},
        /* 115*/ {5, 7, 8},
        /* 116*/ {1, 2, 4},
        /* 117*/ {1, 2, 5},
        /* 118*/ {33},
        /* 119*/ {8},
        /* 120*/ {1, 3, 4},
        /* 121*/ {18},
        /* 122*/ {1, 2, 6},
        /* 123*/ {2},
        /* 124*/ {19},
        /* 125*/ {5, 6, 7},
        /* 126*/ {21},
        /* 127*/ {1},
        /* 128*/ {1, 2, 7},
        /* 129*/ {5},
        /* 130*/ {3},
        /* 131*/ {2, 3, 8},
        /* 132*/ {17},
        /* 133*/ {2, 8, 9},
        /* 134*/ {57},
        /* 135*/ {11},
        /* 136*/ {2, 3, 5},
        /* 137*/ {21},
        /* 138*/ {1, 7, 8},
        /* 139*/ {3, 5, 8},
        /* 140*/ {15},
        /* 141*/ {1, 4, 10},
        /* 142*/ {21},
        /* 143*/ {2, 3, 5},
        /* 144*/ {2, 4, 7},
        /* 145*/ {52},
        /* 146*/ {71},
        /* 147*/ {14},
        /* 148*/ {27},
        /* 149*/ {7, 9, 10},
        /* 150*/ {53},
        /* 151*/ {3},
        /* 152*/ {2, 3, 6},
        /* 153*/ {1},
        /* 154*/ {15},
        /* 155*/ {62},
        /* 156*/ {9},
        /* 157*/ {2, 5, 6},
        /* 158*/ {5, 6, 8},
        /* 159*/ {31},
        /* 160*/ {2, 3, 5},
        /* 161*/ {18},
        /* 162*/ {27},
        /* 163*/ {3, 6, 7},
        /* 164*/ {7, 8, 10},
        /* 165*/ {3, 8, 9},
        /* 166*/ {37},
        /* 167*/ {6},
        /* 168*/ {2, 3, 15},
        /* 169*/ {34},
        /* 170*/ {11},
        /* 171*/ {2, 5, 6},
        /* 172*/ {1},
        /* 173*/ {2, 5, 8},
        /* 174*/ {13},
        /* 175*/ {6},
        /* 176*/ {2, 3, 11},
        /* 177*/ {8},
        /* 178*/ {31},
        /* 179*/ {1, 2, 4},
        /* 180*/ {3},
        /* 181*/ {1, 6, 7},
        /* 182*/ {81},
        /* 183*/ {56},
        /* 184*/ {7, 8, 9},
        /* 185*/ {24},
        /* 186*/ {11},
        /* 187*/ {5, 6, 7},
        /* 188*/ {2, 5, 6},
        /* 189*/ {2, 5, 6},
        /* 190*/ {6, 7, 8},
        /* 191*/ {9},
        /* 192*/ {1, 2, 7},
        /* 193*/ {15},
        /* 194*/ {87},
        /* 195*/ {2, 3, 8},
        /* 196*/ {3},
        /* 197*/ {2, 4, 9},
        /* 198*/ {9},
        /* 199*/ {34},
        /* 200*/ {2, 3, 5},
        /* 201*/ {14},
        /* 202*/ {55},
        /* 203*/ {1, 7, 8},
        /* 204*/ {27},
        /* 205*/ {2, 5, 9},
        /* 206*/ {5, 9, 10},
        /* 207*/ {43},
        /* 208*/ {1, 3, 9},
        /* 209*/ {6},
        /* 210*/ {7},
        /* 211*/ {8, 10, 11},
        /* 212*/ {105},
        /* 213*/ {2, 5, 6},
        /* 214*/ {73},
        /* 215*/ {23},
        /* 216*/ {1, 3, 7},
        /* 217*/ {45},
        /* 218*/ {11},
        /* 219*/ {1, 4, 8},
        /* 220*/ {7},
        /* 221*/ {2, 6, 8},
        /* 222*/ {2, 4, 5},
        /* 223*/ {33},
        /* 224*/ {3, 8, 9},
        /* 225*/ {32},
        /* 226*/ {3, 7, 10},
        /* 227*/ {4, 9, 10},
        /* 228*/ {113},
        /* 229*/ {1, 4, 10},
        /* 230*/ {6, 7, 8},
        /* 231*/ {26},
        /* 232*/ {2, 4, 9},
        /* 233*/ {74},
        /* 234*/ {31},
        /* 235*/ {1, 6, 9},
        /* 236*/ {5},
        /* 237*/ {1, 4, 7},
        /* 238*/ {73},
        /* 239*/ {36},
        /* 240*/ {3, 5, 8},
        /* 241*/ {70},
        /* 242*/ {95},
        /* 243*/ {1, 5, 8},
        /* 244*/ {111},
        /* 245*/ {1, 4, 6},
        /* 246*/ {1, 2, 11},
        /* 247*/ {82},
        /* 248*/ {10, 14, 15},
        /* 249*/ {35},
        /* 250*/ {103},
        /* 251*/ {2, 4, 7},
        /* 252*/ {15},
        /* 253*/ {46},
        /* 254*/ {1, 2, 7},
        /* 255*/ {52},
        /* 256*/ {2, 5, 10},
        /* 257*/ {12},
        /* 258*/ {71},
        /* 259*/ {2, 6, 10},
        /* 260*/ {15},
        /* 261*/ {4, 6, 7},
        /* 262*/ {4, 8, 9},
        /* 263*/ {93},
        /* 264*/ {2, 6, 9},
        /* 265*/ {42},
        /* 266*/ {47},
        /* 267*/ {3, 6, 8},
        /* 268*/ {25},
        /* 269*/ {1, 6, 7},
        /* 270*/ {53},
        /* 271*/ {58},
        /* 272*/ {2, 3, 9},
        /* 273*/ {23},
        /* 274*/ {67},
        /* 275*/ {9, 10, 11},
        /* 276*/ {63},
        /* 277*/ {3, 6, 12},
        /* 278*/ {5},
        /* 279*/ {5},
        /* 280*/ {2, 5, 9},
        /* 281*/ {93},
        /* 282*/ {35},
        /* 283*/ {5, 7, 12},
        /* 284*/ {53},
        /* 285*/ {5, 7, 10},
        /* 286*/ {69},
        /* 287*/ {71},
        /* 288*/ {1, 10, 11},
        /* 289*/ {21},
        /* 290*/ {2, 3, 5},
        /* 291*/ {5, 11, 12},
        /* 292*/ {37},
        /* 293*/ {1, 6, 11},
        /* 294*/ {33},
        /* 295*/ {48},
        /* 296*/ {2, 3, 7},
        /* 297*/ {5},
        /* 298*/ {4, 8, 11},
        /* 299*/ {4, 6, 11},
        /* 300*/ {5},
        /* 301*/ {2, 5, 9},
        /* 302*/ {41},
        /* 303*/ {1},
        /* 304*/ {1, 2, 11},
        /* 305*/ {102},
        /* 306*/ {1, 3, 7},
        /* 307*/ {2, 4, 8},
        /* 308*/ {15},
        /* 309*/ {4, 6, 10},
        /* 310*/ {93},
        /* 311*/ {3, 5, 7},
        /* 312*/ {4, 7, 9},
        /* 313*/ {79},
        /* 314*/ {15},
        /* 315*/ {1, 9, 10},
        /* 316*/ {63},
        /* 317*/ {2, 4, 7},
        /* 318*/ {45},
        /* 319*/ {36},
        /* 320*/ {1, 3, 4},
        /* 321*/ {31},
        /* 322*/ {67},
        /* 323*/ {1, 3, 10},
        /* 324*/ {51},
        /* 325*/ {2, 5, 10},
        /* 326*/ {1, 3, 10},
        /* 327*/ {34},
        /* 328*/ {1, 3, 8},
        /* 329*/ {50},
        /* 330*/ {99},
        /* 331*/ {2, 6, 10},
        /* 332*/ {89},
        /* 333*/ {2},
        /* 334*/ {1, 2, 5},
        /* 335*/ {2, 7, 10},
        /* 336*/ {1, 4, 7},
        /* 337*/ {55},
        /* 338*/ {1, 3, 4},
        /* 339*/ {7, 10, 16},
        /* 340*/ {45},
        /* 341*/ {6, 8, 10},
        /* 342*/ {125},
        /* 343*/ {75},
        /* 344*/ {1, 2, 7},
        /* 345*/ {22},
        /* 346*/ {63},
        /* 347*/ {3, 10, 11},
        /* 348*/ {103},
        /* 349*/ {2, 5, 6},
        /* 350*/ {53},
        /* 351*/ {34},
        /* 352*/ {6, 11, 13},
        /* 353*/ {69},
        /* 354*/ {99},
        /* 355*/ {1, 5, 6},
        /* 356*/ {7, 9, 10},
        /* 357*/ {2, 10, 11},
        /* 358*/ {57},
        /* 359*/ {68},
        /* 360*/ {2, 3, 5},
        /* 361*/ {1, 4, 7},
        /* 362*/ {63},
        /* 363*/ {3, 5, 8},
        /* 364*/ {9},
        /* 365*/ {5, 6, 9},
        /* 366*/ {29},
        /* 367*/ {21},
        /* 368*/ {2, 3, 7},
        /* 369*/ {91},
        /* 370*/ {139},
        /* 371*/ {2, 3, 8},
        /* 372*/ {111},
        /* 373*/ {2, 7, 8},
        /* 374*/ {5, 6, 8},
        /* 375*/ {16},
        /* 376*/ {5, 7, 8},
        /* 377*/ {41},
        /* 378*/ {43},
        /* 379*/ {5, 8, 10},
        /* 380*/ {47},
        /* 381*/ {1, 2, 5},
        /* 382*/ {81},
        /* 383*/ {90},
        /* 384*/ {2, 3, 12},
        /* 385*/ {6},
        /* 386*/ {83},
        /* 387*/ {1, 7, 8},
        /* 388*/ {159},
        /* 389*/ {5, 9, 10},
        /* 390*/ {9},
        /* 391*/ {28},
        /* 392*/ {6, 10, 13},
        /* 393*/ {7},
        /* 394*/ {135},
        /* 395*/ {5, 6, 11},
        /* 396*/ {25},
        /* 397*/ {6, 7, 12},
        /* 398*/ {2, 6, 7},
        /* 399*/ {26},
        /* 400*/ {2, 3, 5},
        /* 401*/ {152},
        /* 402*/ {171},
        /* 403*/ {5, 8, 9},
        /* 404*/ {65},
        /* 405*/ {2, 8, 13},
        /* 406*/ {141},
        /* 407*/ {71},
        /* 408*/ {2, 3, 5},
        /* 409*/ {87},
        /* 410*/ {3, 4, 10},
        /* 411*/ {3, 10, 12},
        /* 412*/ {147},
        /* 413*/ {6, 7, 10},
        /* 414*/ {13},
        /* 415*/ {102},
        /* 416*/ {2, 5, 9},
        /* 417*/ {107},
        /* 418*/ {199},
        /* 419*/ {4, 5, 15},
        /* 420*/ {7},
        /* 421*/ {2, 4, 5},
        /* 422*/ {149},
        /* 423*/ {25},
        /* 424*/ {2, 7, 9},
        /* 425*/ {12},
        /* 426*/ {63},
        /* 427*/ {5, 6, 11},
        /* 428*/ {105},
        /* 429*/ {7, 8, 10},
        /* 430*/ {1, 6, 14},
        /* 431*/ {120},
        /* 432*/ {3, 4, 13},
        /* 433*/ {33},
        /* 434*/ {5, 11, 12},
        /* 435*/ {5, 9, 12},
        /* 436*/ {165},
        /* 437*/ {1, 2, 6},
        /* 438*/ {65},
        /* 439*/ {49},
        /* 440*/ {1, 3, 4},
        /* 441*/ {7},
        /* 442*/ {2, 5, 7},
        /* 443*/ {1, 6, 10},
        /* 444*/ {81},
        /* 445*/ {4, 6, 7},
        /* 446*/ {105},
        /* 447*/ {73},
        /* 448*/ {4, 6, 11},
        /* 449*/ {134},
        /* 450*/ {47},
        /* 451*/ {1, 10, 16},
        /* 452*/ {4, 5, 6},
        /* 453*/ {4, 6, 15},
        /* 454*/ {1, 6, 8},
        /* 455*/ {38},
        /* 456*/ {6, 9, 18},
        /* 457*/ {16},
        /* 458*/ {203},
        /* 459*/ {2, 5, 12},
        /* 460*/ {19},
        /* 461*/ {1, 6, 7},
        /* 462*/ {73},
        /* 463*/ {93},
        /* 464*/ {13, 18, 19},
        /* 465*/ {31},
        /* 466*/ {6, 11, 14},
        /* 467*/ {1, 6, 11},
        /* 468*/ {27},
        /* 469*/ {2, 5, 9},
        /* 470*/ {9},
        /* 471*/ {1},
        /* 472*/ {2, 3, 11},
        /* 473*/ {200},
        /* 474*/ {191},
        /* 475*/ {4, 8, 9},
        /* 476*/ {9},
        /* 477*/ {7, 15, 16},
        /* 478*/ {121},
        /* 479*/ {104},
        /* 480*/ {6, 9, 15},
        /* 481*/ {138},
        /* 482*/ {5, 6, 9},
        /* 483*/ {4, 6, 9},
        /* 484*/ {105},
        /* 485*/ {6, 16, 17},
        /* 486*/ {81},
        /* 487*/ {94},
        /* 488*/ {1, 3, 4},
        /* 489*/ {83},
        /* 490*/ {219},
        /* 491*/ {3, 6, 11},
        /* 492*/ {7},
        /* 493*/ {3, 5, 10},
        /* 494*/ {17},
        /* 495*/ {76},
        /* 496*/ {2, 5, 16},
        /* 497*/ {78},
        /* 498*/ {155},
        /* 499*/ {5, 6, 11},
        /* 500*/ {27},
        /* 501*/ {2, 4, 5},
        /* 502*/ {4, 5, 8},
        /* 503*/ {3},
        /* 504*/ {6, 14, 15},
        /* 505*/ {156},
        /* 506*/ {23},
        /* 507*/ {3, 6, 13},
        /* 508*/ {9},
        /* 509*/ {3, 7, 8},
        /* 510*/ {69},
        /* 511*/ {10},
        /* 512*/ {2, 5, 8},
        /* 513*/ {26},
        /* 514*/ {67},
        /* 515*/ {4, 7, 14},
        /* 516*/ {21},
        /* 517*/ {2, 10, 12},
        /* 518*/ {33},
        /* 519*/ {79},
        /* 520*/ {2, 11, 15},
        /* 521*/ {32},
        /* 522*/ {39},
        /* 523*/ {2, 6, 13},
        /* 524*/ {167},
        /* 525*/ {1, 4, 6},
        /* 526*/ {97},
        /* 527*/ {47},
        /* 528*/ {2, 6, 11},
        /* 529*/ {42},
        /* 530*/ {3, 7, 10},
        /* 531*/ {4, 5, 10},
        /* 532*/ {1},
        /* 533*/ {2, 3, 4},
        /* 534*/ {161},
        /* 535*/ {2, 6, 8},
        /* 536*/ {3, 5, 7},
        /* 537*/ {94},
        /* 538*/ {195},
        /* 539*/ {4, 5, 10},
        /* 540*/ {9},
        /* 541*/ {4, 10, 13},
        /* 542*/ {1, 6, 8},
        /* 543*/ {16},
        /* 544*/ {1, 3, 8},
        /* 545*/ {122},
        /* 546*/ {1, 2, 8},
        /* 547*/ {4, 7, 13},
        /* 548*/ {3, 5, 10},
        /* 549*/ {3, 4, 16},
        /* 550*/ {193},
        /* 551*/ {135},
        /* 552*/ {9, 16, 19},
        /* 553*/ {39},
        /* 554*/ {7, 8, 10},
        /* 555*/ {4, 9, 10},
        /* 556*/ {153},
        /* 557*/ {5, 6, 7},
        /* 558*/ {73},
        /* 559*/ {34},
        /* 560*/ {6, 9, 11},
        /* 561*/ {71},
        /* 562*/ {2, 4, 11},
        /* 563*/ {3, 7, 14},
        /* 564*/ {163},
        /* 565*/ {1, 6, 11},
        /* 566*/ {153},
        /* 567*/ {28},
        /* 568*/ {6, 7, 15},
        /* 569*/ {77},
        /* 570*/ {67},
        /* 571*/ {2, 5, 10},
        /* 572*/ {1, 8, 12},
        /* 573*/ {4, 6, 10},
        /* 574*/ {13},
        /* 575*/ {146},
        /* 576*/ {3, 4, 13},
        /* 577*/ {25},
        /* 578*/ {16, 22, 23},
        /* 579*/ {7, 9, 12},
        /* 580*/ {237},
        /* 581*/ {6, 7, 13},
        /* 582*/ {85},
        /* 583*/ {130},
        /* 584*/ {3, 13, 14},
        /* 585*/ {88},
        /* 586*/ {2, 5, 7},
        /* 587*/ {1, 6, 11},
        /* 588*/ {35},
        /* 589*/ {3, 4, 10},
        /* 590*/ {93},
        /* 591*/ {4, 6, 9},
        /* 592*/ {3, 6, 13},
        /* 593*/ {86},
        /* 594*/ {19},
        /* 595*/ {1, 2, 9},
        /* 596*/ {273},
        /* 597*/ {9, 12, 14},
        /* 598*/ {1, 6, 7},
        /* 599*/ {30},
        /* 600*/ {2, 5, 9},
        /* 601*/ {201},
        /* 602*/ {215},
        /* 603*/ {3, 4, 6},
        /* 604*/ {105},
        /* 605*/ {5, 7, 10},
        /* 606*/ {165},
        /* 607*/ {105},
        /* 608*/ {6, 13, 19},
        /* 609*/ {31},
        /* 610*/ {127},
        /* 611*/ {2, 4, 10},
        /* 612*/ {81},
        /* 613*/ {4, 10, 19},
        /* 614*/ {45},
        /* 615*/ {211},
        /* 616*/ {3, 10, 19},
        /* 617*/ {200},
        /* 618*/ {295},
        /* 619*/ {5, 8, 9},
        /* 620*/ {9},
        /* 621*/ {5, 6, 12},
        /* 622*/ {297},
        /* 623*/ {68},
        /* 624*/ {5, 6, 11},
        /* 625*/ {133},
        /* 626*/ {251},
        /* 627*/ {4, 8, 13},
        /* 628*/ {223},
        /* 629*/ {2, 5, 6},
        /* 630*/ {2, 4, 7},
        /* 631*/ {307},
        /* 632*/ {1, 2, 9},
        /* 633*/ {101},
        /* 634*/ {39},
        /* 635*/ {4, 10, 14},
        /* 636*/ {217},
        /* 637*/ {1, 9, 14},
        /* 638*/ {1, 5, 6},
        /* 639*/ {16},
        /* 640*/ {2, 3, 14},
        /* 641*/ {11},
        /* 642*/ {119},
        /* 643*/ {2, 3, 11},
        /* 644*/ {5, 6, 11},
        /* 645*/ {4, 8, 11},
        /* 646*/ {249},
        /* 647*/ {5},
        /* 648*/ {1, 3, 13},
        /* 649*/ {37},
        /* 650*/ {3},
        /* 651*/ {14},
        /* 652*/ {93},
        /* 653*/ {7, 8, 10},
        /* 654*/ {33},
        /* 655*/ {88},
        /* 656*/ {4, 5, 7},
        /* 657*/ {38},
        /* 658*/ {55},
        /* 659*/ {2, 4, 15},
        /* 660*/ {11},
        /* 661*/ {4, 11, 12},
        /* 662*/ {21},
        /* 663*/ {107},
        /* 664*/ {8, 9, 11},
        /* 665*/ {33},
        /* 666*/ {2, 7, 10},
        /* 667*/ {3, 7, 18},
        /* 668*/ {147},
        /* 669*/ {2, 4, 5},
        /* 670*/ {153},
        /* 671*/ {15},
        /* 672*/ {5, 6, 11},
        /* 673*/ {28},
        /* 674*/ {4, 7, 11},
        /* 675*/ {1, 3, 6},
        /* 676*/ {31},
        /* 677*/ {3, 4, 8},
        /* 678*/ {3, 5, 15},
        /* 679*/ {66},
        /* 680*/ {9, 16, 23},
        /* 681*/ {3, 9, 11},
        /* 682*/ {171},
        /* 683*/ {1, 6, 11},
        /* 684*/ {209},
        /* 685*/ {1, 3, 4},
        /* 686*/ {197},
        /* 687*/ {13},
        /* 688*/ {6, 14, 19},
        /* 689*/ {14},
        /* 690*/ {79},
        /* 691*/ {2, 6, 13},
        /* 692*/ {299},
        /* 693*/ {2, 8, 15},
        /* 694*/ {169},
        /* 695*/ {177},
        /* 696*/ {2, 10, 23},
        /* 697*/ {267},
        /* 698*/ {215},
        /* 699*/ {1, 10, 15},
        /* 700*/ {75},
        /* 701*/ {2, 4, 16},
        /* 702*/ {37},
        /* 703*/ {1, 7, 12},
        /* 704*/ {2, 3, 8},
        /* 705*/ {17},
        /* 706*/ {8, 11, 12},
        /* 707*/ {5, 8, 15},
        /* 708*/ {15},
        /* 709*/ {1, 3, 4},
        /* 710*/ {4, 12, 13},
        /* 711*/ {92},
        /* 712*/ {3, 4, 5},
        /* 713*/ {41},
        /* 714*/ {23},
        /* 715*/ {1, 4, 7},
        /* 716*/ {183},
        /* 717*/ {1, 7, 16},
        /* 718*/ {165},
        /* 719*/ {150},
        /* 720*/ {4, 6, 9},
        /* 721*/ {9},
        /* 722*/ {231},
        /* 723*/ {4, 10, 16},
        /* 724*/ {207},
        /* 725*/ {5, 6, 9},
        /* 726*/ {5},
        /* 727*/ {180},
        /* 728*/ {2, 3, 4},
        /* 729*/ {58},
        /* 730*/ {147},
        /* 731*/ {2, 6, 8},
        /* 732*/ {343},
        /* 733*/ {2, 7, 8},
        /* 734*/ {1, 6, 11},
        /* 735*/ {44},
        /* 736*/ {6, 8, 13},
        /* 737*/ {5},
        /* 738*/ {347},
        /* 739*/ {8, 16, 18},
        /* 740*/ {135},
        /* 741*/ {3, 8, 9},
        /* 742*/ {85},
        /* 743*/ {90},
        /* 744*/ {1, 11, 13},
        /* 745*/ {258},
        /* 746*/ {351},
        /* 747*/ {4, 6, 10},
        /* 748*/ {19},
        /* 749*/ {1, 6, 7},
        /* 750*/ {309},
        /* 751*/ {18},
        /* 752*/ {3, 10, 13},
        /* 753*/ {158},
        /* 754*/ {19},
        /* 755*/ {1, 10, 12},
        /* 756*/ {45},
        /* 757*/ {1, 6, 7},
        /* 758*/ {233},
        /* 759*/ {98},
        /* 760*/ {5, 6, 11},
        /* 761*/ {3},
        /* 762*/ {83},
        /* 763*/ {9, 14, 16},
        /* 764*/ {3, 5, 6},
        /* 765*/ {4, 7, 9},
        /* 766*/ {9, 19, 22},
        /* 767*/ {168},
        /* 768*/ {4, 17, 19},
        /* 769*/ {120},
        /* 770*/ {2, 5, 14},
        /* 771*/ {6, 15, 17},
        /* 772*/ {7},
        /* 773*/ {6, 8, 10},
        /* 774*/ {185},
        /* 775*/ {93},
        /* 776*/ {7, 14, 15},
        /* 777*/ {29},
        /* 778*/ {375},
        /* 779*/ {3, 8, 10},
        /* 780*/ {13},
        /* 781*/ {2, 16, 17},
        /* 782*/ {329},
        /* 783*/ {68},
        /* 784*/ {6, 9, 13},
        /* 785*/ {92},
        /* 786*/ {3, 10, 12},
        /* 787*/ {3, 6, 7},
        /* 788*/ {3, 10, 17},
        /* 789*/ {1, 2, 5},
        /* 790*/ {1, 6, 9},
        /* 791*/ {30},
        /* 792*/ {3, 7, 9},
        /* 793*/ {253},
        /* 794*/ {143},
        /* 795*/ {1, 4, 7},
        /* 796*/ {1, 4, 9},
        /* 797*/ {4, 10, 12},
        /* 798*/ {53},
        /* 799*/ {25},
        /* 800*/ {1, 7, 9},
        /* 801*/ {217},
        /* 802*/ {9, 13, 15},
        /* 803*/ {2, 9, 14},
        /* 804*/ {75},
        /* 805*/ {2, 7, 8},
        /* 806*/ {21},
        /* 807*/ {7},
        /* 808*/ {2, 3, 14},
        /* 809*/ {15},
        /* 810*/ {159},
        /* 811*/ {8, 10, 12},
        /* 812*/ {29},
        /* 813*/ {1, 3, 10},
        /* 814*/ {21},
        /* 815*/ {333},
        /* 816*/ {2, 8, 11},
        /* 817*/ {52},
        /* 818*/ {119},
        /* 819*/ {7, 9, 16},
        /* 820*/ {123},
        /* 821*/ {2, 11, 15},
        /* 822*/ {17},
        /* 823*/ {9},
        /* 824*/ {4, 6, 11},
        /* 825*/ {38},
        /* 826*/ {255},
        /* 827*/ {7, 10, 12},
        /* 828*/ {189},
        /* 829*/ {1, 3, 4},
        /* 830*/ {7, 10, 17},
        /* 831*/ {49},
        /* 832*/ {2, 5, 13},
        /* 833*/ {149},
        /* 834*/ {15},
        /* 835*/ {5, 7, 14},
        /* 836*/ {2, 9, 10},
        /* 837*/ {5, 6, 8},
        /* 838*/ {61},
        /* 839*/ {54},
        /* 840*/ {1, 5, 11},
        /* 841*/ {144},
        /* 842*/ {47},
        /* 843*/ {7, 10, 11},
        /* 844*/ {105},
        /* 845*/ {2},
        /* 846*/ {105},
        /* 847*/ {136},
        /* 848*/ {1, 4, 11},
        /* 849*/ {253},
        /* 850*/ {111},
        /* 851*/ {5, 10, 13},
        /* 852*/ {159},
        /* 853*/ {1, 7, 10},
        /* 854*/ {3, 5, 7},
        /* 855*/ {29},
        /* 856*/ {3, 10, 19},
        /* 857*/ {119},
        /* 858*/ {207},
        /* 859*/ {4, 15, 17},
        /* 860*/ {35},
        /* 861*/ {14},
        /* 862*/ {349},
        /* 863*/ {2, 3, 6},
        /* 864*/ {6, 10, 21},
        /* 865*/ {1},
        /* 866*/ {75},
        /* 867*/ {2, 5, 9},
        /* 868*/ {145},
        /* 869*/ {6, 7, 11},
        /* 870*/ {301},
        /* 871*/ {378},
        /* 872*/ {1, 3, 13},
        /* 873*/ {352},
        /* 874*/ {4, 7, 12},
        /* 875*/ {1, 8, 12},
        /* 876*/ {149},
        /* 877*/ {4, 5, 6},
        /* 878*/ {8, 9, 12},
        /* 879*/ {11},
        /* 880*/ {5, 7, 15},
        /* 881*/ {78},
        /* 882*/ {99},
        /* 883*/ {12, 16, 17},
        /* 884*/ {173},
        /* 885*/ {1, 7, 8},
        /* 886*/ {8, 9, 13},
        /* 887*/ {147},
        /* 888*/ {10, 18, 19},
        /* 889*/ {127},
        /* 890*/ {183},
        /* 891*/ {1, 4, 12},
        /* 892*/ {31},
        /* 893*/ {6, 8, 11},
        /* 894*/ {173},
        /* 895*/ {12},
        /* 896*/ {3, 5, 7},
        /* 897*/ {113},
        /* 898*/ {207},
        /* 899*/ {5, 15, 18},
        /* 900*/ {1},
        /* 901*/ {6, 7, 13},
        /* 902*/ {21},
        /* 903*/ {35},
        /* 904*/ {2, 7, 12},
        /* 905*/ {117},
        /* 906*/ {123},
        /* 907*/ {2, 10, 12},
        /* 908*/ {143},
        /* 909*/ {1, 4, 14},
        /* 910*/ {7, 9, 15},
        /* 911*/ {204},
        /* 912*/ {1, 5, 7},
        /* 913*/ {91},
        /* 914*/ {1, 2, 4},
        /* 915*/ {3, 6, 8},
        /* 916*/ {183},
        /* 917*/ {7, 10, 12},
        /* 918*/ {77},
        /* 919*/ {36},
        /* 920*/ {6, 9, 14},
        /* 921*/ {221},
        /* 922*/ {5, 6, 7},
        /* 923*/ {13, 14, 16},
        /* 924*/ {31},
        /* 925*/ {7, 15, 16},
        /* 926*/ {365},
        /* 927*/ {403},
        /* 928*/ {2, 3, 10},
        /* 929*/ {3, 4, 11},
        /* 930*/ {31},
        /* 931*/ {4, 9, 10},
        /* 932*/ {177},
        /* 933*/ {1, 6, 16},
        /* 934*/ {5, 6, 22},
        /* 935*/ {417},
        /* 936*/ {12, 13, 15},
        /* 937*/ {217},
        /* 938*/ {207},
        /* 939*/ {4, 5, 7},
        /* 940*/ {1, 7, 10},
        /* 941*/ {1, 6, 11},
        /* 942*/ {45},
        /* 943*/ {24},
        /* 944*/ {9, 11, 12},
        /* 945*/ {77},
        /* 946*/ {13, 20, 21},
        /* 947*/ {5, 6, 9},
        /* 948*/ {189},
        /* 949*/ {2, 3, 8},
        /* 950*/ {10, 12, 13},
        /* 951*/ {260},
        /* 952*/ {7, 9, 16},
        /* 953*/ {168},
        /* 954*/ {131},
        /* 955*/ {3, 6, 7},
        /* 956*/ {305},
        /* 957*/ {6, 9, 10},
        /* 958*/ {4, 9, 13},
        /* 959*/ {143},
        /* 960*/ {3, 9, 12},
        /* 961*/ {18},
        /* 962*/ {5, 8, 15},
        /* 963*/ {6, 9, 20},
        /* 964*/ {103},
        /* 965*/ {2, 4, 15},
        /* 966*/ {201},
        /* 967*/ {36},
        /* 968*/ {2, 5, 9},
        /* 969*/ {31},
        /* 970*/ {2, 7, 11},
        /* 971*/ {1, 2, 6},
        /* 972*/ {7},
        /* 973*/ {4, 6, 13},
        /* 974*/ {7, 8, 9},
        /* 975*/ {19},
        /* 976*/ {6, 10, 17},
        /* 977*/ {15},
        /* 978*/ {1, 3, 9},
        /* 979*/ {178},
        /* 980*/ {6, 7, 8},
        /* 981*/ {5, 6, 12},
        /* 982*/ {177},
        /* 983*/ {230},
        /* 984*/ {3, 9, 24},
        /* 985*/ {222},
        /* 986*/ {3},
        /* 987*/ {12, 13, 16},
        /* 988*/ {121},
        /* 989*/ {2, 4, 10},
        /* 990*/ {161},
        /* 991*/ {39},
        /* 992*/ {13, 15, 17},
        /* 993*/ {62},
        /* 994*/ {223},
        /* 995*/ {2, 12, 15},
        /* 996*/ {65},
        /* 997*/ {3, 6, 12},
        /* 998*/ {101},
        /* 999*/ {59},
        /*1000*/ {3, 4, 5},
    };

    private static final short[][] irredX9F1 = {
        /*   0*/ null,
        /*   1*/ null,
        /*   2*/ null,
        /*   3*/ null,
        /*   4*/ null,
        /*   5*/ null,
        /*   6*/ null,
        /*   7*/ null,
        /*   8*/ null,
        /*   9*/ null,
        /*  10*/ null,
        /*  11*/ null,
        /*  12*/ null,
        /*  13*/ null,
        /*  14*/ null,
        /*  15*/ null,
        /*  16*/ null,
        /*  17*/ null,
        /*  18*/ null,
        /*  19*/ null,
        /*  20*/ null,
        /*  21*/ null,
        /*  22*/ null,
        /*  23*/ null,
        /*  24*/ null,
        /*  25*/ null,
        /*  26*/ null,
        /*  27*/ null,
        /*  28*/ null,
        /*  29*/ null,
        /*  30*/ null,
        /*  31*/ null,
        /*  32*/ null,
        /*  33*/ null,
        /*  34*/ null,
        /*  35*/ null,
        /*  36*/ null,
        /*  37*/ null,
        /*  38*/ null,
        /*  39*/ null,
        /*  40*/ null,
        /*  41*/ null,
        /*  42*/ null,
        /*  43*/ null,
        /*  44*/ null,
        /*  45*/ null,
        /*  46*/ null,
        /*  47*/ null,
        /*  48*/ null,
        /*  49*/ null,
        /*  50*/ null,
        /*  51*/ null,
        /*  52*/ null,
        /*  53*/ null,
        /*  54*/ null,
        /*  55*/ null,
        /*  56*/ null,
        /*  57*/ null,
        /*  58*/ null,
        /*  59*/ null,
        /*  60*/ null,
        /*  61*/ null,
        /*  62*/ null,
        /*  63*/ null,
        /*  64*/ null,
        /*  65*/ null,
        /*  66*/ null,
        /*  67*/ null,
        /*  68*/ null,
        /*  69*/ null,
        /*  70*/ null,
        /*  71*/ null,
        /*  72*/ null,
        /*  73*/ null,
        /*  74*/ null,
        /*  75*/ null,
        /*  76*/ null,
        /*  77*/ null,
        /*  78*/ null,
        /*  79*/ null,
        /*  80*/ null,
        /*  81*/ null,
        /*  82*/ null,
        /*  83*/ null,
        /*  84*/ null,
        /*  85*/ null,
        /*  86*/ null,
        /*  87*/ null,
        /*  88*/ null,
        /*  89*/ null,
        /*  90*/ null,
        /*  91*/ null,
        /*  92*/ null,
        /*  93*/ null,
        /*  94*/ null,
        /*  95*/ null,
        /*  96*/ null,
        /*  97*/ null,
        /*  98*/ null,
        /*  99*/ null,
        /* 100*/ null,
        /* 101*/ null,
        /* 102*/ null,
        /* 103*/ null,
        /* 104*/ null,
        /* 105*/ null,
        /* 106*/ null,
        /* 107*/ null,
        /* 108*/ null,
        /* 109*/ null,
        /* 110*/ null,
        /* 111*/ null,
        /* 112*/ null,
        /* 113*/ null,
        /* 114*/ null,
        /* 115*/ null,
        /* 116*/ null,
        /* 117*/ null,
        /* 118*/ null,
        /* 119*/ null,
        /* 120*/ null,
        /* 121*/ null,
        /* 122*/ null,
        /* 123*/ null,
        /* 124*/ null,
        /* 125*/ null,
        /* 126*/ null,
        /* 127*/ null,
        /* 128*/ null,
        /* 129*/ null,
        /* 130*/ null,
        /* 131*/ null,
        /* 132*/ null,
        /* 133*/ null,
        /* 134*/ null,
        /* 135*/ null,
        /* 136*/ null,
        /* 137*/ null,
        /* 138*/ null,
        /* 139*/ null,
        /* 140*/ null,
        /* 141*/ null,
        /* 142*/ null,
        /* 143*/ null,
        /* 144*/ null,
        /* 145*/ null,
        /* 146*/ null,
        /* 147*/ null,
        /* 148*/ null,
        /* 149*/ null,
        /* 150*/ null,
        /* 151*/ null,
        /* 152*/ null,
        /* 153*/ null,
        /* 154*/ null,
        /* 155*/ null,
        /* 156*/ null,
        /* 157*/ null,
        /* 158*/ null,
        /* 159*/ null,
        /* 160*/ {1, 2,  117},
        /* 161*/ {18},
        /* 162*/ {27},
        /* 163*/ {1, 2,    8},
        /* 164*/ {1, 2,   49},
        /* 165*/ {1, 2,   25},
        /* 166*/ {37},
        /* 167*/ {6},
        /* 168*/ {1, 2,   65},
        /* 169*/ {34},
        /* 170*/ {11},
        /* 171*/ {1, 3,   42},
        /* 172*/ {1},
        /* 173*/ {1, 2,   10},
        /* 174*/ {13},
        /* 175*/ {6},
        /* 176*/ {1, 2,   43},
        /* 177*/ {8},
        /* 178*/ {31},
        /* 179*/ {1, 2,    4},
        /* 180*/ {3},
        /* 181*/ {1, 2,   89},
        /* 182*/ {81},
        /* 183*/ {56},
        /* 184*/ {1, 2,   81},
        /* 185*/ {24},
        /* 186*/ {11},
        /* 187*/ {1, 2,   20},
        /* 188*/ {1, 2,   60},
        /* 189*/ {1, 2,   49},
        /* 190*/ {1, 2,   47},
        /* 191*/ {9},
        /* 192*/ {1, 2,    7},
        /* 193*/ {15},
        /* 194*/ {87},
        /* 195*/ {1, 2,   37},
        /* 196*/ {3},
        /* 197*/ {1, 2,   21},
        /* 198*/ {9},
        /* 199*/ {34},
        /* 200*/ {1, 2,   81},
        /* 201*/ {14},
        /* 202*/ {55},
        /* 203*/ {1, 2,   45},
        /* 204*/ {27},
        /* 205*/ {1, 2,   21},
        /* 206*/ {1, 2,   63},
        /* 207*/ {43},
        /* 208*/ {1, 2,   83},
        /* 209*/ {6},
        /* 210*/ {7},
        /* 211*/ {1, 2,  165},
        /* 212*/ {105},
        /* 213*/ {1, 2,   62},
        /* 214*/ {73},
        /* 215*/ {23},
        /* 216*/ {1, 2,  107},
        /* 217*/ {45},
        /* 218*/ {11},
        /* 219*/ {1, 2,   65},
        /* 220*/ {7},
        /* 221*/ {1, 2,   18},
        /* 222*/ {1, 2,   73},
        /* 223*/ {33},
        /* 224*/ {1, 2,  159},
        /* 225*/ {32},
        /* 226*/ {1, 2,   30},
        /* 227*/ {1, 2,   21},
        /* 228*/ {113},
        /* 229*/ {1, 2,   21},
        /* 230*/ {1, 2,   13},
        /* 231*/ {26},
        /* 232*/ {1, 2,   23},
        /* 233*/ {74},
        /* 234*/ {31},
        /* 235*/ {1, 2,   45},
        /* 236*/ {5},
        /* 237*/ {1, 2,  104},
        /* 238*/ {73},
        /* 239*/ {36},
        /* 240*/ {1, 3,   49},
        /* 241*/ {70},
        /* 242*/ {95},
        /* 243*/ {1, 2,   17},
        /* 244*/ {111},
        /* 245*/ {1, 2,   37},
        /* 246*/ {1, 2,   11},
        /* 247*/ {82},
        /* 248*/ {1, 2,  243},
        /* 249*/ {35},
        /* 250*/ {103},
        /* 251*/ {1, 2,   45},
        /* 252*/ {15},
        /* 253*/ {46},
        /* 254*/ {1, 2,    7},
        /* 255*/ {52},
        /* 256*/ {1, 2,  155},
        /* 257*/ {12},
        /* 258*/ {71},
        /* 259*/ {1, 2,  254},
        /* 260*/ {15},
        /* 261*/ {1, 2,   74},
        /* 262*/ {1, 2,  207},
        /* 263*/ {93},
        /* 264*/ {1, 2,  169},
        /* 265*/ {42},
        /* 266*/ {47},
        /* 267*/ {1, 2,   29},
        /* 268*/ {25},
        /* 269*/ {1, 2,  117},
        /* 270*/ {53},
        /* 271*/ {58},
        /* 272*/ {1, 3,   56},
        /* 273*/ {23},
        /* 274*/ {67},
        /* 275*/ {1, 2,   28},
        /* 276*/ {63},
        /* 277*/ {1, 2,   33},
        /* 278*/ {5},
        /* 279*/ {5},
        /* 280*/ {1, 2,  113},
        /* 281*/ {93},
        /* 282*/ {35},
        /* 283*/ {1, 2,  200},
        /* 284*/ {53},
        /* 285*/ {1, 2,   77},
        /* 286*/ {69},
        /* 287*/ {71},
        /* 288*/ {1, 2,  191},
        /* 289*/ {21},
        /* 290*/ {1, 2,   70},
        /* 291*/ {1, 2,   76},
        /* 292*/ {37},
        /* 293*/ {1, 3,  154},
        /* 294*/ {33},
        /* 295*/ {48},
        /* 296*/ {1, 2,  123},
        /* 297*/ {5},
        /* 298*/ {1, 2,   78},
        /* 299*/ {1, 2,   21},
        /* 300*/ {5},
        /* 301*/ {1, 2,   26},
        /* 302*/ {41},
        /* 303*/ {1},
        /* 304*/ {1, 2,   11},
        /* 305*/ {102},
        /* 306*/ {1, 2,  106},
        /* 307*/ {1, 2,   93},
        /* 308*/ {15},
        /* 309*/ {1, 2,   26},
        /* 310*/ {93},
        /* 311*/ {1, 3,  155},
        /* 312*/ {1, 2,   83},
        /* 313*/ {79},
        /* 314*/ {15},
        /* 315*/ {1, 2,  142},
        /* 316*/ {63},
        /* 317*/ {1, 3,   68},
        /* 318*/ {45},
        /* 319*/ {36},
        /* 320*/ {1, 2,    7},
        /* 321*/ {31},
        /* 322*/ {67},
        /* 323*/ {1, 2,   21},
        /* 324*/ {51},
        /* 325*/ {1, 2,   53},
        /* 326*/ {1, 2,   67},
        /* 327*/ {34},
        /* 328*/ {1, 2,   51},
        /* 329*/ {50},
        /* 330*/ {99},
        /* 331*/ {1, 2,  134},
        /* 332*/ {89},
        /* 333*/ {2},
        /* 334*/ {1, 2,    5},
        /* 335*/ {1, 2,  250},
        /* 336*/ {1, 2,   77},
        /* 337*/ {55},
        /* 338*/ {1, 2,  112},
        /* 339*/ {1, 2,   26},
        /* 340*/ {45},
        /* 341*/ {1, 2,   57},
        /* 342*/ {125},
        /* 343*/ {75},
        /* 344*/ {1, 2,    7},
        /* 345*/ {22},
        /* 346*/ {63},
        /* 347*/ {1, 2,   96},
        /* 348*/ {103},
        /* 349*/ {1, 2,  186},
        /* 350*/ {53},
        /* 351*/ {34},
        /* 352*/ {1, 2,  263},
        /* 353*/ {69},
        /* 354*/ {99},
        /* 355*/ {1, 2,  138},
        /* 356*/ {1, 2,   69},
        /* 357*/ {1, 2,   28},
        /* 358*/ {57},
        /* 359*/ {68},
        /* 360*/ {1, 2,   49},
        /* 361*/ {1, 2,   44},
        /* 362*/ {63},
        /* 363*/ {1, 2,   38},
        /* 364*/ {9},
        /* 365*/ {1, 2,  109},
        /* 366*/ {29},
        /* 367*/ {21},
        /* 368*/ {1, 2,   85},
        /* 369*/ {91},
        /* 370*/ {139},
        /* 371*/ {1, 2,  156},
        /* 372*/ {111},
        /* 373*/ {1, 3,  172},
        /* 374*/ {1, 2,  109},
        /* 375*/ {16},
        /* 376*/ {1, 2,   77},
        /* 377*/ {41},
        /* 378*/ {43},
        /* 379*/ {1, 2,  222},
        /* 380*/ {47},
        /* 381*/ {1, 2,    5},
        /* 382*/ {81},
        /* 383*/ {90},
        /* 384*/ {1, 2,  299},
        /* 385*/ {6},
        /* 386*/ {83},
        /* 387*/ {1, 2,  146},
        /* 388*/ {159},
        /* 389*/ {1, 2,  159},
        /* 390*/ {9},
        /* 391*/ {28},
        /* 392*/ {1, 2,  145},
        /* 393*/ {7},
        /* 394*/ {135},
        /* 395*/ {1, 2,  333},
        /* 396*/ {25},
        /* 397*/ {1, 2,  125},
        /* 398*/ {1, 3,   23},
        /* 399*/ {26},
        /* 400*/ {1, 2,  245},
        /* 401*/ {152},
        /* 402*/ {171},
        /* 403*/ {1, 2,   80},
        /* 404*/ {65},
        /* 405*/ {1, 2,   38},
        /* 406*/ {141},
        /* 407*/ {71},
        /* 408*/ {1, 2,  323},
        /* 409*/ {87},
        /* 410*/ {1, 2,   16},
        /* 411*/ {1, 2,   50},
        /* 412*/ {147},
        /* 413*/ {1, 2,   33},
        /* 414*/ {13},
        /* 415*/ {102},
        /* 416*/ {1, 3,   76},
        /* 417*/ {107},
        /* 418*/ {199},
        /* 419*/ {1, 2,  129},
        /* 420*/ {7},
        /* 421*/ {1, 2,   81},
        /* 422*/ {149},
        /* 423*/ {25},
        /* 424*/ {1, 2,  177},
        /* 425*/ {12},
        /* 426*/ {63},
        /* 427*/ {1, 2,  245},
        /* 428*/ {105},
        /* 429*/ {1, 2,   14},
        /* 430*/ {1, 2,  263},
        /* 431*/ {120},
        /* 432*/ {1, 2,  103},
        /* 433*/ {33},
        /* 434*/ {1, 2,   64},
        /* 435*/ {1, 2,  166},
        /* 436*/ {165},
        /* 437*/ {1, 2,    6},
        /* 438*/ {65},
        /* 439*/ {49},
        /* 440*/ {1, 2,   37},
        /* 441*/ {7},
        /* 442*/ {1, 2,   32},
        /* 443*/ {1, 2,   57},
        /* 444*/ {81},
        /* 445*/ {1, 2,  225},
        /* 446*/ {105},
        /* 447*/ {73},
        /* 448*/ {1, 3,   83},
        /* 449*/ {134},
        /* 450*/ {47},
        /* 451*/ {1, 2,   33},
        /* 452*/ {1, 2,   10},
        /* 453*/ {1, 2,   88},
        /* 454*/ {1, 2,  195},
        /* 455*/ {38},
        /* 456*/ {1, 2,  275},
        /* 457*/ {16},
        /* 458*/ {203},
        /* 459*/ {1, 2,  332},
        /* 460*/ {19},
        /* 461*/ {1, 2,  247},
        /* 462*/ {73},
        /* 463*/ {93},
        /* 464*/ {1, 2,  310},
        /* 465*/ {31},
        /* 466*/ {1, 2,   78},
        /* 467*/ {1, 2,  210},
        /* 468*/ {27},
        /* 469*/ {1, 2,  149},
        /* 470*/ {9},
        /* 471*/ {1},
        /* 472*/ {1, 2,   33},
        /* 473*/ {200},
        /* 474*/ {191},
        /* 475*/ {1, 2,   68},
        /* 476*/ {9},
        /* 477*/ {1, 2,  121},
        /* 478*/ {121},
        /* 479*/ {104},
        /* 480*/ {1, 2,  149},
        /* 481*/ {138},
        /* 482*/ {1, 2,   13},
        /* 483*/ {1, 2,  352},
        /* 484*/ {105},
        /* 485*/ {1, 2,   70},
        /* 486*/ {81},
        /* 487*/ {94},
        /* 488*/ {1, 2,  123},
        /* 489*/ {83},
        /* 490*/ {219},
        /* 491*/ {1, 2,  270},
        /* 492*/ {7},
        /* 493*/ {1, 2,  171},
        /* 494*/ {17},
        /* 495*/ {76},
        /* 496*/ {1, 3,   52},
        /* 497*/ {78},
        /* 498*/ {155},
        /* 499*/ {1, 2,  174},
        /* 500*/ {27},
        /* 501*/ {1, 2,  332},
        /* 502*/ {1, 2,   99},
        /* 503*/ {3},
        /* 504*/ {1, 3,  148},
        /* 505*/ {156},
        /* 506*/ {23},
        /* 507*/ {1, 2,   26},
        /* 508*/ {9},
        /* 509*/ {1, 2,   94},
        /* 510*/ {69},
        /* 511*/ {10},
        /* 512*/ {1, 2,   51},
        /* 513*/ {26},
        /* 514*/ {67},
        /* 515*/ {1, 2,   73},
        /* 516*/ {21},
        /* 517*/ {1, 2,  333},
        /* 518*/ {33},
        /* 519*/ {79},
        /* 520*/ {1, 2,  291},
        /* 521*/ {32},
        /* 522*/ {39},
        /* 523*/ {1, 2,   66},
        /* 524*/ {167},
        /* 525*/ {1, 2,   92},
        /* 526*/ {97},
        /* 527*/ {47},
        /* 528*/ {1, 2,   35},
        /* 529*/ {42},
        /* 530*/ {1, 2,   25},
        /* 531*/ {1, 2,   53},
        /* 532*/ {1},
        /* 533*/ {1, 2,   37},
        /* 534*/ {161},
        /* 535*/ {1, 2,  143},
        /* 536*/ {1, 2,  165},
        /* 537*/ {94},
        /* 538*/ {195},
        /* 539*/ {1, 2,   37},
        /* 540*/ {9},
        /* 541*/ {1, 2,   36},
        /* 542*/ {1, 3,  212},
        /* 543*/ {16},
        /* 544*/ {1, 2,   87},
        /* 545*/ {122},
        /* 546*/ {1, 2,    8},
        /* 547*/ {1, 2,  165},
        /* 548*/ {1, 2,  385},
        /* 549*/ {1, 3,  274},
        /* 550*/ {193},
        /* 551*/ {135},
        /* 552*/ {1, 2,   41},
        /* 553*/ {39},
        /* 554*/ {1, 2,  162},
        /* 555*/ {1, 2,  326},
        /* 556*/ {153},
        /* 557*/ {1, 2,  288},
        /* 558*/ {73},
        /* 559*/ {34},
        /* 560*/ {1, 2,  157},
        /* 561*/ {71},
        /* 562*/ {1, 2,   56},
        /* 563*/ {1, 4,  159},
        /* 564*/ {163},
        /* 565*/ {1, 2,   66},
        /* 566*/ {153},
        /* 567*/ {28},
        /* 568*/ {1, 2,  291},
        /* 569*/ {77},
        /* 570*/ {67},
        /* 571*/ {1, 2,  408},
        /* 572*/ {1, 2,  238},
        /* 573*/ {1, 2,  220},
        /* 574*/ {13},
        /* 575*/ {146},
        /* 576*/ {1, 3,   52},
        /* 577*/ {25},
        /* 578*/ {1, 2,  138},
        /* 579*/ {1, 3,  526},
        /* 580*/ {237},
        /* 581*/ {1, 2,  138},
        /* 582*/ {85},
        /* 583*/ {130},
        /* 584*/ {1, 2,  361},
        /* 585*/ {88},
        /* 586*/ {1, 2,   14},
        /* 587*/ {1, 2,  130},
        /* 588*/ {35},
        /* 589*/ {1, 2,  365},
        /* 590*/ {93},
        /* 591*/ {1, 2,   38},
        /* 592*/ {1, 2,  143},
        /* 593*/ {86},
        /* 594*/ {19},
        /* 595*/ {1, 2,    9},
        /* 596*/ {273},
        /* 597*/ {1, 2,   64},
        /* 598*/ {1, 2,  131},
        /* 599*/ {30},
        /* 600*/ {1, 2,  239},
        /* 601*/ {201},
        /* 602*/ {215},
        /* 603*/ {1, 2,  446},
        /* 604*/ {105},
        /* 605*/ {1, 2,  312},
        /* 606*/ {165},
        /* 607*/ {105},
        /* 608*/ {1, 2,  213},
        /* 609*/ {31},
        /* 610*/ {127},
        /* 611*/ {1, 2,   13},
        /* 612*/ {81},
        /* 613*/ {1, 2,  377},
        /* 614*/ {45},
        /* 615*/ {211},
        /* 616*/ {1, 2,  465},
        /* 617*/ {200},
        /* 618*/ {295},
        /* 619*/ {1, 2,  494},
        /* 620*/ {9},
        /* 621*/ {1, 2,   17},
        /* 622*/ {297},
        /* 623*/ {68},
        /* 624*/ {1, 2,   71},
        /* 625*/ {133},
        /* 626*/ {251},
        /* 627*/ {1, 2,   37},
        /* 628*/ {223},
        /* 629*/ {1, 2,  121},
        /* 630*/ {1, 2,   49},
        /* 631*/ {307},
        /* 632*/ {1, 2,    9},
        /* 633*/ {101},
        /* 634*/ {39},
        /* 635*/ {1, 2,   64},
        /* 636*/ {217},
        /* 637*/ {1, 2,   84},
        /* 638*/ {1, 2,  127},
        /* 639*/ {16},
        /* 640*/ {1, 3,  253},
        /* 641*/ {11},
        /* 642*/ {119},
        /* 643*/ {1, 2,  153},
        /* 644*/ {1, 2,   24},
        /* 645*/ {1, 2,  473},
        /* 646*/ {249},
        /* 647*/ {5},
        /* 648*/ {1, 2,  235},
        /* 649*/ {37},
        /* 650*/ {3},
        /* 651*/ {14},
        /* 652*/ {93},
        /* 653*/ {1, 2,   37},
        /* 654*/ {33},
        /* 655*/ {88},
        /* 656*/ {1, 2,   39},
        /* 657*/ {38},
        /* 658*/ {55},
        /* 659*/ {1, 2,   25},
        /* 660*/ {11},
        /* 661*/ {1, 2,   80},
        /* 662*/ {21},
        /* 663*/ {107},
        /* 664*/ {1, 2,  177},
        /* 665*/ {33},
        /* 666*/ {1, 2,  100},
        /* 667*/ {1, 2,  161},
        /* 668*/ {147},
        /* 669*/ {1, 2,  314},
        /* 670*/ {153},
        /* 671*/ {15},
        /* 672*/ {1, 2,   91},
        /* 673*/ {28},
        /* 674*/ {1, 2,   22},
        /* 675*/ {1, 2,  214},
        /* 676*/ {31},
        /* 677*/ {1, 2,  325},
        /* 678*/ {1, 2,   95},
        /* 679*/ {66},
        /* 680*/ {1, 2,   91},
        /* 681*/ {1, 2,   83},
        /* 682*/ {171},
        /* 683*/ {1, 2,  153},
        /* 684*/ {209},
        /* 685*/ {1, 3,    4},
        /* 686*/ {197},
        /* 687*/ {13},
        /* 688*/ {1, 2,   71},
        /* 689*/ {14},
        /* 690*/ {79},
        /* 691*/ {1, 2,  242},
        /* 692*/ {299},
        /* 693*/ {1, 2,  250},
        /* 694*/ {169},
        /* 695*/ {177},
        /* 696*/ {1, 2,  241},
        /* 697*/ {267},
        /* 698*/ {215},
        /* 699*/ {1, 2,   40},
        /* 700*/ {75},
        /* 701*/ {1, 2,  466},
        /* 702*/ {37},
        /* 703*/ {1, 2,  123},
        /* 704*/ {1, 2,  277},
        /* 705*/ {17},
        /* 706*/ {1, 2,   27},
        /* 707*/ {1, 2,  141},
        /* 708*/ {15},
        /* 709*/ {1, 2,    9},
        /* 710*/ {1, 3,   29},
        /* 711*/ {92},
        /* 712*/ {1, 2,  623},
        /* 713*/ {41},
        /* 714*/ {23},
        /* 715*/ {1, 3,  458},
        /* 716*/ {183},
        /* 717*/ {1, 2,  320},
        /* 718*/ {165},
        /* 719*/ {150},
        /* 720*/ {1, 2,  625},
        /* 721*/ {9},
        /* 722*/ {231},
        /* 723*/ {1, 2,  268},
        /* 724*/ {207},
        /* 725*/ {1, 2,  331},
        /* 726*/ {5},
        /* 727*/ {180},
        /* 728*/ {1, 2,   51},
        /* 729*/ {58},
        /* 730*/ {147},
        /* 731*/ {1, 2,   69},
        /* 732*/ {343},
        /* 733*/ {1, 2,   92},
        /* 734*/ {1, 2,   67},
        /* 735*/ {44},
        /* 736*/ {1, 2,  359},
        /* 737*/ {5},
        /* 738*/ {347},
        /* 739*/ {1, 2,   60},
        /* 740*/ {135},
        /* 741*/ {1, 2,   34},
        /* 742*/ {85},
        /* 743*/ {90},
        /* 744*/ {1, 2,  347},
        /* 745*/ {258},
        /* 746*/ {351},
        /* 747*/ {1, 2,  158},
        /* 748*/ {19},
        /* 749*/ {1, 2,  357},
        /* 750*/ {309},
        /* 751*/ {18},
        /* 752*/ {1, 2,  129},
        /* 753*/ {158},
        /* 754*/ {19},
        /* 755*/ {1, 4,  159},
        /* 756*/ {45},
        /* 757*/ {1, 2,  359},
        /* 758*/ {233},
        /* 759*/ {98},
        /* 760*/ {1, 2,   17},
        /* 761*/ {3},
        /* 762*/ {83},
        /* 763*/ {1, 2,   17},
        /* 764*/ {1, 2,   12},
        /* 765*/ {1, 2,  137},
        /* 766*/ {1, 3,  280},
        /* 767*/ {168},
        /* 768*/ {1, 2,  115},
        /* 769*/ {120},
        /* 770*/ {1, 2,  453},
        /* 771*/ {1, 2,   86},
        /* 772*/ {7},
        /* 773*/ {1, 2,   73},
        /* 774*/ {185},
        /* 775*/ {93},
        /* 776*/ {1, 2,   51},
        /* 777*/ {29},
        /* 778*/ {375},
        /* 779*/ {1, 2,  456},
        /* 780*/ {13},
        /* 781*/ {1, 2,  209},
        /* 782*/ {329},
        /* 783*/ {68},
        /* 784*/ {1, 2,   59},
        /* 785*/ {92},
        /* 786*/ {1, 2,  118},
        /* 787*/ {1, 2,  189},
        /* 788*/ {1, 2,  375},
        /* 789*/ {1, 2,    5},
        /* 790*/ {1, 2,  111},
        /* 791*/ {30},
        /* 792*/ {1, 2,  403},
        /* 793*/ {253},
        /* 794*/ {143},
        /* 795*/ {1, 2,  137},
        /* 796*/ {1, 2,   36},
        /* 797*/ {1, 2,  193},
        /* 798*/ {53},
        /* 799*/ {25},
        /* 800*/ {1, 2,  463},
        /* 801*/ {217},
        /* 802*/ {1, 2,  102},
        /* 803*/ {1, 2,  208},
        /* 804*/ {75},
        /* 805*/ {1, 2,  453},
        /* 806*/ {21},
        /* 807*/ {7},
        /* 808*/ {1, 3,  175},
        /* 809*/ {15},
        /* 810*/ {159},
        /* 811*/ {1, 2,   18},
        /* 812*/ {29},
        /* 813*/ {1, 2,  802},
        /* 814*/ {21},
        /* 815*/ {333},
        /* 816*/ {1, 3,   51},
        /* 817*/ {52},
        /* 818*/ {119},
        /* 819*/ {1, 2,  149},
        /* 820*/ {123},
        /* 821*/ {1, 2,  177},
        /* 822*/ {17},
        /* 823*/ {9},
        /* 824*/ {1, 2,  495},
        /* 825*/ {38},
        /* 826*/ {255},
        /* 827*/ {1, 2,  189},
        /* 828*/ {189},
        /* 829*/ {1, 2,  560},
        /* 830*/ {1, 2,  241},
        /* 831*/ {49},
        /* 832*/ {1, 2,   39},
        /* 833*/ {149},
        /* 834*/ {15},
        /* 835*/ {1, 2,  350},
        /* 836*/ {1, 2,  606},
        /* 837*/ {1, 2,  365},
        /* 838*/ {61},
        /* 839*/ {54},
        /* 840*/ {1, 2,  341},
        /* 841*/ {144},
        /* 842*/ {47},
        /* 843*/ {1, 2,  322},
        /* 844*/ {105},
        /* 845*/ {2},
        /* 846*/ {105},
        /* 847*/ {136},
        /* 848*/ {1, 2,  225},
        /* 849*/ {253},
        /* 850*/ {111},
        /* 851*/ {1, 2,  442},
        /* 852*/ {159},
        /* 853*/ {1, 2,  461},
        /* 854*/ {1, 2,   79},
        /* 855*/ {29},
        /* 856*/ {1, 2,  842},
        /* 857*/ {119},
        /* 858*/ {207},
        /* 859*/ {1, 2,  594},
        /* 860*/ {35},
        /* 861*/ {14},
        /* 862*/ {349},
        /* 863*/ {1, 2,   90},
        /* 864*/ {1, 2,  607},
        /* 865*/ {1},
        /* 866*/ {75},
        /* 867*/ {1, 2,  380},
        /* 868*/ {145},
        /* 869*/ {1, 2,   82},
        /* 870*/ {301},
        /* 871*/ {378},
        /* 872*/ {1, 2,  691},
        /* 873*/ {352},
        /* 874*/ {1, 2,  110},
        /* 875*/ {1, 2,   66},
        /* 876*/ {149},
        /* 877*/ {1, 2,  140},
        /* 878*/ {1, 2,  343},
        /* 879*/ {11},
        /* 880*/ {1, 3,  221},
        /* 881*/ {78},
        /* 882*/ {99},
        /* 883*/ {1, 2,  488},
        /* 884*/ {173},
        /* 885*/ {1, 2,  707},
        /* 886*/ {1, 2,  227},
        /* 887*/ {147},
        /* 888*/ {1, 2,   97},
        /* 889*/ {127},
        /* 890*/ {183},
        /* 891*/ {1, 2,  364},
        /* 892*/ {31},
        /* 893*/ {1, 2,   13},
        /* 894*/ {173},
        /* 895*/ {12},
        /* 896*/ {1, 2,   19},
        /* 897*/ {113},
        /* 898*/ {207},
        /* 899*/ {1, 3,  898},
        /* 900*/ {1},
        /* 901*/ {1, 2,  581},
        /* 902*/ {21},
        /* 903*/ {35},
        /* 904*/ {1, 3,   60},
        /* 905*/ {117},
        /* 906*/ {123},
        /* 907*/ {1, 3,   26},
        /* 908*/ {143},
        /* 909*/ {1, 3,  168},
        /* 910*/ {1, 2,  357},
        /* 911*/ {204},
        /* 912*/ {1, 2,  569},
        /* 913*/ {91},
        /* 914*/ {1, 2,    4},
        /* 915*/ {1, 2,   89},
        /* 916*/ {183},
        /* 917*/ {1, 2,   22},
        /* 918*/ {77},
        /* 919*/ {36},
        /* 920*/ {1, 3,  517},
        /* 921*/ {221},
        /* 922*/ {1, 2,   24},
        /* 923*/ {1, 2,  142},
        /* 924*/ {31},
        /* 925*/ {1, 2,  308},
        /* 926*/ {365},
        /* 927*/ {403},
        /* 928*/ {1, 2,   33},
        /* 929*/ {1, 2,   36},
        /* 930*/ {31},
        /* 931*/ {1, 2,   72},
        /* 932*/ {177},
        /* 933*/ {1, 2,  527},
        /* 934*/ {1, 3,  800},
        /* 935*/ {417},
        /* 936*/ {1, 3,   27},
        /* 937*/ {217},
        /* 938*/ {207},
        /* 939*/ {1, 2,  142},
        /* 940*/ {1, 2,  204},
        /* 941*/ {1, 2,  573},
        /* 942*/ {45},
        /* 943*/ {24},
        /* 944*/ {1, 2,  487},
        /* 945*/ {77},
        /* 946*/ {1, 3,   83},
        /* 947*/ {1, 2,  400},
        /* 948*/ {189},
        /* 949*/ {1, 2,  417},
        /* 950*/ {1, 2,  859},
        /* 951*/ {260},
        /* 952*/ {1, 3,  311},
        /* 953*/ {168},
        /* 954*/ {131},
        /* 955*/ {1, 2,  606},
        /* 956*/ {305},
        /* 957*/ {1, 2,  158},
        /* 958*/ {1, 2,  191},
        /* 959*/ {143},
        /* 960*/ {1, 2,  491},
        /* 961*/ {18},
        /* 962*/ {1, 2,   18},
        /* 963*/ {1, 2,  145},
        /* 964*/ {103},
        /* 965*/ {1, 2,  213},
        /* 966*/ {201},
        /* 967*/ {36},
        /* 968*/ {1, 2,   21},
        /* 969*/ {31},
        /* 970*/ {1, 2,  260},
        /* 971*/ {1, 2,    6},
        /* 972*/ {7},
        /* 973*/ {1, 2,  113},
        /* 974*/ {1, 2,  211},
        /* 975*/ {19},
        /* 976*/ {1, 2,  285},
        /* 977*/ {15},
        /* 978*/ {1, 2,  376},
        /* 979*/ {178},
        /* 980*/ {1, 2,  316},
        /* 981*/ {1, 2,  383},
        /* 982*/ {177},
        /* 983*/ {230},
        /* 984*/ {1, 2,  349},
        /* 985*/ {222},
        /* 986*/ {3},
        /* 987*/ {1, 3,  142},
        /* 988*/ {121},
        /* 989*/ {1, 2,  105},
        /* 990*/ {161},
        /* 991*/ {39},
        /* 992*/ {1, 2,  585},
        /* 993*/ {62},
        /* 994*/ {223},
        /* 995*/ {1, 3,  242},
        /* 996*/ {65},
        /* 997*/ {1, 2,  453},
        /* 998*/ {101},
        /* 999*/ {59},
        /*1000*/ {1, 3,   68},
        /*1001*/ {17},
        /*1002*/ {1, 2,  266},
        /*1003*/ {1, 2,  410},
        /*1004*/ {1, 2,   96},
        /*1005*/ {1, 2,   41},
        /*1006*/ {1, 2,   63},
        /*1007*/ {75},
        /*1008*/ {1, 2,  703},
        /*1009*/ {55},
        /*1010*/ {99},
        /*1011*/ {1, 2,   17},
        /*1012*/ {115},
        /*1013*/ {1, 2,  180},
        /*1014*/ {385},
        /*1015*/ {186},
        /*1016*/ {1, 2,   49},
        /*1017*/ {1, 2,  746},
        /*1018*/ {1, 2,   27},
        /*1019*/ {1, 2,   96},
        /*1020*/ {135},
        /*1021*/ {1, 2,    5},
        /*1022*/ {317},
        /*1023*/ {7},
        /*1024*/ {1, 2,  515},
        /*1025*/ {294},
        /*1026*/ {35},
        /*1027*/ {1, 2,  378},
        /*1028*/ {119},
        /*1029*/ {98},
        /*1030*/ {93},
        /*1031*/ {68},
        /*1032*/ {1, 2,  901},
        /*1033*/ {108},
        /*1034*/ {75},
        /*1035*/ {1, 2,   76},
        /*1036*/ {411},
        /*1037*/ {1, 2,  981},
        /*1038*/ {1, 2,   41},
        /*1039*/ {21},
        /*1040*/ {1, 2,  429},
        /*1041*/ {412},
        /*1042*/ {439},
        /*1043*/ {1, 3,  869},
        /*1044*/ {41},
        /*1045*/ {1, 2,  378},
        /*1046*/ {1, 2,   39},
        /*1047*/ {10},
        /*1048*/ {1, 3,  172},
        /*1049*/ {141},
        /*1050*/ {159},
        /*1051*/ {1, 3,  354},
        /*1052*/ {291},
        /*1053*/ {1, 2,  290},
        /*1054*/ {105},
        /*1055*/ {24},
        /*1056*/ {1, 2,   11},
        /*1057*/ {198},
        /*1058*/ {27},
        /*1059*/ {1, 3,    6},
        /*1060*/ {439},
        /*1061*/ {1, 2,  166},
        /*1062*/ {49},
        /*1063*/ {168},
        /*1064*/ {1, 2,  946},
        /*1065*/ {463},
        /*1066*/ {1, 2,  258},
        /*1067*/ {1, 2,   69},
        /*1068*/ {1, 2,  223},
        /*1069*/ {1, 2,  146},
        /*1070*/ {1, 3,   94},
        /*1071*/ {7},
        /*1072*/ {1, 2,  443},
        /*1073*/ {1, 3,  235},
        /*1074*/ {1, 2,  395},
        /*1075*/ {1, 2,   92},
        /*1076*/ {1, 2,   22},
        /*1077*/ {1, 2,  521},
        /*1078*/ {361},
        /*1079*/ {230},
        /*1080*/ {1, 2,  151},
        /*1081*/ {24},
        /*1082*/ {407},
        /*1083*/ {1, 2,  538},
        /*1084*/ {189},
        /*1085*/ {62},
        /*1086*/ {189},
        /*1087*/ {112},
        /*1088*/ {1, 2,  531},
        /*1089*/ {91},
        /*1090*/ {79},
        /*1091*/ {1, 2,   82},
        /*1092*/ {23},
        /*1093*/ {1, 2,  173},
        /*1094*/ {57},
        /*1095*/ {139},
        /*1096*/ {1, 2,  351},
        /*1097*/ {14},
        /*1098*/ {83},
        /*1099*/ {1, 2,  464},
        /*1100*/ {35},
        /*1101*/ {1, 2,   14},
        /*1102*/ {117},
        /*1103*/ {65},
        /*1104*/ {1, 2,  259},
        /*1105*/ {21},
        /*1106*/ {195},
        /*1107*/ {1, 2,  176},
        /*1108*/ {327},
        /*1109*/ {1, 2,  501},
        /*1110*/ {417},
        /*1111*/ {13},
        /*1112*/ {1, 2, 1045},
        /*1113*/ {107},
        /*1114*/ {1, 2,  345},
        /*1115*/ {1, 2,  268},
        /*1116*/ {59},
        /*1117*/ {1, 2,  149},
        /*1118*/ {1, 2,  475},
        /*1119*/ {283},
        /*1120*/ {1, 3,  386},
        /*1121*/ {62},
        /*1122*/ {427},
        /*1123*/ {1, 2,  641},
        /*1124*/ {1, 2,  156},
        /*1125*/ {1, 2,  206},
        /*1126*/ {105},
        /*1127*/ {27},
        /*1128*/ {1, 3,    7},
        /*1129*/ {103},
        /*1130*/ {551},
        /*1131*/ {1, 2,  188},
        /*1132*/ {1, 2,   20},
        /*1133*/ {1, 2,  667},
        /*1134*/ {129},
        /*1135*/ {9},
        /*1136*/ {1, 2,  177},
        /*1137*/ {277},
        /*1138*/ {31},
        /*1139*/ {1, 2,   45},
        /*1140*/ {141},
        /*1141*/ {1, 2,  134},
        /*1142*/ {357},
        /*1143*/ {1, 2,    7},
        /*1144*/ {1, 2,  431},
        /*1145*/ {227},
        /*1146*/ {131},
        /*1147*/ {1, 2,  390},
        /*1148*/ {23},
        /*1149*/ {1, 2,  221},
        /*1150*/ {1, 2,   63},
        /*1151*/ {90},
        /*1152*/ {1, 2,  971},
        /*1153*/ {241},
        /*1154*/ {75},
        /*1155*/ {1, 2,   94},
        /*1156*/ {307},
        /*1157*/ {1, 2,  105},
        /*1158*/ {245},
        /*1159*/ {66},
        /*1160*/ {1, 2,  889},
        /*1161*/ {365},
        /*1162*/ {1, 2,  288},
        /*1163*/ {1, 2,   33},
        /*1164*/ {19},
        /*1165*/ {1, 2,  494},
        /*1166*/ {189},
        /*1167*/ {133},
        /*1168*/ {1, 2,  473},
        /*1169*/ {114},
        /*1170*/ {27},
        /*1171*/ {1, 2,  396},
        /*1172*/ {1, 2,  426},
        /*1173*/ {1, 2,  673},
        /*1174*/ {133},
        /*1175*/ {476},
        /*1176*/ {1, 2,   19},
        /*1177*/ {16},
        /*1178*/ {375},
        /*1179*/ {1, 2,  640},
        /*1180*/ {25},
        /*1181*/ {1, 2,   82},
        /*1182*/ {77},
        /*1183*/ {87},
        /*1184*/ {1, 2, 1177},
        /*1185*/ {134},
        /*1186*/ {171},
        /*1187*/ {1, 2,  438},
        /*1188*/ {75},
        /*1189*/ {1, 2,  102},
        /*1190*/ {233},
        /*1191*/ {196},
        /*1192*/ {1, 3,  831},
        /*1193*/ {173},
        /*1194*/ {1, 2,  317},
        /*1195*/ {1, 2,  293},
        /*1196*/ {281},
        /*1197*/ {1, 2,  269},
        /*1198*/ {405},
        /*1199*/ {114},
        /*1200*/ {1, 3,  739},
        /*1201*/ {171},
        /*1202*/ {287},
        /*1203*/ {1, 2,  226},
        /*1204*/ {43},
        /*1205*/ {1, 2,    4},
        /*1206*/ {513},
        /*1207*/ {273},
        /*1208*/ {1, 2,  915},
        /*1209*/ {118},
        /*1210*/ {243},
        /*1211*/ {1, 2,  373},
        /*1212*/ {203},
        /*1213*/ {1, 2,  245},
        /*1214*/ {257},
        /*1215*/ {302},
        /*1216*/ {1, 2,  155},
        /*1217*/ {393},
        /*1218*/ {91},
        /*1219*/ {1, 2,  225},
        /*1220*/ {413},
        /*1221*/ {1, 2,  101},
        /*1222*/ {1, 2,  215},
        /*1223*/ {255},
        /*1224*/ {1, 2,  157},
        /*1225*/ {234},
        /*1226*/ {167},
        /*1227*/ {1, 2,  361},
        /*1228*/ {27},
        /*1229*/ {1, 2,  627},
        /*1230*/ {433},
        /*1231*/ {105},
        /*1232*/ {1, 2,  225},
        /*1233*/ {151},
        /*1234*/ {427},
        /*1235*/ {1, 2,  642},
        /*1236*/ {49},
        /*1237*/ {1, 2,  150},
        /*1238*/ {153},
        /*1239*/ {4},
        /*1240*/ {1, 2,  567},
        /*1241*/ {54},
        /*1242*/ {203},
        /*1243*/ {1, 2,  758},
        /*1244*/ {1, 2,  126},
        /*1245*/ {1, 2,  212},
        /*1246*/ {25},
        /*1247*/ {14},
        /*1248*/ {1, 2, 1201},
        /*1249*/ {187},
        /*1250*/ {1, 2,   37},
        /*1251*/ {1, 2, 1004},
        /*1252*/ {97},
        /*1253*/ {1, 2,  141},
        /*1254*/ {1, 2,  697},
        /*1255*/ {589},
        /*1256*/ {1, 2,  171},
        /*1257*/ {289},
        /*1258*/ {1, 2,  503},
        /*1259*/ {1, 2,  192},
        /*1260*/ {21},
        /*1261*/ {1, 2,   14},
        /*1262*/ {1, 2,  793},
        /*1263*/ {77},
        /*1264*/ {1, 2,  285},
        /*1265*/ {119},
        /*1266*/ {7},
        /*1267*/ {1, 2,  197},
        /*1268*/ {345},
        /*1269*/ {1, 2,  484},
        /*1270*/ {333},
        /*1271*/ {17},
        /*1272*/ {1, 2,  223},
        /*1273*/ {168},
        /*1274*/ {1, 2,  486},
        /*1275*/ {1, 2,   25},
        /*1276*/ {217},
        /*1277*/ {1, 2,  451},
        /*1278*/ {189},
        /*1279*/ {216},
        /*1280*/ {1, 2,  843},
        /*1281*/ {229},
        /*1282*/ {231},
        /*1283*/ {1, 2,   70},
        /*1284*/ {223},
        /*1285*/ {1, 2,  564},
        /*1286*/ {153},
        /*1287*/ {470},
        /*1288*/ {1, 2,  215},
        /*1289*/ {99},
        /*1290*/ {1, 2,  422},
        /*1291*/ {1, 2,  245},
        /*1292*/ {1, 2,   78},
        /*1293*/ {1, 2,   26},
        /*1294*/ {201},
        /*1295*/ {38},
        /*1296*/ {1, 2,  379},
        /*1297*/ {198},
        /*1298*/ {399},
        /*1299*/ {1, 2,  172},
        /*1300*/ {75},
        /*1301*/ {1, 2,  297},
        /*1302*/ {77},
        /*1303*/ {1, 2,  306},
        /*1304*/ {1, 3,  574},
        /*1305*/ {326},
        /*1306*/ {39},
        /*1307*/ {1, 2,  157},
        /*1308*/ {495},
        /*1309*/ {1, 2,  789},
        /*1310*/ {333},
        /*1311*/ {476},
        /*1312*/ {1, 2, 1265},
        /*1313*/ {164},
        /*1314*/ {19},
        /*1315*/ {1, 2,  270},
        /*1316*/ {1, 2,   12},
        /*1317*/ {1, 2,  254},
        /*1318*/ {1, 3,   94},
        /*1319*/ {129},
        /*1320*/ {1, 2,  835},
        /*1321*/ {52},
        /*1322*/ {1, 2,  538},
        /*1323*/ {1, 2, 1198},
        /*1324*/ {337},
        /*1325*/ {1, 2,  526},
        /*1326*/ {397},
        /*1327*/ {277},
        /*1328*/ {1, 2,  507},
        /*1329*/ {73},
        /*1330*/ {1, 2,  609},
        /*1331*/ {1, 2,  289},
        /*1332*/ {95},
        /*1333*/ {1, 2,  276},
        /*1334*/ {617},
        /*1335*/ {392},
        /*1336*/ {1, 2,  815},
        /*1337*/ {75},
        /*1338*/ {315},
        /*1339*/ {1, 2,  284},
        /*1340*/ {125},
        /*1341*/ {1, 2,   53},
        /*1342*/ {1, 2,  477},
        /*1343*/ {348},
        /*1344*/ {1, 2,  469},
        /*1345*/ {553},
        /*1346*/ {1, 2,   57},
        /*1347*/ {1, 2,   61},
        /*1348*/ {553},
        /*1349*/ {1, 2,   40},
        /*1350*/ {237},
        /*1351*/ {39},
        /*1352*/ {1, 2,  583},
        /*1353*/ {371},
        /*1354*/ {255},
        /*1355*/ {1, 2,  117},
        /*1356*/ {131},
        /*1357*/ {1, 2,  495},
        /*1358*/ {117},
        /*1359*/ {98},
        /*1360*/ {1, 2,  393},
        /*1361*/ {56},
        /*1362*/ {655},
        /*1363*/ {1, 2,  852},
        /*1364*/ {239},
        /*1365*/ {1, 2,  329},
        /*1366*/ {1},
        /*1367*/ {134},
        /*1368*/ {1, 2,   41},
        /*1369*/ {88},
        /*1370*/ {1, 2,  108},
        /*1371*/ {1, 2,  145},
        /*1372*/ {181},
        /*1373*/ {1, 2,  613},
        /*1374*/ {609},
        /*1375*/ {52},
        /*1376*/ {1, 2, 1201},
        /*1377*/ {100},
        /*1378*/ {1, 2,  362},
        /*1379*/ {1, 2,  400},
        /*1380*/ {183},
        /*1381*/ {1, 2,   56},
        /*1382*/ {1, 3,   58},
        /*1383*/ {130},
        /*1384*/ {1, 2, 1131},
        /*1385*/ {12},
        /*1386*/ {219},
        /*1387*/ {1, 2,   33},
        /*1388*/ {11},
        /*1389*/ {1, 2,   41},
        /*1390*/ {129},
        /*1391*/ {3},
        /*1392*/ {1, 2,  485},
        /*1393*/ {300},
        /*1394*/ {1, 2,   30},
        /*1395*/ {1, 2,  233},
        /*1396*/ {97},
        /*1397*/ {1, 2,  397},
        /*1398*/ {601},
        /*1399*/ {55},
        /*1400*/ {1, 2,  493},
        /*1401*/ {92},
        /*1402*/ {127},
        /*1403*/ {1, 2,  717},
        /*1404*/ {81},
        /*1405*/ {1, 2,  558},
        /*1406*/ {1, 2,   13},
        /*1407*/ {47},
        /*1408*/ {1, 3,   45},
        /*1409*/ {194},
        /*1410*/ {383},
        /*1411*/ {1, 2,  200},
        /*1412*/ {125},
        /*1413*/ {1, 2,  101},
        /*1414*/ {429},
        /*1415*/ {282},
        /*1416*/ {1, 3,  231},
        /*1417*/ {342},
        /*1418*/ {1, 2,  283},
        /*1419*/ {1, 2,  592},
        /*1420*/ {33},
        /*1421*/ {1, 2,   30},
        /*1422*/ {49},
        /*1423*/ {15},
        /*1424*/ {1, 2,  507},
        /*1425*/ {28},
        /*1426*/ {103},
        /*1427*/ {1, 2,  900},
        /*1428*/ {27},
        /*1429*/ {1, 2,  149},
        /*1430*/ {33},
        /*1431*/ {17},
        /*1432*/ {1, 2,  251},
        /*1433*/ {387},
        /*1434*/ {363},
        /*1435*/ {1, 2,  126},
        /*1436*/ {83},
        /*1437*/ {1, 2,  545},
        /*1438*/ {357},
        /*1439*/ {1, 2,  535},
        /*1440*/ {1, 3, 1023},
        /*1441*/ {322},
        /*1442*/ {395},
        /*1443*/ {1, 2,  413},
        /*1444*/ {595},
        /*1445*/ {1, 2,  214},
        /*1446*/ {421},
        /*1447*/ {195},
        /*1448*/ {1, 3,  212},
        /*1449*/ {13},
        /*1450*/ {1, 2,  155},
        /*1451*/ {1, 2,  193},
        /*1452*/ {315},
        /*1453*/ {1, 2,  348},
        /*1454*/ {297},
        /*1455*/ {52},
        /*1456*/ {1, 2, 1011},
        /*1457*/ {314},
        /*1458*/ {243},
        /*1459*/ {1, 2, 1032},
        /*1460*/ {185},
        /*1461*/ {1, 2,  446},
        /*1462*/ {1, 2,  165},
        /*1463*/ {575},
        /*1464*/ {1, 2,  275},
        /*1465*/ {39},
        /*1466*/ {311},
        /*1467*/ {1, 2,  113},
        /*1468*/ {181},
        /*1469*/ {1, 2,  775},
        /*1470*/ {49},
        /*1471*/ {25},
        /*1472*/ {1, 2,  613},
        /*1473*/ {77},
        /*1474*/ {1, 2,   59},
        /*1475*/ {1, 2,  208},
        /*1476*/ {21},
        /*1477*/ {1, 2, 1325},
        /*1478*/ {69},
        /*1479*/ {49},
        /*1480*/ {1, 2,  285},
        /*1481*/ {32},
        /*1482*/ {411},
        /*1483*/ {1, 2, 1077},
        /*1484*/ {1, 2,   61},
        /*1485*/ {1, 2,  655},
        /*1486*/ {85},
        /*1487*/ {140},
        /*1488*/ {1, 2,  463},
        /*1489*/ {252},
        /*1490*/ {279},
        /*1491*/ {1, 2,  544},
        /*1492*/ {307},
        /*1493*/ {1, 2,  378},
        /*1494*/ {1, 2,  731},
        /*1495*/ {94},
        /*1496*/ {1, 2,  181},
        /*1497*/ {49},
        /*1498*/ {1, 2,  416},
        /*1499*/ {1, 2,  477},
        /*1500*/ {25},
        /*1501*/ {1, 2,   60},
        /*1502*/ {1, 2,  111},
        /*1503*/ {80},
        /*1504*/ {1, 2,  207},
        /*1505*/ {246},
        /*1506*/ {1, 2,  533},
        /*1507*/ {1, 2,  900},
        /*1508*/ {599},
        /*1509*/ {1, 2,  209},
        /*1510*/ {189},
        /*1511*/ {278},
        /*1512*/ {1, 2, 1121},
        /*1513*/ {399},
        /*1514*/ {299},
        /*1515*/ {1, 2,  712},
        /*1516*/ {277},
        /*1517*/ {1, 2,  568},
        /*1518*/ {69},
        /*1519*/ {220},
        /*1520*/ {1, 2,   81},
        /*1521*/ {229},
        /*1522*/ {1, 2,   47},
        /*1523*/ {1, 2,  240},
        /*1524*/ {27},
        /*1525*/ {1, 2,  102},
        /*1526*/ {473},
        /*1527*/ {373},
        /*1528*/ {1, 2,  923},
        /*1529*/ {60},
        /*1530*/ {207},
        /*1531*/ {1, 2, 1125},
        /*1532*/ {1, 2,  466},
        /*1533*/ {1, 2,  763},
        /*1534*/ {225},
        /*1535*/ {404},
        /*1536*/ {1, 2,  881},
        /*1537*/ {46},
        /*1538*/ {1, 2,    6},
        /*1539*/ {1, 2,   80},
        /*1540*/ {75},
        /*1541*/ {1, 2,    4},
        /*1542*/ {365},
        /*1543*/ {445},
        /*1544*/ {1, 2,   99},
        /*1545*/ {44},
        /*1546*/ {1, 2,  810},
        /*1547*/ {1, 2,  493},
        /*1548*/ {63},
        /*1549*/ {1, 2,  426},
        /*1550*/ {189},
        /*1551*/ {557},
        /*1552*/ {1, 2,   83},
        /*1553*/ {252},
        /*1554*/ {99},
        /*1555*/ {1, 2,  254},
        /*1556*/ {65},
        /*1557*/ {1, 2,   20},
        /*1558*/ {9},
        /*1559*/ {119},
        /*1560*/ {1, 2,   11},
        /*1561*/ {339},
        /*1562*/ {95},
        /*1563*/ {1, 2,   41},
        /*1564*/ {7},
        /*1565*/ {1, 2,   18},
        /*1566*/ {77},
        /*1567*/ {127},
        /*1568*/ {1, 2,  133},
        /*1569*/ {319},
        /*1570*/ {667},
        /*1571*/ {1, 2,   21},
        /*1572*/ {501},
        /*1573*/ {1, 2,  461},
        /*1574*/ {1, 2,  331},
        /*1575*/ {17},
        /*1576*/ {1, 2,  147},
        /*1577*/ {341},
        /*1578*/ {731},
        /*1579*/ {1, 2,  374},
        /*1580*/ {647},
        /*1581*/ {1, 2,  160},
        /*1582*/ {121},
        /*1583*/ {20},
        /*1584*/ {1, 2,  895},
        /*1585*/ {574},
        /*1586*/ {399},
        /*1587*/ {1, 2,  433},
        /*1588*/ {85},
        /*1589*/ {1, 2,  882},
        /*1590*/ {169},
        /*1591*/ {15},
        /*1592*/ {1, 2,  223},
        /*1593*/ {568},
        /*1594*/ {1, 2,  971},
        /*1595*/ {1, 2,   18},
        /*1596*/ {3},
        /*1597*/ {1, 2,   42},
        /*1598*/ {1, 2,  385},
        /*1599*/ {643},
        /*1600*/ {1, 2,   57},
        /*1601*/ {548},
        /*1602*/ {783},
        /*1603*/ {1, 2,  917},
        /*1604*/ {317},
        /*1605*/ {1, 2,   46},
        /*1606*/ {153},
        /*1607*/ {87},
        /*1608*/ {1, 2,  271},
        /*1609*/ {231},
        /*1610*/ {1, 2,  250},
        /*1611*/ {1, 2,   58},
        /*1612*/ {771},
        /*1613*/ {1, 2,   48},
        /*1614*/ {1, 2, 1489},
        /*1615*/ {103},
        /*1616*/ {1, 2,  139},
        /*1617*/ {182},
        /*1618*/ {211},
        /*1619*/ {1, 2,  289},
        /*1620*/ {27},
        /*1621*/ {1, 2, 1577},
        /*1622*/ {1, 2, 1341},
        /*1623*/ {17},
        /*1624*/ {1, 2, 1095},
        /*1625*/ {69},
        /*1626*/ {1, 2,  191},
        /*1627*/ {1, 2,  189},
        /*1628*/ {603},
        /*1629*/ {1, 2,  397},
        /*1630*/ {741},
        /*1631*/ {668},
        /*1632*/ {1, 2,  211},
        /*1633*/ {147},
        /*1634*/ {227},
        /*1635*/ {1, 2,  113},
        /*1636*/ {37},
        /*1637*/ {1, 2,  234},
        /*1638*/ {173},
        /*1639*/ {427},
        /*1640*/ {1, 2,  715},
        /*1641*/ {287},
        /*1642*/ {231},
        /*1643*/ {1, 2,  760},
        /*1644*/ {1, 2,  236},
        /*1645*/ {1, 2,  938},
        /*1646*/ {1, 2,  435},
        /*1647*/ {310},
        /*1648*/ {1, 2,   77},
        /*1649*/ {434},
        /*1650*/ {579},
        /*1651*/ {1, 2,  873},
        /*1652*/ {45},
        /*1653*/ {1, 2,   82},
        /*1654*/ {1, 3,  201},
        /*1655*/ {53},
        /*1656*/ {1, 2,  361},
        /*1657*/ {16},
        /*1658*/ {1, 2,  552},
        /*1659*/ {1, 2,  374},
        /*1660*/ {37},
        /*1661*/ {1, 2,   84},
        /*1662*/ {1, 3,  958},
        /*1663*/ {99},
        /*1664*/ {1, 2,  399},
        /*1665*/ {176},
        /*1666*/ {271},
        /*1667*/ {1, 2, 1020},
        /*1668*/ {459},
        /*1669*/ {1, 2,  425},
        /*1670*/ {1, 2,   19},
        /*1671*/ {202},
        /*1672*/ {1, 2,  405},
        /*1673*/ {90},
        /*1674*/ {755},
        /*1675*/ {1, 2,   77},
        /*1676*/ {363},
        /*1677*/ {1, 2,  844},
        /*1678*/ {129},
        /*1679*/ {20},
        /*1680*/ {1, 2, 1549},
        /*1681*/ {135},
        /*1682*/ {1, 2,  354},
        /*1683*/ {1, 2, 1348},
        /*1684*/ {1, 2,  474},
        /*1685*/ {1, 2,  493},
        /*1686*/ {1, 2,  887},
        /*1687*/ {31},
        /*1688*/ {1, 2,  921},
        /*1689*/ {758},
        /*1690*/ {1, 2,  200},
        /*1691*/ {1, 2,  556},
        /*1692*/ {359},
        /*1693*/ {1, 2,  137},
        /*1694*/ {501},
        /*1695*/ {29},
        /*1696*/ {1, 2,  737},
        /*1697*/ {201},
        /*1698*/ {459},
        /*1699*/ {1, 2,  405},
        /*1700*/ {225},
        /*1701*/ {1, 2,  568},
        /*1702*/ {1, 2,  245},
        /*1703*/ {161},
        /*1704*/ {1, 3,   55},
        /*1705*/ {52},
        /*1706*/ {1, 2,  574},
        /*1707*/ {1, 2,  221},
        /*1708*/ {93},
        /*1709*/ {1, 2,  201},
        /*1710*/ {201},
        /*1711*/ {178},
        /*1712*/ {1, 2,  445},
        /*1713*/ {250},
        /*1714*/ {1, 2,  191},
        /*1715*/ {1, 2,  612},
        /*1716*/ {221},
        /*1717*/ {1, 2,  881},
        /*1718*/ {1, 2,  535},
        /*1719*/ {113},
        /*1720*/ {1, 2,  525},
        /*1721*/ {300},
        /*1722*/ {39},
        /*1723*/ {1, 2,  137},
        /*1724*/ {261},
        /*1725*/ {1, 2,  623},
        /*1726*/ {753},
        /*1727*/ {1, 2,   22},
        /*1728*/ {1, 2,  545},
        /*1729*/ {94},
        /*1730*/ {1, 2,  316},
        /*1731*/ {1, 2,  925},
        /*1732*/ {1, 2,   75},
        /*1733*/ {1, 2,  285},
        /*1734*/ {461},
        /*1735*/ {418},
        /*1736*/ {1, 2,  435},
        /*1737*/ {403},
        /*1738*/ {267},
        /*1739*/ {1, 2,  409},
        /*1740*/ {259},
        /*1741*/ {1, 3,  226},
        /*1742*/ {869},
        /*1743*/ {173},
        /*1744*/ {1, 2,   35},
        /*1745*/ {369},
        /*1746*/ {255},
        /*1747*/ {1, 2,   93},
        /*1748*/ {567},
        /*1749*/ {1, 2,  236},
        /*1750*/ {457},
        /*1751*/ {482},
        /*1752*/ {1, 2,  559},
        /*1753*/ {775},
        /*1754*/ {1, 2,   75},
        /*1755*/ {1, 2,  316},
        /*1756*/ {99},
        /*1757*/ {1, 2,   21},
        /*1758*/ {1, 2,  221},
        /*1759*/ {165},
        /*1760*/ {1, 3, 1612},
        /*1761*/ {1, 2,  131},
        /*1762*/ {1, 2,  318},
        /*1763*/ {1, 2,  345},
        /*1764*/ {105},
        /*1765*/ {1, 2,  165},
        /*1766*/ {1, 2, 1029},
        /*1767*/ {250},
        /*1768*/ {1, 2, 1403},
        /*1769*/ {327},
        /*1770*/ {279},
        /*1771*/ {1, 2,  297},
        /*1772*/ {371},
        /*1773*/ {1, 2,   50},
        /*1774*/ {117},
        /*1775*/ {486},
        /*1776*/ {1, 2,   17},
        /*1777*/ {217},
        /*1778*/ {635},
        /*1779*/ {1, 3, 1068},
        /*1780*/ {457},
        /*1781*/ {1, 2,   18},
        /*1782*/ {57},
        /*1783*/ {439},
        /*1784*/ {1, 2, 1489},
        /*1785*/ {214},
        /*1786*/ {1, 2,  614},
        /*1787*/ {1, 2,  457},
        /*1788*/ {819},
        /*1789*/ {1, 2,   80},
        /*1790*/ {593},
        /*1791*/ {190},
        /*1792*/ {1, 2,  341},
        /*1793*/ {114},
        /*1794*/ {1, 2,   95},
        /*1795*/ {1, 2,   89},
        /*1796*/ {1, 2,  829},
        /*1797*/ {1, 2,   80},
        /*1798*/ {69},
        /*1799*/ {312},
        /*1800*/ {1, 2, 1013},
        /*1801*/ {502},
        /*1802*/ {843},
        /*1803*/ {1, 2,  248},
        /*1804*/ {747},
        /*1805*/ {1, 2,   82},
        /*1806*/ {101},
        /*1807*/ {123},
        /*1808*/ {1, 2,   25},
        /*1809*/ {521},
        /*1810*/ {171},
        /*1811*/ {1, 2,  117},
        /*1812*/ {1, 2,  758},
        /*1813*/ {1, 3,  884},
        /*1814*/ {545},
        /*1815*/ {163},
        /*1816*/ {1, 2,  887},
        /*1817*/ {479},
        /*1818*/ {495},
        /*1819*/ {1, 2,  116},
        /*1820*/ {11},
        /*1821*/ {1, 2,  326},
        /*1822*/ {1, 3,   31},
        /*1823*/ {684},
        /*1824*/ {1, 2,  821},
        /*1825*/ {9},
        /*1826*/ {1, 2,  298},
        /*1827*/ {1, 2,  154},
        /*1828*/ {273},
        /*1829*/ {1, 2,  162},
        /*1830*/ {381},
        /*1831*/ {51},
        /*1832*/ {1, 3, 1078},
        /*1833*/ {518},
        /*1834*/ {1, 2,  210},
        /*1835*/ {1, 2,  288},
        /*1836*/ {243},
        /*1837*/ {1, 2,  200},
        /*1838*/ {53},
        /*1839*/ {836},
        /*1840*/ {1, 2,  195},
        /*1841*/ {66},
        /*1842*/ {1, 2,  799},
        /*1843*/ {1, 2,  872},
        /*1844*/ {339},
        /*1845*/ {1, 2,  526},
        /*1846*/ {901},
        /*1847*/ {180},
        /*1848*/ {1, 2,  871},
        /*1849*/ {49},
        /*1850*/ {1, 2,   79},
        /*1851*/ {1, 2,  250},
        /*1852*/ {1, 2,  339},
        /*1853*/ {1, 2,  705},
        /*1854*/ {885},
        /*1855*/ {39},
        /*1856*/ {1, 2,  585},
        /*1857*/ {688},
        /*1858*/ {1, 2, 1368},
        /*1859*/ {1, 2,  120},
        /*1860*/ {13},
        /*1861*/ {1, 2,  509},
        /*1862*/ {149},
        /*1863*/ {260},
        /*1864*/ {1, 2, 1379},
        /*1865*/ {53},
        /*1866*/ {11},
        /*1867*/ {1, 2,  117},
        /*1868*/ {1, 2,  250},
        /*1869*/ {1, 2,  617},
        /*1870*/ {121},
        /*1871*/ {261},
        /*1872*/ {1, 3,   60},
        /*1873*/ {199},
        /*1874*/ {1, 2,   70},
        /*1875*/ {1, 2,  412},
        /*1876*/ {1, 2,  122},
        /*1877*/ {1, 2,  796},
        /*1878*/ {253},
        /*1879*/ {174},
        /*1880*/ {1, 2, 1647},
        /*1881*/ {370},
        /*1882*/ {1, 2,  128},
        /*1883*/ {1, 2, 1062},
        /*1884*/ {669},
        /*1885*/ {1, 2,  813},
        /*1886*/ {833},
        /*1887*/ {353},
        /*1888*/ {1, 2,  923},
        /*1889*/ {29},
        /*1890*/ {371},
        /*1891*/ {1, 2, 1766},
        /*1892*/ {1, 3,  497},
        /*1893*/ {1, 2,  461},
        /*1894*/ {1, 3,  215},
        /*1895*/ {873},
        /*1896*/ {1, 2,  451},
        /*1897*/ {1, 2,  324},
        /*1898*/ {1, 2,  613},
        /*1899*/ {1, 2,  485},
        /*1900*/ {235},
        /*1901*/ {1, 2,  330},
        /*1902*/ {733},
        /*1903*/ {778},
        /*1904*/ {1, 2,  337},
        /*1905*/ {344},
        /*1906*/ {931},
        /*1907*/ {1, 2,   45},
        /*1908*/ {945},
        /*1909*/ {1, 2,  225},
        /*1910*/ {1, 3,  365},
        /*1911*/ {67},
        /*1912*/ {1, 2,  599},
        /*1913*/ {462},
        /*1914*/ {1, 2,  544},
        /*1915*/ {1, 2,  473},
        /*1916*/ {1, 2,  502},
        /*1917*/ {1, 2,  485},
        /*1918*/ {477},
        /*1919*/ {105},
        /*1920*/ {1, 2,   67},
        /*1921*/ {468},
        /*1922*/ {1, 2,   36},
        /*1923*/ {1, 4,   40},
        /*1924*/ {327},
        /*1925*/ {1, 2,  576},
        /*1926*/ {357},
        /*1927*/ {25},
        /*1928*/ {1, 2,  763},
        /*1929*/ {31},
        /*1930*/ {1, 2,  155},
        /*1931*/ {1, 2,  648},
        /*1932*/ {277},
        /*1933*/ {1, 2,  971},
        /*1934*/ {413},
        /*1935*/ {103},
        /*1936*/ {1, 2,  117},
        /*1937*/ {231},
        /*1938*/ {747},
        /*1939*/ {1, 2,    5},
        /*1940*/ {113},
        /*1941*/ {1, 2, 1133},
        /*1942*/ {1, 2,  147},
        /*1943*/ {11},
        /*1944*/ {1, 2,  617},
        /*1945*/ {91},
        /*1946*/ {51},
        /*1947*/ {1, 2, 1162},
        /*1948*/ {603},
        /*1949*/ {1, 2,  621},
        /*1950*/ {9},
        /*1951*/ {121},
        /*1952*/ {1, 3,   65},
        /*1953*/ {17},
        /*1954*/ {1, 2, 1226},
        /*1955*/ {1, 2,  109},
        /*1956*/ {279},
        /*1957*/ {1, 2,   17},
        /*1958*/ {89},
        /*1959*/ {371},
        /*1960*/ {1, 2,  939},
        /*1961*/ {771},
        /*1962*/ {99},
        /*1963*/ {1, 2, 1137},
        /*1964*/ {21},
        /*1965*/ {1, 2,  364},
        /*1966*/ {801},
        /*1967*/ {26},
        /*1968*/ {1, 3,  922},
        /*1969*/ {175},
        /*1970*/ {1, 2,  388},
        /*1971*/ {1, 2,  100},
        /*1972*/ {1, 2,  474},
        /*1973*/ {1, 2,  438},
        /*1974*/ {165},
        /*1975*/ {841},
        /*1976*/ {1, 3, 1160},
        /*1977*/ {238},
        /*1978*/ {1, 2,  158},
        /*1979*/ {1, 2,  369},
        /*1980*/ {33},
        /*1981*/ {1, 2,   96},
        /*1982*/ {1, 2, 1027},
        /*1983*/ {113},
        /*1984*/ {1, 2,  129},
        /*1985*/ {311},
        /*1986*/ {891},
        /*1987*/ {1, 2,   80},
        /*1988*/ {555},
        /*1989*/ {1, 2,  719},
        /*1990*/ {133},
        /*1991*/ {546},
        /*1992*/ {1, 2, 1241},
        /*1993*/ {103},
        /*1994*/ {15},
        /*1995*/ {1, 2,   37},
        /*1996*/ {307},
        /*1997*/ {1, 2,  835},
        /*1998*/ {1, 3, 1290},
        /*1999*/ {367},
        /*2000*/ {1, 2,  981}
    };

    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    static void set1363() {
        use1363 = true;
    }
    
    static void setX9F1() {
        use1363 = false;
    }

    static short[] getIrredArray(int m) {
        return use1363 ? irred1363[m] : irredX9F1[m];
    }

    static GF2m getIrredPoly(int m) {
        short[] deg = use1363 ? irred1363[m] : irredX9F1[m];
        BigInteger val = ZERO.setBit(0).setBit(m);
        return new GF2m(m,
            (deg.length == 1) ? val.setBit(deg[0]) : val.setBit(deg[0]).setBit(deg[1]).setBit(deg[2]));
    }

    static short[] getTraceTable(int m) {
        if (use1363) {
            return (0 < m && m < GFTrace.tr1363.length) ? GFTrace.tr1363[m] : null;
        } else {
            return (0 < m && m < GFTrace.trX9F1.length) ? GFTrace.trX9F1[m] : null;
        }
    }

}
