dnl **********************************************************************
dnl
dnl Copyright (c) 1999
dnl Object Oriented Concepts, Inc.
dnl Billerica, MA, USA
dnl
dnl All Rights Reserved
dnl
dnl **********************************************************************

dnl ----------------------------------------------------------------------
dnl Standard tests
dnl ----------------------------------------------------------------------

AC_CANONICAL_HOST
AC_ISC_POSIX

dnl ----------------------------------------------------------------------
dnl Checks for programs
dnl ----------------------------------------------------------------------

AC_PROG_CC
AC_PROG_CPP
AC_PROG_CXX
AC_PROG_CXXCPP
AC_PROG_MAKE_SET
AC_PROG_INSTALL
AC_PROG_LN_S
AC_PROG_RANLIB
AC_PROG_YACC
AC_PROG_LEX
if test -z "$LEXLIB"
then
    AC_CHECK_LIB(l, yywrap, LEXLIB=-ll)
fi

dnl ----------------------------------------------------------------------
dnl Check for header files
dnl ----------------------------------------------------------------------

AC_CHECK_HEADERS(stdlib.h stddef.h unistd.h)
AC_CHECK_HEADERS(strings.h bstring.h)
AC_CHECK_HEADERS(termio.h termios.h)
AC_CHECK_HEADERS(sys/time.h sys/types.h sys/select.h)
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_CHECK_HEADERS(iostream strstream fstream)
AC_CHECK_HEADERS(exception exception.h terminate.h unexpected.h)
AC_LANG_RESTORE

dnl ----------------------------------------------------------------------
dnl Check for functions
dnl ----------------------------------------------------------------------

AC_CHECK_FUNCS(strerror)
AC_CHECK_FUNCS(strcasecmp)
AC_CHECK_FUNCS(strncasecmp)

dnl ----------------------------------------------------------------------
dnl Check for gethostname prototype
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether there is a prototype for gethostname,
ac_cv_gethostname_has_prototype,
AC_EGREP_HEADER(gethostname, unistd.h,
		ac_cv_gethostname_has_prototype=yes,
		ac_cv_gethostname_has_prototype=no))

if test $ac_cv_gethostname_has_prototype = no
then
    AC_DEFINE(HAVE_NO_GETHOSTNAME_PROTOTYPE)
fi

dnl ----------------------------------------------------------------------
dnl Check for h_errno declaration
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether there is a declaration for h_errno,
ac_cv_h_errno_is_declared,
AC_EGREP_HEADER(h_errno, netdb.h,
		ac_cv_h_errno_is_declared=yes,
		ac_cv_h_errno_is_declared=no))

if test $ac_cv_h_errno_is_declared = no
then
    AC_DEFINE(HAVE_NO_H_ERRNO_DECLARATION)
fi

dnl ----------------------------------------------------------------------
dnl Check for typedefs, structures, and compiler characteristics
dnl ----------------------------------------------------------------------

AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_CHECK_SIZEOF(char, 1)
AC_CHECK_SIZEOF(short, 2)
AC_CHECK_SIZEOF(int, 4)
AC_CHECK_SIZEOF(long, 4)
AC_CHECK_SIZEOF(float, 4)
AC_CHECK_SIZEOF(double, 8)
AC_CHECK_SIZEOF(bool, 1)
AC_C_BIGENDIAN
AC_LANG_RESTORE

dnl ----------------------------------------------------------------------
dnl Find out what the library suffix is
dnl ----------------------------------------------------------------------

AC_MSG_CHECKING(what the library suffix is)
AC_SUBST(LIBEXT)
if test -z "$LIBEXT"
then
    LIBEXT=".a"
fi
AC_MSG_RESULT($LIBEXT)

dnl ----------------------------------------------------------------------
dnl Find out how to create libraries
dnl ----------------------------------------------------------------------

AC_MSG_CHECKING(how to build libraries)
AC_SUBST(AR)
AC_SUBST(ARFLAGS)
if test -z "$AR"
then
    AR="ar"
fi
if test -z "$ARFLAGS"
then
    ARFLAGS="cr"
fi
AC_MSG_RESULT(with $AR $ARFLAGS)

dnl ----------------------------------------------------------------------
dnl Find out how to install libraries
dnl ----------------------------------------------------------------------

AC_MSG_CHECKING(how to install libraries)
AC_SUBST(INSTALL_LIBRARY)
if test -z "$INSTALL_LIBRARY"
then
    if test "$LIBEXT" = ".sl" # HP needs executable shared libs
    then
        INSTALL_LIBRARY="$INSTALL_PROGRAM"
    else
        INSTALL_LIBRARY="$INSTALL_DATA"
    fi
else
    INSTALL_LIBRARY="$INSTALL_DATA"
fi
AC_MSG_RESULT(with $INSTALL_LIBRARY)

