dnl **********************************************************************
dnl
dnl Copyright (c) 1999
dnl Object Oriented Concepts, Inc.
dnl Billerica, MA, USA
dnl
dnl All Rights Reserved
dnl
dnl **********************************************************************

dnl ----------------------------------------------------------------------
dnl Check for SSLeay libraries and headers
dnl ----------------------------------------------------------------------

AC_CHECK_LIB(crypto, main)
if test "$ac_cv_lib_crypto_main" != yes
then
    AC_MSG_ERROR(Can't find crypto library!)
fi

AC_CHECK_LIB(ssl, main)
if test "$ac_cv_lib_ssl_main" != yes
then
    AC_MSG_ERROR(Can't find ssl library!)
fi

dnl
dnl Check locations of headers (which, theoretically, could be used as a quick way of
dnl ascertaining version number (consider using this in the cross-compile case below))
dnl
dnl This works, but could be better if we had a seperate case for
dnl   0.9.3 > currently installed SSL library > 0.8.1b (see below)
dnl

dnl AC_MSG_CHECKING(SSL header)
AC_MSG_CHECKING(OpenSSL or SSLeay)
AC_TRY_CPP([#include <ssl.h>], sslhead="ssl.h" sslver=0, AC_TRY_CPP([#include <openssl/ssl.h>], \
sslhead="openssl/ssl.h" sslver=1, AC_MSG_ERROR(No SSL headers found!)))
dnl AC_MSG_RESULT($sslhead)

dnl The following could be use for individual version testing

dnl AC_MSG_CHECKING(OpenSSL or SSLeay)
dnl AC_TRY_RUN([
dnl #if STDC_HEADERS
dnl # include <stdio.h>
dnl # include <stdlib.h>
dnl #endif 
dnl #include <$sslhead>
dnl int main(void) {
dnl #if defined(OPENSSL_VERSION_NUMBER)
dnl    exit(1);
dnl #else
dnl #if SSLEAY_VERSION_NUMBER >= 0x0900
dnl    exit(2);
dnl #else
dnl    exit(0);
dnl #endif /* SSLEAY_VERSION_NUMBER */
dnl #endif /* OPENSSL_VERSION_NUMBER */
dnl }], sslver=$?, sslver=$?, \
dnl AC_MSG_RESULT(crosscompiling, so we can't check - assuming OpenSSL))

if test $sslver -eq 0
then
 AC_DEFINE(USE_OLD_SSLEAY)
 AC_MSG_RESULT(SSLeay)
else
 AC_MSG_RESULT(OpenSSL)
fi
