# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

PUSHSERVER_NAME	= PushServer.exe
PUSHCLIENT_NAME	= PushClient.exe
PULLCLIENT_NAME	= PullClient.exe
PULLSERVER_NAME	= PullServer.exe

TYPED_PUSHSERVER_NAME = TypedPushServer.exe
TYPED_PUSHCLIENT_NAME = TypedPushClient.exe

FACT_PUSHSERVER_NAME	= FactPushServer.exe
FACT_PUSHCLIENT_NAME	= FactPushClient.exe

FACT_TYPED_PUSHSERVER_NAME = FactTypedPushServer.exe
FACT_TYPED_PUSHCLIENT_NAME = FactTypedPushClient.exe

TARGETS		= $(PUSHSERVER_NAME) \
		  $(PUSHCLIENT_NAME) \
		  $(PULLCLIENT_NAME) \
		  $(PULLSERVER_NAME) \
		  $(TYPED_PUSHSERVER_NAME) \
		  $(TYPED_PUSHCLIENT_NAME) \
		  $(TYPED_PULLCLIENT_NAME) \
		  $(FACT_PUSHSERVER_NAME) \
		  $(FACT_PUSHCLIENT_NAME) \
		  $(FACT_TYPED_PUSHSERVER_NAME) \
		  $(FACT_TYPED_PUSHCLIENT_NAME)


!include $(top_srcdir)\config\Make.rules.mak

COMMON_OBJS	=

PUSHSERVER_OBJS	= PushServer.obj

PUSHCLIENT_OBJS	= PushClient.obj

PULLCLIENT_OBJS	= PullClient.obj

PULLSERVER_OBJS	= PullServer.obj

TYPED_COMMON_OBJS = TimerUpdate.obj

TYPED_PUSHSERVER_OBJS = TypedPushServer.obj

TYPED_PUSHCLIENT_OBJS = TypedPushClient.obj \
			TimerUpdate_skel.obj

FACT_PUSHSERVER_OBJS	= FactPushServer.obj

FACT_PUSHCLIENT_OBJS	= FactPushClient.obj

FACT_TYPED_PUSHSERVER_OBJS = FactTypedPushServer.obj

FACT_TYPED_PUSHCLIENT_OBJS = FactTypedPushClient.obj \
			     TimerUpdate_skel.obj

ALL_CXXFLAGS	= $(CXXFLAGS)
ALL_CPPFLAGS	= /I. /I$(top_srcdir)\include $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(top_srcdir)\lib\CosEvent.lib $(OB_LIBS) $(LIBS)
 
$(PUSHSERVER_NAME): $(COMMON_OBJS) $(PUSHSERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(PUSHSERVER_OBJS) $(ALL_LIBS)

$(PUSHCLIENT_NAME): $(COMMON_OBJS) $(PUSHCLIENT_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(PUSHCLIENT_OBJS) $(ALL_LIBS)

$(PULLCLIENT_NAME): $(COMMON_OBJS) $(PULLCLIENT_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(PULLCLIENT_OBJS) $(ALL_LIBS)

$(PULLSERVER_NAME): $(COMMON_OBJS) $(PULLSERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(PULLSERVER_OBJS) $(ALL_LIBS)

$(TYPED_PUSHCLIENT_NAME): $(COMMON_OBJS) $(TYPED_COMMON_OBJS) \
				$(TYPED_PUSHCLIENT_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(TYPED_COMMON_OBJS) $(TYPED_PUSHCLIENT_OBJS) \
	$(ALL_LIBS)

$(TYPED_PUSHSERVER_NAME): $(COMMON_OBJS) $(TYPED_COMMON_OBJS) \
				$(TYPED_PUSHSERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(TYPED_COMMON_OBJS) $(TYPED_PUSHSERVER_OBJS) \
	$(ALL_LIBS)
 
$(FACT_PUSHSERVER_NAME): $(COMMON_OBJS) $(FACT_PUSHSERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(FACT_PUSHSERVER_OBJS) $(ALL_LIBS)

$(FACT_PUSHCLIENT_NAME): $(COMMON_OBJS) $(FACT_PUSHCLIENT_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(FACT_PUSHCLIENT_OBJS) $(ALL_LIBS)

$(FACT_TYPED_PUSHCLIENT_NAME): $(COMMON_OBJS) $(TYPED_COMMON_OBJS) \
				$(FACT_TYPED_PUSHCLIENT_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(TYPED_COMMON_OBJS) $(FACT_TYPED_PUSHCLIENT_OBJS) \
	$(ALL_LIBS)

$(FACT_TYPED_PUSHSERVER_NAME): $(COMMON_OBJS) $(TYPED_COMMON_OBJS) \
				$(FACT_TYPED_PUSHSERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(TYPED_COMMON_OBJS) $(FACT_TYPED_PUSHSERVER_OBJS) \
	$(ALL_LIBS)

TimerUpdate.cpp TimerUpdate.h: TimerUpdate.idl
	del /q TimerUpdate.cpp
	del /q TimerUpdate.h
	del /q TimerUpdate_skel.cpp
	del /q TimerUpdate_skel.h
	$(IDL) -I. -I$(top_srcdir)\idl --other-header-dir OB --no-type-codes \
	TimerUpdate.idl

TimerUpdate_skel.cpp TimerUpdate_skel.h : TimerUpdate.cpp

!include .windep
