// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/Hashtable.h>
#include <OB/Properties.h>

#include <OB/CosEventChannelAdmin_skel.h>
#include <OB/OBEventChannelFactory_skel.h>

#include <EC_ConsumerAdmin_impl.h>
#include <EC_SupplierAdmin_impl.h>
#include <EC_EventChannel_impl.h>
#include <EventChannelFactory_impl.h>
#include <Event_impl.h>
#include <SetDefaultProperties.h>

// ----------------------------------------------------------------------
// EC_EventChannel_impl constructor and destructor
// ----------------------------------------------------------------------

EC_EventChannel_impl::EC_EventChannel_impl(
    CORBA_ORB_ptr orb, EventChannelFactory_impl* eventChannelFactory,
    const char* myId)
        : orb_(CORBA_ORB::_duplicate(orb)),
          consumerAdmin_(new EC_ConsumerAdmin_impl(orb_, this)),
          supplierAdmin_(new EC_SupplierAdmin_impl(orb_, this)),
          myId_(CORBA_string_dup(myId)),
	  destroyed_(false),
          eventChannelFactory_(eventChannelFactory)
{
    SetDefaultProperties::setDefaults();
}

EC_EventChannel_impl::~EC_EventChannel_impl()
{
    CORBA_release(consumerAdmin_);
    CORBA_release(supplierAdmin_);
}

// ----------------------------------------------------------------------
// EC_EventChannel_impl public member implementation
// ----------------------------------------------------------------------

CosEventChannelAdmin_ConsumerAdmin_ptr
EC_EventChannel_impl::for_consumers()
{
    return CosEventChannelAdmin_ConsumerAdmin::_duplicate(consumerAdmin_);
}

CosEventChannelAdmin_SupplierAdmin_ptr
EC_EventChannel_impl::for_suppliers()
{
    return CosEventChannelAdmin_SupplierAdmin::_duplicate(supplierAdmin_);
}

void
EC_EventChannel_impl::destroy()
{
    JTCSynchronized sync(*this);
    if(destroyed_)
	throw CORBA_OBJECT_NOT_EXIST();
    destroyed_ = true;

    eventChannelFactory_ -> removeChannel(myId_);
    
    orb_ -> disconnect(this);

    consumerAdmin_ -> disconnect();
    supplierAdmin_ -> disconnect();
}

//
// Receive event
//
void
EC_EventChannel_impl::receive(Event_impl* event)
{
    //
    // Forward the event to the consumers
    //
    consumerAdmin_ -> receive(event);

    //
    // We're no longer interested in the event
    //
    event -> discard();
}
