// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_EVENT_CHANNEL_IMPL_H
#define COS_EVENT_CHANNEL_IMPL_H

//
// Forward declaration.
//
class EC_ConsumerAdmin_impl;
class EC_SupplierAdmin_impl;
class Event_impl;
class EventChannelFactory_impl;

//
// The event channel implementation.
//
class EC_EventChannel_impl :
    public CosEventChannelAdmin_EventChannel_skel,
    public JTCRecursiveMutex

{
    //
    // No copy constructor/assignment operator.
    //
    EC_EventChannel_impl(const EC_EventChannel_impl&);
    void operator=(const EC_EventChannel_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    EC_ConsumerAdmin_impl* consumerAdmin_; // The consumer admin.
    
    EC_SupplierAdmin_impl* supplierAdmin_; // The supplier admin.

    CORBA_String_var myId_; // The channel's Id.

    bool destroyed_; // Has the channel been destroyed?

    //
    // The event channel factory.
    //
    EventChannelFactory_impl* eventChannelFactory_;
    
public:

    EC_EventChannel_impl(
	CORBA_ORB_ptr, EventChannelFactory_impl*, const char*);

    ~EC_EventChannel_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    //
    // Return ConsumerAdmin object.
    //
    virtual CosEventChannelAdmin_ConsumerAdmin_ptr for_consumers();

    //
    // Return SupplierAdmin object.
    //
    virtual CosEventChannelAdmin_SupplierAdmin_ptr for_suppliers();

    //
    // Destroy this event channel.
    //
    virtual void destroy();

    //
    // Internal methods.
    //

    //
    // Receive event.
    //
    void receive(Event_impl*);
};

#endif
