// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_PROXY_PULL_CONSUMER_IMPL_H
#define COS_PROXY_PULL_CONSUMER_IMPL_H

//
// Forward declarations.
//
class EC_EventChannel_impl;
class EC_SupplierAdmin_impl;
class PropagatorBaseThread;
typedef JTCHandleT<PropagatorBaseThread> PropagatorBaseThreadHandle;

class EC_ProxyPullConsumer_impl :
    public CosEventChannelAdmin_ProxyPullConsumer_skel,
    public ProxyConsumer_impl,
    public JTCMonitor
{
    CORBA_ORB_var orb_; // The ORB.
    
    CosEventComm_PullSupplier_var supplier_; // My pull supplier.
    
    EC_EventChannel_impl* channel_; // My event channel.
    
    EC_SupplierAdmin_impl* admin_; // My admin.
    
    ProxyState state_; // My state.

    PropagatorBaseThreadHandle puller_; // The event puller.

    CORBA_ULong id_; // My ID.

public:

    EC_ProxyPullConsumer_impl(CORBA_ORB_ptr,
                              EC_EventChannel_impl*,
                              EC_SupplierAdmin_impl*,
                              CORBA_ULong);
    ~EC_ProxyPullConsumer_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual void connect_pull_supplier(CosEventComm_PullSupplier_ptr);

    virtual void disconnect_pull_consumer();

    //
    // Internal methods.
    //

    //
    // Called when the event channel is destroyed.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();

    CORBA_ULong proxyId() const { return id_; }
};

#endif
