// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_PROXY_PUSH_SUPPLIER_IMPL_H
#define COS_PROXY_PUSH_SUPPLIER_IMPL_H

//
// Forward declarations.
//
class EC_SupplierAdmin_impl;
class EC_EventChannel_impl;

//
// The Event Channel ProxyPushConsumer implementation.
//
class EC_ProxyPushConsumer_impl :
    public CosEventChannelAdmin_ProxyPushConsumer_skel,
    public ProxyConsumer_impl,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    EC_ProxyPushConsumer_impl(const EC_ProxyPushConsumer_impl&);
    void operator=(const EC_ProxyPushConsumer_impl&);
    
    CORBA_ORB_var orb_; // The ORB.

    CosEventComm_PushSupplier_var supplier_; // My push supplier.

    EC_EventChannel_impl* channel_; // My event channel.

    EC_SupplierAdmin_impl* admin_; // My admin.

    ProxyState state_; // My state.

    CORBA_ULong id_; // My ID.
    
public:
    
    EC_ProxyPushConsumer_impl(CORBA_ORB_ptr,
                              EC_EventChannel_impl*,
                              EC_SupplierAdmin_impl*,
                              CORBA_ULong);
    ~EC_ProxyPushConsumer_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    virtual void connect_push_supplier(CosEventComm_PushSupplier_ptr);
    
    virtual void disconnect_push_consumer();
    
    virtual void push(const CORBA_Any&);

    //
    // Internal methods.
    //

    //
    // Called when the event channel is destroyed.
    //
    virtual void disconnect();

    //
    // Called to release this object reference.
    //
    virtual void release();
    
    CORBA_ULong proxyId() const { return id_; }
};

#endif
