// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef EVENT_CHANNEL_FACTORY_IMPL_H
#define EVENT_CHANNEL_FACTORY_IMPL_H

//
// Forward declarations
//

class EC_EventChannel_impl;

template <class K, class T, class LS> class OBHashtable;

//
// The event channel factory implementation.
//
class EventChannelFactory_impl
    : public OBEventChannelFactory_EventChannelFactory_skel,
      public JTCMonitor
{
    CORBA_ORB_var orb_; // The ORB.
    CORBA_BOA_var boa_; // The BOA.

    //
    // No copy constructor/assignment operator.
    //
    EventChannelFactory_impl(const EventChannelFactory_impl&);
    void operator=(const EventChannelFactory_impl&);

public: // For some compilers this must be public

    typedef OBHashtable<CORBA_String_var, EC_EventChannel_impl*,
                        OB_LOCK_STRATEGY_SYNCHRONIZED> EventChannelMap;

private:

    //
    // Mapping from CORBA_String_var to EC_EventChannel_impl*
    //
    EventChannelMap* channels_;
    
public:

    EventChannelFactory_impl(CORBA_ORB_ptr, CORBA_BOA_ptr);
    ~EventChannelFactory_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    //
    // Create EventChannel object
    //
    virtual CosEventChannelAdmin_EventChannel_ptr create_channel(const char*);

    //
    // Get EventChannel object by id
    //
    virtual CosEventChannelAdmin_EventChannel_ptr get_channel_by_id(
	const char*);

    //
    // Get EventChannel object ids
    //
    virtual OBEventChannelFactory_ChannelIdSeq* get_channels();

    //
    // Shutdown the event service.
    //
    virtual void shutdown();

    //
    // Internal methods.
    //
    
    //
    // Remove Channel.
    //
    void removeChannel(const char*);
};

#endif
