// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// *********************************************************************

#ifndef EVENT_IMPL_H
#define EVENT_IMPL_H

//
// This represents a reference counted event. An event can either be
// typed, or untyped.
//
class Event_impl
{
    //
    // No copy constructor/assignment operator.
    //
    Event_impl(const Event_impl&);
    void operator=(Event_impl&);

    //
    // For typed event.
    //
    CORBA_NVList_var args_; // The arguments.
    CORBA_String_var op_; // The operation name.

    //
    // For an untyped event.
    //
    CORBA_Any any_; // The event data.
    
    CORBA_ULong id_; // My ID.
    
    JTCMutex refMutex_;
    CORBA_UShort refCount_; // The reference count

    static JTCMutex idMutex_; 
    static CORBA_ULong nextId_; // The event identifier

    //
    // Initialize the event
    //
    void init(CORBA_ULong);
    
public:
    
    Event_impl(const CORBA_Any&, CORBA_ULong);
    Event_impl(CORBA_NVList_ptr, const char*, CORBA_ULong);
    virtual ~Event_impl();

    //
    // For any events.
    //
    const CORBA_Any& any() const { return any_; }

    //
    // For typed events.
    //
    const char* op() const { return op_; }
    CORBA_NVList_ptr args() const { return args_; }
    
    void discard();
    void acquire();

    CORBA_ULong eventId() const { return id_; }
};

typedef OBFixSeq< Event_impl* > EventPtrSeq;

#endif
