# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

LIB_NAME	= $(top_srcdir)\lib\CosEvent.lib
ADMIN_NAME	= $(top_srcdir)\bin\eventadmin.exe
SERVER_NAME	= $(top_srcdir)\bin\eventserv.exe
SERVICE_NAME    = $(top_srcdir)\bin\nteventservice.exe

LIB_PDB_NAME	= $(top_srcdir)\lib\CosEvent.pdb

UTILS           = $(ADMIN_NAME) \
		  $(SERVER_NAME) \
		  $(SERVICE_NAME)
#
# Work around the inference rules problem with nmake.
#
!ifndef BUILD_UTILS

PDB_FLAGS       = /Fd$(LIB_PDB_NAME)
TARGETS		= $(LIB_NAME)

!else

TARGETS 	= $(UTILS)

!endif

!include $(top_srcdir)\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl
HDIR		= $(top_srcdir)\include\OB

LIB_OBJS	= CosEventComm.obj \
		  CosEventChannelAdmin.obj \
		  CosEventComm_skel.obj \
		  CosTypedEventComm.obj \
		  CosTypedEventChannelAdmin.obj \
		  CosTypedEventComm_skel.obj \
		  OBEventChannelFactory.obj \
		  OBTypedEventChannelFactory.obj

COMMON_OBJS	=

ADMIN_OBJS	= EventAdmin.obj

COMMON_SERVICE_OBJS	= \
		  EC_EventChannel_impl.obj \
		  EC_ConsumerAdmin_impl.obj \
		  EC_SupplierAdmin_impl.obj \
		  EC_ProxyPushConsumer_impl.obj \
		  EC_ProxyPushSupplier_impl.obj \
		  EC_ProxyPullSupplier_impl.obj \
		  EC_ProxyPullConsumer_impl.obj \
		  TEC_TypedEventChannel_impl.obj \
		  TEC_TypedConsumerAdmin_impl.obj \
		  TEC_TypedSupplierAdmin_impl.obj \
		  TEC_TypedProxyPushConsumer_impl.obj \
		  TEC_ProxyPushSupplier_impl.obj \
		  Event_impl.obj \
		  PropagatorBaseThread.obj \
		  PusherBaseThread.obj \
		  ProxyConsumer_impl.obj \
		  ProxySupplier_impl.obj \
		  EventUtil.obj \
		  CosEventChannelAdmin_skel.obj \
		  CosTypedEventChannelAdmin_skel.obj \
		  SetDefaultProperties.obj \
		  OBEventChannelFactory_skel.obj \
		  OBTypedEventChannelFactory_skel.obj \
		  EventChannelFactory_impl.obj \
		  TypedEventChannelFactory_impl.obj \
		  QoS.obj

SERVICE_OBJS	= NTEventService.obj \
		  NTServiceMain.obj \
		  EventMsg.res

SERVER_OBJS	= Server.obj

ALL_CXXFLAGS	= $(CXXFLAGS) $(PDB_FLAGS)

ALL_CPPFLAGS	= /I. /I$(top_srcdir)\include $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(LIB_NAME) $(OB_LIBS) $(LIBS)
 
$(LIB_NAME): $(LIB_OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(LIB_OBJS)

$(SERVER_NAME): $(COMMON_OBJS) $(COMMON_SERVICE_OBJS) $(SERVER_OBJS) \
		$(LIB_NAME)
	$(LINK) /fixed:no $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(COMMON_SERVICE_OBJS) $(SERVER_OBJS) $(ALL_LIBS)

$(SERVICE_NAME): $(COMMON_OBJS) $(COMMON_SERVICE_OBJS) $(SERVICE_OBJS) \
		$(LIB_NAME)
	$(LINK) /fixed:no $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(COMMON_SERVICE_OBJS) $(SERVICE_OBJS) \
	$(ALL_LIBS)

$(ADMIN_NAME): $(COMMON_OBJS) $(ADMIN_OBJS) $(LIB_NAME)
	$(LINK) /fixed:no $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(ADMIN_OBJS) $(ALL_LIBS)

CosEventChannelAdmin.cpp $(HDIR)\CosEventChannelAdmin.h: \
					$(IDLDIR)\CosEventChannelAdmin.idl
	del /q CosEventChannelAdmin.cpp
	del /q $(HDIR)\CosEventChannelAdmin.h
	del /q CosEventChannelAdmin_skel.cpp
	del /q $(HDIR)\CosEventChannelAdmin_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
	$(IDLDIR)\CosEventChannelAdmin.idl
	move CosEventChannelAdmin.h $(HDIR)
	move CosEventChannelAdmin_skel.h $(HDIR)

CosEventChannelAdmin_skel.cpp $(HDIR)\CosEventChannelAdmin_skel.h: \
					CosEventChannelAdmin.cpp

CosEventComm.cpp $(HDIR)\CosEventComm.h: $(IDLDIR)\CosEventComm.idl
	del /q CosEventComm.cpp $(HDIR)\CosEventComm.h
	del /q CosEventComm_skel.cpp $(HDIR)\CosEventComm_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
	$(IDLDIR)\CosEventComm.idl
	move CosEventComm.h $(HDIR)
	move CosEventComm_skel.h $(HDIR)

CosEventComm_skel.cpp $(HDIR)\CosEventComm_skel.h: CosEventComm.cpp

CosTypedEventChannelAdmin.cpp $(HDIR)\CosTypedEventChannelAdmin.h: \
					$(IDLDIR)\CosTypedEventChannelAdmin.idl
	del /q CosTypedEventChannelAdmin.cpp
	del /q $(HDIR)\CosTypedEventChannelAdmin.h
	del /q CosTypedEventChannelAdmin_skel.cpp
	del /q $(HDIR)\CosTypedEventChannelAdmin_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
	$(IDLDIR)\CosTypedEventChannelAdmin.idl
	move CosTypedEventChannelAdmin.h $(HDIR)
	move CosTypedEventChannelAdmin_skel.h $(HDIR)

CosTypedEventChannelAdmin_skel.cpp $(HDIR)\CosTypedEventChannelAdmin_skel.h: \
					CosTypedEventChannelAdmin.cpp

CosTypedEventComm.cpp $(HDIR)\CosTypedEventComm.h: \
					$(IDLDIR)\CosTypedEventComm.idl
	del /q CosTypedEventComm.cpp $(HDIR)\CosTypedEventComm.h
	del /q CosTypedEventComm_skel.cpp $(HDIR)\CosTypedEventComm_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
        $(IDLDIR)\CosTypedEventComm.idl
	move CosTypedEventComm.h $(HDIR)
	move CosTypedEventComm_skel.h $(HDIR)

CosTypedEventComm_skel.cpp $(HDIR)\CosTypedEventComm_skel.h: \
					CosTypedEventComm.cpp

OBEventChannelFactory.cpp $(HDIR)\OBEventChannelFactory.h: \
					$(IDLDIR)\OBEventChannelFactory.idl
	del /q OBEventChannelFactory.cpp $(HDIR)\OBEventChannelFactory.h
	del /q OBEventChannelFactory_skel.cpp \
	$(HDIR)\OBEventChannelFactory_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
        $(IDLDIR)\OBEventChannelFactory.idl
	move OBEventChannelFactory.h $(HDIR)
	move OBEventChannelFactory_skel.h $(HDIR)

OBEventChannelFactory_skel.cpp $(HDIR)\OBEventChannelFactory_skel.h: \
					OBEventChannelFactory.cpp

OBTypedEventChannelFactory.cpp $(HDIR)\OBTypedEventChannelFactory.h: \
				$(IDLDIR)\OBTypedEventChannelFactory.idl
	del /q OBTypedEventChannelFactory.cpp \
	$(HDIR)\OBTypedEventChannelFactory.h
	del /q OBTypedEventChannelFactory_skel.cpp \
	$(HDIR)\OBTypedEventChannelFactory_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB \
        $(IDLDIR)\OBTypedEventChannelFactory.idl
	move OBTypedEventChannelFactory.h $(HDIR)
	move OBTypedEventChannelFactory_skel.h $(HDIR)

OBTypedEventChannelFactory_skel.cpp $(HDIR)\OBTypedEventChannelFactory_skel.h:\
				OBTypedEventChannelFactory.cpp

EventMsg.rc : EventMsg.mc
	mc EventMsg.mc

EventMsg.res: EventMsg.rc
	rc -r -fo EventMsg.res EventMsg.rc

EventMsg.h : EventMsg.rc

NTServiceMain : NTEventService.h

NTEventService.cpp : EventMsg.h NTEventService.h \
		EventChannelFactory_impl.h TypedEventChannelFactory_impl.h \
		EC_EventChannel_impl.h TEC_TypedEventChannel_impl.h

Config.h:
	echo /* dummy file */ > $@

!ifndef BUILD_UTILS

install:: all

all depend install clean test::
    $(MAKE) /f Makefile.mak BUILD_UTILS=1 $@

!else

install:: all
	copy $(LIB_NAME) $(libdir)
        copy $(LIB_PDB_NAME) $(libdir)
	copy $(SERVER_NAME) $(bindir)
	copy $(SERVICE_NAME) $(bindir)

!endif

!include .windep
