// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_TYPED_EVENT_CHANNEL_IMPL_H
#define COS_TYPED_EVENT_CHANNEL_IMPL_H

//
// Forward declaration.
//
class TEC_TypedConsumerAdmin_impl;
class TEC_TypedSupplierAdmin_impl;
class Event_impl;
class TypedEventChannelFactory_impl;

//
// The typed event channel implementation.
//
class TEC_TypedEventChannel_impl :
    public CosTypedEventChannelAdmin_TypedEventChannel_skel,
    public JTCRecursiveMutex
{
    //
    // No copy constructor/assignment operator.
    //
    TEC_TypedEventChannel_impl(const TEC_TypedEventChannel_impl&);
    void operator=(const TEC_TypedEventChannel_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    TEC_TypedConsumerAdmin_impl* consumerAdmin_; // The consumer admin.
    
    TEC_TypedSupplierAdmin_impl* supplierAdmin_; // The supplier admin.

    OBStrSeq typeIds_; // Repository IDs for the channel.

    CORBA_String_var myId_; // The channel's Id.

    bool destroyed_; // Has the channel been destroyed?

    //
    // The event channel factory.
    //
    TypedEventChannelFactory_impl* eventChannelFactory_;

    //
    // The interface def for the repository.
    //
    CORBA_InterfaceDef::FullInterfaceDescription_var iface_;

    //
    // Get assigned type-ids for this channel.
    //
    void typeIds(CORBA_InterfaceDef_ptr);
    
public:

    TEC_TypedEventChannel_impl(
	CORBA_ORB_ptr, TypedEventChannelFactory_impl*, const char*);
    ~TEC_TypedEventChannel_impl();

    //
    // Standard IDL to C++ Mapping.
    //

    //
    // Return TypedConsumerAdmin object.
    //
    virtual CosTypedEventChannelAdmin_TypedConsumerAdmin_ptr for_consumers();

    //
    // Return TypedSupplierAdmin object.
    //
    virtual CosTypedEventChannelAdmin_TypedSupplierAdmin_ptr for_suppliers();

    //
    // Destroy this event channel.
    //
    virtual void destroy();
    
    //
    // Internal methods.
    //

    //
    // Receive event from the channel.
    //
    void receive(Event_impl*);

    //
    // Verify if the channel has a compatible typeId assigned.
    //
    bool isCompatible(const char*);

    //
    // Assign the type-id to the channel, if not already assigned.
    //
    bool assignTypeId(const char*);

    //
    // Get the FullIntefaceDescription for the channel type.
    //
    CORBA_InterfaceDef::FullInterfaceDescription* getIface();
};

#endif
