// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef COS_TYPED_SUPPLIER_ADMIN_IMPL_H
#define COS_TYPED_SUPPLIER_ADMIN_IMPL_H

//
// Forward declarations.
//
class ProxyConsumer_impl;
typedef OBFixSeq<ProxyConsumer_impl*> ProxyConsumerPtrSeq;

//
// The typed event channel SupplierAdmin.
//
class TEC_TypedSupplierAdmin_impl :
    public CosTypedEventChannelAdmin_TypedSupplierAdmin_skel,
    public JTCMonitor
{
    //
    // No copy constructor/assignment operator.
    //
    TEC_TypedSupplierAdmin_impl(const TEC_TypedSupplierAdmin_impl&);
    void operator=(const TEC_TypedSupplierAdmin_impl&);
    
    CORBA_ORB_var orb_; // The ORB.
    
    TEC_TypedEventChannel_impl* channel_; // My event channel.

    ProxyConsumerPtrSeq proxies_; // Set of proxies.

    CORBA_ULong nextId_; // The next proxy id.

    bool destroyed_; // Has this admin been destroyed?
    
public:

    TEC_TypedSupplierAdmin_impl(CORBA_ORB_ptr, TEC_TypedEventChannel_impl*);
    ~TEC_TypedSupplierAdmin_impl();

    //
    // Standard IDL to C++ Mapping.
    //
    
    //
    // Get ProxyPushConsumer.
    //
    virtual CosEventChannelAdmin_ProxyPushConsumer_ptr
    obtain_push_consumer();

    //
    // Get ProxyPullConsumer.
    //
    virtual CosEventChannelAdmin_ProxyPullConsumer_ptr
    obtain_pull_consumer();

    //
    // Get ProxyPushConsumer.
    //
    virtual CosTypedEventChannelAdmin_TypedProxyPushConsumer_ptr
    obtain_typed_push_consumer(const char*);

    //
    // Get ProxyPullConsumer.
    //
    virtual CosEventChannelAdmin_ProxyPullConsumer_ptr
    obtain_typed_pull_consumer(const char*);

    //
    // Internal methods.
    //

    //
    // Remove this proxy from my list.
    //
    void removeProxy(ProxyConsumer_impl*);

    //
    // Called from the event channel upon destruction.
    //
    void disconnect();
};

#endif
