// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/Timer.h>
#include <OB/Hashtable.h>
#include <OB/Narrow_impl.h>

#include <OB/OBNaming_skel.h>

#include <Types.h>

#include <stdio.h>
#include <OBNaming_impl.h>
#include <NamingDatabase.h>

#include <Logger.h>

#ifdef HAVE_JTC

// ----------------------------------------------------------------------
// Template instantiations
// ----------------------------------------------------------------------

#ifndef HAVE_NO_EXPLICIT_TEMPLATES

template class JTCHandleT< Logger >;

#else
#ifdef HAVE_PRAGMA_DEFINE
#pragma define(JTCHandleT< Logger >)
#endif
#endif

// ----------------------------------------------------------------------
// Logger constructor/destructor
// ----------------------------------------------------------------------

Logger::Logger(NamingDatabase* store, long interval)
    : store_(store), interval_(interval), stop_(false)
{
}

// ----------------------------------------------------------------------
// Logger public member implementation
// ----------------------------------------------------------------------

void
Logger::halt()
{
    JTCSynchronized sync(*this);
    stop_ = true;
    notify();
}

void
Logger::run()
{
    JTCSynchronized sync(*this);
    while(!stop_)
    {
	try
	{
	    wait(interval_*1000);
	}
	catch(const JTCInterruptedException&)
	{
	}
	if(stop_)
	    continue;
#ifdef OB_TRACE
	OBMessageViewer::instance() -> trace(2, "Compacting database");
#endif
	store_ -> updateJournal();
    }
}

#else

// ----------------------------------------------------------------------
// Logger constructor/destructor
// ----------------------------------------------------------------------

Logger::Logger(NamingDatabase* store, long logSeconds)
    : store_(store)
{
    interval_.tv_sec = logSeconds;
    interval_.tv_usec = 0;
    activate(interval_, true);
}

// ----------------------------------------------------------------------
// Logger public member implementation
// ----------------------------------------------------------------------

void
Logger::notify()
{
#ifdef OB_TRACE
    OBMessageViewer::instance() -> trace(2, "Compacting database");
#endif
    store_ -> updateJournal();
    activate(interval_, true);
}

#endif
