# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

LIB_NAME	= $(top_srcdir)\lib\CosNaming.lib
DUMP_NAME	= $(top_srcdir)\bin\dump.exe
SERVER_NAME	= $(top_srcdir)\bin\nameserv.exe

LIB_PDB_NAME	= $(top_srcdir)\lib\CosNaming.pdb

UTILS		= $(SERVER_NAME) \
		  $(SERVICE_NAME) \
		  $(DUMP_NAME)
#
# Work around the inference rules problem with nmake.
#
!ifndef BUILD_UTILS

PDB_FLAGS       = /Fd$(LIB_PDB_NAME)
TARGETS		= $(LIB_NAME)

!else

TARGETS 	= $(UTILS)

!endif

!include $(top_srcdir)\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl
HDIR		= $(top_srcdir)\include\OB

LIB_OBJS	= CosNaming.obj \
		  CosNaming_skel.obj \
		  OBNaming.obj \
		  OBNaming_skel.obj

COMMON_OBJS	=

CLIENT_OBJS	=

COMMON_SERVER_OBJS = \
		  Types.obj \
		  OBNaming_impl.obj \
		  NamingDatabase.obj \
		  Logger.obj

SERVER_OBJS =	  Server.obj

!if "$(WITH_JTC)" == "yes" # The NT service requires JThreads/C++

SERVICE_NAME	= $(top_srcdir)\bin\ntnameservice.exe

SERVICE_OBJS =	  NTServiceMain.obj \
		  NTNamingService.obj \
		  NamingMsg.res

!endif
		
DUMP_OBJS	= DumpAny.obj

ALL_CXXFLAGS	= $(CXXFLAGS) $(PDB_FLAGS)

ALL_CPPFLAGS	= /I. /I$(top_srcdir)\include $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(LIB_NAME) $(OB_LIBS) $(LIBS)
 
$(LIB_NAME): $(LIB_OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(LIB_OBJS)

$(SERVER_NAME): $(COMMON_OBJS) $(COMMON_SERVER_OBJS) $(SERVER_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(COMMON_SERVER_OBJS) $(SERVER_OBJS) $(ALL_LIBS)

!if "$(WITH_JTC)" == "yes" # The NT service requires JThreads/C++
$(SERVICE_NAME): $(COMMON_OBJS) $(COMMON_SERVER_OBJS) $(SERVICE_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(COMMON_SERVER_OBJS) $(SERVICE_OBJS) $(ALL_LIBS)

!ifdef BUILD_UTILS
all:: $(SERVICE_NAME)
!endif

!endif

$(DUMP_NAME): $(COMMON_OBJS) $(DUMP_OBJS)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(DUMP_OBJS) $(OB_LIBS) $(LIBS)

CosNaming.cpp $(HDIR)\CosNaming.h: $(IDLDIR)\CosNaming.idl
	del /q CosNaming.cpp $(HDIR)\CosNaming.h
	del /q CosNaming_skel.cpp $(HDIR)\CosNaming_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB $(IDLDIR)\CosNaming.idl
	move CosNaming.h $(HDIR)
	move CosNaming_skel.h $(HDIR)

CosNaming_skel.cpp $(HDIR)\CosNaming_skel.h: CosNaming.cpp

Types.cpp Types.h: Types.idl
	del /q Types.cpp Types.h
	$(IDL) -I$(IDLDIR) --other-header-dir OB \
	--no-skeletons Types.idl

OBNaming.cpp $(HDIR)/OBNaming.h: $(IDLDIR)/OBNaming.idl
	del /q OBNaming.cpp $(HDIR)\OBNaming.h
	del /q OBNaming_skel.cpp $(HDIR)\OBNaming_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB $(IDLDIR)\OBNaming.idl
	move OBNaming.h $(HDIR)
	move OBNaming_skel.h $(HDIR)

NamingMsg.rc : NamingMsg.mc
	mc NamingMsg.mc

NamingMsg.res: NamingMsg.rc
	rc -r -fo NamingMsg.res NamingMsg.rc

NamingMsg.h : NamingMsg.rc

NTServiceMain.cpp : NTNamingService.h

NTNamingService.cpp : NamingMsg.h NTNamingService.h OBNaming_impl.h \
                      NamingDatabase.h Logger.h Types.h

Config.h:
	echo /* dummy file */ > $@

!ifndef BUILD_UTILS

install:: all

all depend install clean test::
        $(MAKE) /f Makefile.mak BUILD_UTILS=1 $@

!else

install:: all 
	copy $(LIB_NAME) $(libdir)
	copy $(LIB_PDB_NAME) $(libdir)
	copy $(SERVER_NAME) $(bindir)
!if "$(WITH_JTC)" == "yes" # The NT service requires JThreads/C++
	copy $(SERVICE_NAME) $(bindir)
!endif

!endif

!include .windep
